/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether;

import java.util.Map;
import org.sonatype.aether.RepositorySystemSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationProperties {
    private static final String PREFIX_AETHER = "aether.";
    private static final String PREFIX_CONNECTOR = "aether.connector.";
    public static final String INTERACTIVE = "aether.interactive";
    public static final boolean DEFAULT_INTERACTIVE = false;
    public static final String USER_AGENT = "aether.connector.userAgent";
    public static final String DEFAULT_USER_AGENT = "Aether";
    public static final String CONNECT_TIMEOUT = "aether.connector.connectTimeout";
    public static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    public static final String REQUEST_TIMEOUT = "aether.connector.requestTimeout";
    public static final int DEFAULT_REQUEST_TIMEOUT = 60000;

    private ConfigurationProperties() {
    }

    public static String get(Map<?, ?> properties, String key, String defaultValue) {
        Object value = properties.get(key);
        if (!(value instanceof String)) {
            return defaultValue;
        }
        return (String)value;
    }

    public static String get(RepositorySystemSession session, String key, String defaultValue) {
        return ConfigurationProperties.get(session.getConfigProperties(), key, defaultValue);
    }

    public static int get(Map<?, ?> properties, String key, int defaultValue) {
        Object value = properties.get(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.valueOf((String)value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int get(RepositorySystemSession session, String key, int defaultValue) {
        return ConfigurationProperties.get(session.getConfigProperties(), key, defaultValue);
    }

    public static boolean get(Map<?, ?> properties, String key, boolean defaultValue) {
        Object value = properties.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (!(value instanceof String)) {
            return defaultValue;
        }
        return Boolean.parseBoolean((String)value);
    }

    public static boolean get(RepositorySystemSession session, String key, boolean defaultValue) {
        return ConfigurationProperties.get(session.getConfigProperties(), key, defaultValue);
    }
}

