/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter.collection;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;

public class ProjectTransitivityFilter
extends AbstractArtifactsFilter {
    private boolean excludeTransitive;
    private Set directDependencies;

    public ProjectTransitivityFilter(Set directDependencies, boolean excludeTransitive) {
        this.excludeTransitive = excludeTransitive;
        this.directDependencies = directDependencies;
    }

    public Set filter(Set artifacts) {
        HashSet<Artifact> result = artifacts;
        if (this.excludeTransitive) {
            result = new HashSet<Artifact>();
            Iterator iterator = artifacts.iterator();
            while (iterator.hasNext()) {
                Artifact artifact = (Artifact)iterator.next();
                if (!this.artifactIsADirectDependency(artifact)) continue;
                result.add(artifact);
            }
        }
        return result;
    }

    public boolean artifactIsADirectDependency(Artifact artifact) {
        boolean result = false;
        Iterator iterator = this.directDependencies.iterator();
        while (iterator.hasNext()) {
            Artifact dependency = (Artifact)iterator.next();
            if (!dependency.equals(artifact)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isExcludeTransitive() {
        return this.excludeTransitive;
    }

    public void setExcludeTransitive(boolean excludeTransitive) {
        this.excludeTransitive = excludeTransitive;
    }
}

