/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.tar;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.codehaus.plexus.archiver.tar.TarEntry;
import org.codehaus.plexus.archiver.tar.TarFile;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.attributes.SimpleResourceAttributes;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceWithAttributes;

public class TarResource
extends AbstractPlexusIoResource
implements PlexusIoResourceWithAttributes {
    private final TarFile tarFile;
    private final TarEntry entry;
    private PlexusIoResourceAttributes attributes;

    public TarResource(TarFile tarFile, TarEntry entry) {
        this.tarFile = tarFile;
        this.entry = entry;
        boolean dir = entry.isDirectory();
        this.setName(entry.getName());
        this.setDirectory(dir);
        this.setExisting(true);
        this.setFile(!dir);
        long l = entry.getLastModificationTime();
        this.setLastModified(l == -1L ? 0L : l);
        this.setSize(dir ? -1L : entry.getSize());
    }

    public synchronized PlexusIoResourceAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new SimpleResourceAttributes();
            this.attributes.setUserId(this.entry.getUserId());
            this.attributes.setUserName(this.entry.getUserName());
            this.attributes.setGroupId(this.entry.getGroupId());
            this.attributes.setGroupName(this.entry.getGroupName());
            this.attributes.setOctalMode(this.entry.getMode());
        }
        return this.attributes;
    }

    public synchronized void setAttributes(PlexusIoResourceAttributes attributes) {
        this.attributes = attributes;
    }

    public URL getURL() throws IOException {
        return null;
    }

    public InputStream getContents() throws IOException {
        return this.tarFile.getInputStream(this.entry);
    }
}

