/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.utils.DependencyVersionMap;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.i18n.I18N;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyConvergence
implements EnforcerRule {
    private static Log log;
    private static I18N i18n;

    private DependencyNode getNode(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            DependencyTreeBuilder dependencyTreeBuilder = (DependencyTreeBuilder)helper.getComponent(DependencyTreeBuilder.class);
            ArtifactRepository repository = (ArtifactRepository)helper.evaluate("${localRepository}");
            ArtifactFactory factory = (ArtifactFactory)helper.getComponent(ArtifactFactory.class);
            ArtifactMetadataSource metadataSource = (ArtifactMetadataSource)helper.getComponent(ArtifactMetadataSource.class);
            ArtifactCollector collector = (ArtifactCollector)helper.getComponent(ArtifactCollector.class);
            ArtifactFilter filter = null;
            DependencyNode node = dependencyTreeBuilder.buildDependencyTree(project, repository, factory, metadataSource, filter, collector);
            return node;
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (ComponentLookupException e) {
            throw new EnforcerRuleException("Unable to lookup a component " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (DependencyTreeBuilderException e) {
            throw new EnforcerRuleException("Could not build dependency tree " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        if (log == null) {
            log = helper.getLog();
        }
        try {
            if (i18n == null) {
                i18n = (I18N)helper.getComponent(I18N.class);
            }
            DependencyNode node = this.getNode(helper);
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            DependencyVersionMap visitor = new DependencyVersionMap(project.getArtifact().isRelease(), log);
            node.accept((DependencyNodeVisitor)visitor);
            ArrayList<String> errorMsgs = new ArrayList<String>();
            errorMsgs.addAll(this.getConvergenceErrorMsgs(visitor.getConflictedVersionNumbers()));
            for (CharSequence charSequence : errorMsgs) {
                log.error(charSequence);
            }
            if (errorMsgs.size() > 0) {
                throw new EnforcerRuleException("Failed while enforcing releasability the error(s) are " + errorMsgs);
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (ComponentLookupException e) {
            throw new EnforcerRuleException("Unable to lookup a component " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new EnforcerRuleException(e.getLocalizedMessage(), e);
        }
    }

    private String getFullArtifactName(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
    }

    private StringBuilder buildTreeString(DependencyNode node) {
        ArrayList<String> loc = new ArrayList<String>();
        for (DependencyNode currentNode = node; currentNode != null; currentNode = currentNode.getParent()) {
            loc.add(this.getFullArtifactName(currentNode.getArtifact()));
        }
        Collections.reverse(loc);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < loc.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                builder.append("  ");
            }
            builder.append("+-" + (String)loc.get(i));
            builder.append("\n");
        }
        return builder;
    }

    private List<String> getConvergenceErrorMsgs(List<List<DependencyNode>> errors) {
        ArrayList<String> errorMsgs = new ArrayList<String>();
        for (List<DependencyNode> nodeList : errors) {
            errorMsgs.add(this.buildConvergenceErrorMsg(nodeList));
        }
        return errorMsgs;
    }

    private String buildConvergenceErrorMsg(List<DependencyNode> nodeList) {
        StringBuilder builder = new StringBuilder();
        builder.append("\nDependency convergence error for " + this.getFullArtifactName(nodeList.get(0).getArtifact()) + " paths to dependency are:\n");
        if (nodeList.size() > 0) {
            builder.append((CharSequence)this.buildTreeString(nodeList.get(0)));
        }
        for (DependencyNode node : nodeList.subList(1, nodeList.size())) {
            builder.append("and\n");
            builder.append((CharSequence)this.buildTreeString(node));
        }
        return builder.toString();
    }

    public String getCacheId() {
        return "";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule arg0) {
        return false;
    }
}

