/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shade.org.apache.maven.shared.utils.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xpp3DomUtils {
    public static Xpp3Dom mergeXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive, Boolean childMergeOverride) {
        return dominant != null ? Xpp3DomUtils.merge(dominant, recessive, childMergeOverride) : recessive;
    }

    public static Xpp3Dom mergeXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive) {
        return dominant != null ? Xpp3DomUtils.merge(dominant, recessive, null) : recessive;
    }

    public static Xpp3Dom merge(Xpp3Dom dominant, Xpp3Dom recessive, Boolean childMergeOverride) {
        block9: {
            if (recessive == null || Xpp3DomUtils.isCombineSelfOverride(dominant)) {
                return dominant;
            }
            if (Xpp3DomUtils.isEmpty(dominant.getValue())) {
                dominant.setValue(recessive.getValue());
            }
            for (String attr : recessive.getAttributeNames()) {
                if (!Xpp3DomUtils.isEmpty(dominant.getAttribute(attr))) continue;
                dominant.setAttribute(attr, recessive.getAttribute(attr));
            }
            if (recessive.getChildCount() <= 0) break block9;
            boolean mergeChildren = Xpp3DomUtils.isMergeChildren(dominant, childMergeOverride);
            if (mergeChildren) {
                Map<String, Iterator<Xpp3Dom>> commonChildren = Xpp3DomUtils.getCommonChildren(dominant, recessive);
                for (Xpp3Dom recessiveChild : recessive) {
                    Iterator<Xpp3Dom> it = commonChildren.get(recessiveChild.getName());
                    if (it == null) {
                        dominant.addChild(new Xpp3Dom(recessiveChild));
                        continue;
                    }
                    if (!it.hasNext()) continue;
                    Xpp3Dom dominantChild = it.next();
                    Xpp3DomUtils.merge(dominantChild, recessiveChild, childMergeOverride);
                }
            } else {
                Xpp3Dom[] dominantChildren = dominant.getChildren();
                dominant.childList.clear();
                for (Xpp3Dom child : recessive) {
                    dominant.addChild(new Xpp3Dom(child));
                }
                for (Xpp3Dom aDominantChildren : dominantChildren) {
                    dominant.addChild(aDominantChildren);
                }
            }
        }
        return dominant;
    }

    private static Map<String, Iterator<Xpp3Dom>> getCommonChildren(Xpp3Dom dominant, Xpp3Dom recessive) {
        HashMap<String, Iterator<Xpp3Dom>> commonChildren = new HashMap<String, Iterator<Xpp3Dom>>();
        for (String childName : recessive.childMap.keySet()) {
            List<Xpp3Dom> dominantChildren = dominant.getChildrenList(childName);
            if (dominantChildren.size() <= 0) continue;
            commonChildren.put(childName, dominantChildren.iterator());
        }
        return commonChildren;
    }

    private static boolean isCombineSelfOverride(Xpp3Dom xpp3Dom) {
        String selfMergeMode = xpp3Dom.getAttribute("combine.self");
        return "override".equals(selfMergeMode);
    }

    private static boolean isMergeChildren(Xpp3Dom dominant, Boolean override) {
        return override != null ? override : !Xpp3DomUtils.isMergeChildren(dominant);
    }

    private static boolean isMergeChildren(Xpp3Dom dominant) {
        return "append".equals(dominant.getAttribute("combine.children"));
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

