/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.filter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.maven.plugin.assembly.filter.ContainerDescriptorHandler;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAggregatingDescriptorHandler
implements ContainerDescriptorHandler,
LogEnabled {
    private String filePattern;
    private String outputPath;
    private final String commentChars = "#";
    private boolean overrideFilterAction;
    private final StringWriter aggregateWriter = new StringWriter();
    private final List<String> filenames = new ArrayList<String>();
    private Logger logger;

    public void finalizeArchiveCreation(Archiver archiver) throws ArchiverException {
        this.checkConfig();
        if (this.outputPath.endsWith("/")) {
            throw new ArchiverException("Cannot write aggregated properties to a directory. You must specify a file name in the outputPath configuration for this handler. (handler: " + this.getClass().getName());
        }
        if (this.outputPath.startsWith("/")) {
            this.outputPath = this.outputPath.substring(1);
        }
        File temp = this.writePropertiesFile();
        this.overrideFilterAction = true;
        archiver.addFile(temp, this.outputPath);
        this.overrideFilterAction = false;
    }

    private File writePropertiesFile() throws ArchiverException {
        File f;
        FileWriter writer = null;
        try {
            f = File.createTempFile("maven-assembly-plugin", "tmp");
            f.deleteOnExit();
            writer = new FileWriter(f);
            writer.write("# Aggregated on " + new Date() + " from: ");
            for (String filename : this.filenames) {
                writer.write("\n# " + filename);
            }
            writer.write("\n\n");
            writer.write(this.aggregateWriter.toString());
        }
        catch (IOException e) {
            try {
                throw new ArchiverException("Error adding aggregated properties to finalize archive creation. Reason: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        return f;
    }

    public void finalizeArchiveExtraction(UnArchiver unarchiver) throws ArchiverException {
    }

    public List<String> getVirtualFiles() {
        this.checkConfig();
        return Collections.singletonList(this.outputPath);
    }

    public boolean isSelected(FileInfo fileInfo) throws IOException {
        this.checkConfig();
        if (this.overrideFilterAction) {
            System.out.println("Filtering overridden. Returning true.");
            return true;
        }
        String name = fileInfo.getName();
        name = AssemblyFileUtils.normalizePath(name);
        name = name.replace(File.separatorChar, '/');
        if (fileInfo.isFile() && name.matches(this.filePattern)) {
            this.readProperties(fileInfo);
            this.filenames.add(name);
            return false;
        }
        return true;
    }

    private void checkConfig() {
        if (this.filePattern == null || this.outputPath == null) {
            throw new IllegalStateException("You must configure filePattern and outputPath in your containerDescriptorHandler declaration.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProperties(FileInfo fileInfo) throws IOException {
        StringWriter writer = new StringWriter();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(fileInfo.getContents());
            IOUtil.copy((Reader)reader, (Writer)writer);
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close((Reader)reader);
        String content = writer.toString();
        this.aggregateWriter.write("\n");
        this.aggregateWriter.write(content);
    }

    protected final Logger getLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(1, "");
        }
        return this.logger;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }
}

