/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractBanDependencies;
import org.apache.maven.plugins.enforcer.AbstractVersionEnforcer;
import org.codehaus.plexus.util.StringUtils;

public class BannedDependencies
extends AbstractBanDependencies {
    public List excludes = null;
    public List includes = null;

    protected Set checkDependencies(Set theDependencies, Log log) throws EnforcerRuleException {
        Set included;
        Set excluded = this.checkDependencies(theDependencies, this.excludes);
        if (excluded != null && (included = this.checkDependencies(theDependencies, this.includes)) != null) {
            excluded.removeAll(included);
        }
        return excluded;
    }

    private Set checkDependencies(Set dependencies, List thePatterns) throws EnforcerRuleException {
        HashSet<Artifact> foundMatches = null;
        if (thePatterns != null && thePatterns.size() > 0) {
            for (String pattern : thePatterns) {
                String[] subStrings = pattern.split(":");
                subStrings = StringUtils.stripAll((String[])subStrings);
                for (Artifact artifact : dependencies) {
                    if (!this.compareDependency(subStrings, artifact)) continue;
                    if (foundMatches == null) {
                        foundMatches = new HashSet<Artifact>();
                    }
                    foundMatches.add(artifact);
                }
            }
        }
        return foundMatches;
    }

    protected boolean compareDependency(String[] pattern, Artifact artifact) throws EnforcerRuleException {
        boolean result = false;
        if (pattern.length > 0) {
            boolean bl = result = pattern[0].equals("*") || artifact.getGroupId().equals(pattern[0]);
        }
        if (result && pattern.length > 1) {
            boolean bl = result = pattern[1].equals("*") || artifact.getArtifactId().equals(pattern[1]);
        }
        if (result && pattern.length > 2) {
            if (pattern[2].equals("*") || artifact.getVersion().equals(pattern[2])) {
                result = true;
            } else {
                try {
                    result = AbstractVersionEnforcer.containsVersion(VersionRange.createFromVersionSpec((String)pattern[2]), (ArtifactVersion)new DefaultArtifactVersion(artifact.getBaseVersion()));
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new EnforcerRuleException("Invalid Version Range: ", (Exception)((Object)e));
                }
            }
        }
        if (result && pattern.length > 3) {
            String type = artifact.getType();
            if (type == null || type.equals("")) {
                type = "jar";
            }
            boolean bl = result = pattern[3].equals("*") || type.equals(pattern[3]);
        }
        if (result && pattern.length > 4) {
            String scope = artifact.getScope();
            if (scope == null || scope.equals("")) {
                scope = "compile";
            }
            result = pattern[4].equals("*") || scope.equals(pattern[4]);
        }
        return result;
    }

    public List getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List theExcludes) {
        this.excludes = theExcludes;
    }

    public List getIncludes() {
        return this.includes;
    }

    public void setIncludes(List theIncludes) {
        this.includes = theIncludes;
    }
}

