/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.plugin.surefire.CommonReflector;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.SurefireProperties;
import org.apache.maven.plugin.surefire.booterclient.BooterSerializer;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.ForkNumberBucket;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.AbstractForkInputStream;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.NotifiableTestStream;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.OutputStreamFlushableCommandline;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.TestLessInputStream;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.TestProvidingInputStream;
import org.apache.maven.plugin.surefire.booterclient.output.ForkClient;
import org.apache.maven.plugin.surefire.booterclient.output.ThreadedStreamConsumer;
import org.apache.maven.plugin.surefire.report.DefaultReporterFactory;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.KeyValueSource;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.ProviderFactory;
import org.apache.maven.surefire.booter.Shutdown;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.CommandLineCallable;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.ShutdownHookUtils;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.util.DefaultScanResult;
import org.apache.maven.surefire.util.internal.ConcurrencyUtils;
import org.apache.maven.surefire.util.internal.DaemonThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkStarter {
    private static final long PING_IN_SECONDS = 10L;
    private static final int TIMEOUT_CHECK_PERIOD_MILLIS = 100;
    private static final ThreadFactory FORKED_JVM_DAEMON_THREAD_FACTORY = DaemonThreadFactory.newDaemonThreadFactory((String)"surefire-fork-starter");
    private static final ThreadFactory SHUTDOWN_HOOK_THREAD_FACTORY = DaemonThreadFactory.newDaemonThreadFactory((String)"surefire-jvm-killer-shutdownhook");
    private static final AtomicInteger SYSTEM_PROPERTIES_FILE_COUNTER = new AtomicInteger();
    private final ScheduledExecutorService pingThreadScheduler = ForkStarter.createPingScheduler();
    private final ScheduledExecutorService timeoutCheckScheduler;
    private final Queue<ForkClient> currentForkClients;
    private final int forkedProcessTimeoutInSeconds;
    private final ProviderConfiguration providerConfiguration;
    private final StartupConfiguration startupConfiguration;
    private final ForkConfiguration forkConfiguration;
    private final StartupReportConfiguration startupReportConfiguration;
    private final Log log;
    private final DefaultReporterFactory defaultReporterFactory;
    private final Collection<DefaultReporterFactory> defaultReporterFactories;

    public ForkStarter(ProviderConfiguration providerConfiguration, StartupConfiguration startupConfiguration, ForkConfiguration forkConfiguration, int forkedProcessTimeoutInSeconds, StartupReportConfiguration startupReportConfiguration, Log log) {
        this.forkConfiguration = forkConfiguration;
        this.providerConfiguration = providerConfiguration;
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
        this.startupConfiguration = startupConfiguration;
        this.startupReportConfiguration = startupReportConfiguration;
        this.log = log;
        this.defaultReporterFactory = new DefaultReporterFactory(startupReportConfiguration);
        this.defaultReporterFactory.runStarting();
        this.defaultReporterFactories = new ConcurrentLinkedQueue<DefaultReporterFactory>();
        this.currentForkClients = new ConcurrentLinkedQueue<ForkClient>();
        this.timeoutCheckScheduler = ForkStarter.createTimeoutCheckScheduler();
        this.triggerTimeoutCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult run(SurefireProperties effectiveSystemProperties, DefaultScanResult scanResult) throws SurefireBooterForkException, SurefireExecutionException {
        try {
            Map providerProperties = this.providerConfiguration.getProviderProperties();
            scanResult.writeTo(providerProperties);
            RunResult runResult = this.isForkOnce() ? this.run(effectiveSystemProperties, providerProperties) : this.run(effectiveSystemProperties);
            return runResult;
        }
        finally {
            this.defaultReporterFactory.mergeFromOtherFactories(this.defaultReporterFactories);
            this.defaultReporterFactory.close();
            this.pingThreadScheduler.shutdownNow();
            this.timeoutCheckScheduler.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult run(SurefireProperties effectiveSystemProperties, Map<String, String> providerProperties) throws SurefireBooterForkException {
        DefaultReporterFactory forkedReporterFactory = new DefaultReporterFactory(this.startupReportConfiguration);
        this.defaultReporterFactories.add(forkedReporterFactory);
        TestLessInputStream.TestLessInputStreamBuilder builder = new TestLessInputStream.TestLessInputStreamBuilder();
        PropertiesWrapper props = new PropertiesWrapper(providerProperties);
        TestLessInputStream stream = builder.build();
        ForkClient forkClient = new ForkClient(forkedReporterFactory, this.startupReportConfiguration.getTestVmSystemProperties(), stream);
        Thread shutdown = ForkStarter.createImmediateShutdownHookThread(builder, this.providerConfiguration.getShutdown());
        ScheduledFuture<?> ping = this.triggerPingTimerForShutdown(builder);
        try {
            ShutdownHookUtils.addShutDownHook(shutdown);
            RunResult runResult = this.fork(null, (KeyValueSource)props, forkClient, effectiveSystemProperties, stream, false);
            return runResult;
        }
        finally {
            ShutdownHookUtils.removeShutdownHook(shutdown);
            ping.cancel(true);
            builder.removeStream(stream);
        }
    }

    private RunResult run(SurefireProperties effectiveSystemProperties) throws SurefireBooterForkException {
        return this.forkConfiguration.isReuseForks() ? this.runSuitesForkOnceMultiple(effectiveSystemProperties, this.forkConfiguration.getForkCount()) : this.runSuitesForkPerTestSet(effectiveSystemProperties, this.forkConfiguration.getForkCount());
    }

    private boolean isForkOnce() {
        return this.forkConfiguration.isReuseForks() && (this.forkConfiguration.getForkCount() == 1 || this.hasSuiteXmlFiles());
    }

    private boolean hasSuiteXmlFiles() {
        TestRequest testSuiteDefinition = this.providerConfiguration.getTestSuiteDefinition();
        return testSuiteDefinition != null && testSuiteDefinition.getSuiteXmlFiles() != null && !testSuiteDefinition.getSuiteXmlFiles().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult runSuitesForkOnceMultiple(final SurefireProperties effectiveSystemProperties, int forkCount) throws SurefireBooterForkException {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(forkCount, forkCount, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(forkCount));
        executorService.setThreadFactory(FORKED_JVM_DAEMON_THREAD_FACTORY);
        ConcurrentLinkedQueue<String> tests = new ConcurrentLinkedQueue<String>();
        for (Class<?> clazz : this.getSuitesIterator()) {
            tests.add(clazz.getName());
        }
        final ConcurrentLinkedQueue<TestProvidingInputStream> testStreams = new ConcurrentLinkedQueue<TestProvidingInputStream>();
        int total = StrictMath.min(forkCount, tests.size());
        for (int forkNum = 0; forkNum < total; ++forkNum) {
            testStreams.add(new TestProvidingInputStream(tests));
        }
        ScheduledFuture<?> ping = this.triggerPingTimerForShutdown(testStreams);
        Thread shutdown = ForkStarter.createShutdownHookThread(testStreams, this.providerConfiguration.getShutdown());
        try {
            ShutdownHookUtils.addShutDownHook(shutdown);
            int failFastCount = this.providerConfiguration.getSkipAfterFailureCount();
            final AtomicInteger notifyStreamsToSkipTestsJustNow = new AtomicInteger(failFastCount);
            ArrayList<Future<RunResult>> results = new ArrayList<Future<RunResult>>(forkCount);
            for (final TestProvidingInputStream testProvidingInputStream : testStreams) {
                Callable<RunResult> pf = new Callable<RunResult>(){

                    @Override
                    public RunResult call() throws Exception {
                        DefaultReporterFactory reporter = new DefaultReporterFactory(ForkStarter.this.startupReportConfiguration);
                        ForkStarter.this.defaultReporterFactories.add(reporter);
                        Properties vmProps = ForkStarter.this.startupReportConfiguration.getTestVmSystemProperties();
                        ForkClient forkClient = new ForkClient(reporter, vmProps, testProvidingInputStream){

                            protected void stopOnNextTest() {
                                if (ConcurrencyUtils.countDownToZero((AtomicInteger)notifyStreamsToSkipTestsJustNow)) {
                                    ForkStarter.notifyStreamsToSkipTests(testStreams);
                                }
                            }
                        };
                        return ForkStarter.this.fork(null, (KeyValueSource)new PropertiesWrapper(ForkStarter.this.providerConfiguration.getProviderProperties()), forkClient, effectiveSystemProperties, testProvidingInputStream, true);
                    }
                };
                results.add(executorService.submit(pf));
            }
            RunResult runResult = ForkStarter.awaitResultsDone(results, executorService);
            return runResult;
        }
        finally {
            ShutdownHookUtils.removeShutdownHook(shutdown);
            ping.cancel(true);
            this.closeExecutor(executorService);
        }
    }

    private static void notifyStreamsToSkipTests(Collection<? extends NotifiableTestStream> notifiableTestStreams) {
        for (NotifiableTestStream notifiableTestStream : notifiableTestStreams) {
            notifiableTestStream.skipSinceNextTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult runSuitesForkPerTestSet(final SurefireProperties effectiveSystemProperties, int forkCount) throws SurefireBooterForkException {
        ArrayList<Future<RunResult>> results = new ArrayList<Future<RunResult>>(500);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(forkCount, forkCount, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        executorService.setThreadFactory(FORKED_JVM_DAEMON_THREAD_FACTORY);
        final TestLessInputStream.TestLessInputStreamBuilder builder = new TestLessInputStream.TestLessInputStreamBuilder();
        ScheduledFuture<?> ping = this.triggerPingTimerForShutdown(builder);
        Thread shutdown = ForkStarter.createCachableShutdownHookThread(builder, this.providerConfiguration.getShutdown());
        try {
            ShutdownHookUtils.addShutDownHook(shutdown);
            int failFastCount = this.providerConfiguration.getSkipAfterFailureCount();
            final AtomicInteger notifyStreamsToSkipTestsJustNow = new AtomicInteger(failFastCount);
            for (final Class<?> testSet : this.getSuitesIterator()) {
                Callable<RunResult> pf = new Callable<RunResult>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public RunResult call() throws Exception {
                        DefaultReporterFactory forkedReporterFactory = new DefaultReporterFactory(ForkStarter.this.startupReportConfiguration);
                        ForkStarter.this.defaultReporterFactories.add(forkedReporterFactory);
                        Properties vmProps = ForkStarter.this.startupReportConfiguration.getTestVmSystemProperties();
                        ForkClient forkClient = new ForkClient(forkedReporterFactory, vmProps, builder.getImmediateCommands()){

                            protected void stopOnNextTest() {
                                if (ConcurrencyUtils.countDownToZero((AtomicInteger)notifyStreamsToSkipTestsJustNow)) {
                                    builder.getCachableCommands().skipSinceNextTest();
                                }
                            }
                        };
                        TestLessInputStream stream = builder.build();
                        try {
                            RunResult runResult = ForkStarter.this.fork(testSet, (KeyValueSource)new PropertiesWrapper(ForkStarter.this.providerConfiguration.getProviderProperties()), forkClient, effectiveSystemProperties, stream, false);
                            return runResult;
                        }
                        finally {
                            builder.removeStream(stream);
                        }
                    }
                };
                results.add(executorService.submit(pf));
            }
            RunResult runResult = ForkStarter.awaitResultsDone(results, executorService);
            return runResult;
        }
        finally {
            ShutdownHookUtils.removeShutdownHook(shutdown);
            ping.cancel(true);
            this.closeExecutor(executorService);
        }
    }

    private static RunResult awaitResultsDone(Collection<Future<RunResult>> results, ExecutorService executorService) throws SurefireBooterForkException {
        RunResult globalResult = new RunResult(0, 0, 0, 0);
        for (Future<RunResult> result : results) {
            try {
                RunResult cur = result.get();
                if (cur != null) {
                    globalResult = globalResult.aggregate(cur);
                    continue;
                }
                throw new SurefireBooterForkException("No results for " + result.toString());
            }
            catch (InterruptedException e) {
                executorService.shutdownNow();
                Thread.currentThread().interrupt();
                throw new SurefireBooterForkException("Interrupted", (Throwable)e);
            }
            catch (ExecutionException e) {
                Throwable realException = e.getCause();
                String error = realException == null ? "" : realException.getLocalizedMessage();
                throw new SurefireBooterForkException("ExecutionException " + error, realException);
            }
        }
        return globalResult;
    }

    private void closeExecutor(ExecutorService executorService) throws SurefireBooterForkException {
        executorService.shutdown();
        try {
            executorService.awaitTermination(3600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SurefireBooterForkException("Interrupted", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult fork(Object testSet, KeyValueSource providerProperties, ForkClient forkClient, SurefireProperties effectiveSystemProperties, AbstractForkInputStream testProvidingInputStream, boolean readTestsFromInStream) throws SurefireBooterForkException {
        int forkNumber = ForkNumberBucket.drawNumber();
        try {
            RunResult runResult = this.fork(testSet, providerProperties, forkClient, effectiveSystemProperties, forkNumber, testProvidingInputStream, readTestsFromInStream);
            return runResult;
        }
        finally {
            ForkNumberBucket.returnNumber(forkNumber);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RunResult fork(Object testSet, KeyValueSource providerProperties, ForkClient forkClient, SurefireProperties effectiveSystemProperties, int forkNumber, AbstractForkInputStream testProvidingInputStream, boolean readTestsFromInStream) throws SurefireBooterForkException {
        File systPropsFile;
        File surefireProperties;
        try {
            BooterSerializer booterSerializer = new BooterSerializer(this.forkConfiguration);
            surefireProperties = booterSerializer.serialize(providerProperties, this.providerConfiguration, this.startupConfiguration, testSet, readTestsFromInStream);
            if (effectiveSystemProperties != null) {
                SurefireProperties filteredProperties = AbstractSurefireMojo.createCopyAndReplaceForkNumPlaceholder(effectiveSystemProperties, forkNumber);
                systPropsFile = SystemPropertyManager.writePropertiesFile((Properties)filteredProperties, (File)this.forkConfiguration.getTempDirectory(), (String)("surefire_" + SYSTEM_PROPERTIES_FILE_COUNTER.getAndIncrement()), (boolean)this.forkConfiguration.isDebug());
            } else {
                systPropsFile = null;
            }
        }
        catch (IOException e) {
            throw new SurefireBooterForkException("Error creating properties files for forking", (Throwable)e);
        }
        Classpath bootClasspathConfiguration = this.startupConfiguration.isProviderMainClass() ? this.startupConfiguration.getClasspathConfiguration().getProviderClasspath() : this.forkConfiguration.getBootClasspath();
        Classpath bootClasspath = Classpath.join((Classpath)Classpath.join((Classpath)bootClasspathConfiguration, (Classpath)this.startupConfiguration.getClasspathConfiguration().getTestClasspath()), (Classpath)this.startupConfiguration.getClasspathConfiguration().getProviderClasspath());
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)bootClasspath.getLogMessage("boot"));
            this.log.debug((CharSequence)bootClasspath.getCompactLogMessage("boot(compact)"));
        }
        OutputStreamFlushableCommandline cli = this.forkConfiguration.createCommandLine(bootClasspath.getClassPath(), this.startupConfiguration, forkNumber);
        InputStreamCloser inputStreamCloser = new InputStreamCloser(testProvidingInputStream);
        Thread inputStreamCloserHook = DaemonThreadFactory.newDaemonThread((Runnable)inputStreamCloser, (String)"input-stream-closer");
        testProvidingInputStream.setFlushReceiverProvider(cli);
        ShutdownHookUtils.addShutDownHook(inputStreamCloserHook);
        cli.createArg().setFile(surefireProperties);
        if (systPropsFile != null) {
            cli.createArg().setFile(systPropsFile);
        }
        ThreadedStreamConsumer threadedStreamConsumer = new ThreadedStreamConsumer(forkClient);
        if (this.forkConfiguration.isDebug()) {
            System.out.println("Forking command line: " + cli);
        }
        RunResult runResult = null;
        try {
            try {
                CommandLineCallable future = CommandLineUtils.executeCommandLineAsCallable(cli, testProvidingInputStream, threadedStreamConsumer, threadedStreamConsumer, 0, inputStreamCloser, Charset.forName("ISO-8859-1"));
                this.currentForkClients.add(forkClient);
                int result = future.call();
                if (forkClient.hadTimeout()) {
                    runResult = RunResult.timeout((RunResult)forkClient.getDefaultReporterFactory().getGlobalRunStatistics().getRunResult());
                } else if (result != 0) {
                    throw new SurefireBooterForkException("Error occurred in starting fork, check output in log");
                }
                Object var20_21 = null;
            }
            catch (CommandLineException e) {
                runResult = RunResult.failure((RunResult)forkClient.getDefaultReporterFactory().getGlobalRunStatistics().getRunResult(), (Exception)e);
                throw new SurefireBooterForkException("Error while executing forked tests.", e.getCause());
            }
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            this.currentForkClients.remove(forkClient);
            threadedStreamConsumer.close();
            inputStreamCloser.run();
            ShutdownHookUtils.removeShutdownHook(inputStreamCloserHook);
            if (runResult == null) {
                runResult = forkClient.getDefaultReporterFactory().getGlobalRunStatistics().getRunResult();
            }
            if (!runResult.isTimeout()) {
                StackTraceWriter errorInFork = forkClient.getErrorInFork();
                if (errorInFork != null) {
                    throw new RuntimeException("There was an error in the forked process\n" + errorInFork.writeTraceToString());
                }
                if (!forkClient.isSaidGoodBye()) {
                    throw new RuntimeException("The forked VM terminated without properly saying goodbye. VM crash or System.exit called?\nCommand was " + cli.toString());
                }
            }
            forkClient.close(runResult.isTimeout());
            throw throwable;
        }
        this.currentForkClients.remove(forkClient);
        threadedStreamConsumer.close();
        inputStreamCloser.run();
        ShutdownHookUtils.removeShutdownHook(inputStreamCloserHook);
        if (runResult == null) {
            runResult = forkClient.getDefaultReporterFactory().getGlobalRunStatistics().getRunResult();
        }
        if (!runResult.isTimeout()) {
            StackTraceWriter errorInFork = forkClient.getErrorInFork();
            if (errorInFork != null) {
                throw new RuntimeException("There was an error in the forked process\n" + errorInFork.writeTraceToString());
            }
            if (!forkClient.isSaidGoodBye()) {
                throw new RuntimeException("The forked VM terminated without properly saying goodbye. VM crash or System.exit called?\nCommand was " + cli.toString());
            }
        }
        forkClient.close(runResult.isTimeout());
        return runResult;
    }

    private Iterable<Class<?>> getSuitesIterator() throws SurefireBooterForkException {
        try {
            ClasspathConfiguration classpathConfiguration = this.startupConfiguration.getClasspathConfiguration();
            ClassLoader unifiedClassLoader = classpathConfiguration.createMergedClassLoader();
            CommonReflector commonReflector = new CommonReflector(unifiedClassLoader);
            Object reporterFactory = commonReflector.createReportingReporterFactory(this.startupReportConfiguration);
            ProviderFactory providerFactory = new ProviderFactory(this.startupConfiguration, this.providerConfiguration, unifiedClassLoader, reporterFactory);
            SurefireProvider surefireProvider = providerFactory.createProvider(false);
            return surefireProvider.getSuites();
        }
        catch (SurefireExecutionException e) {
            throw new SurefireBooterForkException("Unable to create classloader to find test suites", (Throwable)e);
        }
    }

    private static Thread createImmediateShutdownHookThread(final TestLessInputStream.TestLessInputStreamBuilder builder, final Shutdown shutdownType) {
        return SHUTDOWN_HOOK_THREAD_FACTORY.newThread(new Runnable(){

            public void run() {
                builder.getImmediateCommands().shutdown(shutdownType);
            }
        });
    }

    private static Thread createCachableShutdownHookThread(final TestLessInputStream.TestLessInputStreamBuilder builder, final Shutdown shutdownType) {
        return SHUTDOWN_HOOK_THREAD_FACTORY.newThread(new Runnable(){

            public void run() {
                builder.getCachableCommands().shutdown(shutdownType);
            }
        });
    }

    private static Thread createShutdownHookThread(final Iterable<TestProvidingInputStream> streams, final Shutdown shutdownType) {
        return SHUTDOWN_HOOK_THREAD_FACTORY.newThread(new Runnable(){

            public void run() {
                for (TestProvidingInputStream stream : streams) {
                    stream.shutdown(shutdownType);
                }
            }
        });
    }

    private static ScheduledExecutorService createPingScheduler() {
        ThreadFactory threadFactory = DaemonThreadFactory.newDaemonThreadFactory((String)"ping-timer-10sec");
        return Executors.newScheduledThreadPool(1, threadFactory);
    }

    private static ScheduledExecutorService createTimeoutCheckScheduler() {
        ThreadFactory threadFactory = DaemonThreadFactory.newDaemonThreadFactory((String)"timeout-check-timer");
        return Executors.newScheduledThreadPool(1, threadFactory);
    }

    private ScheduledFuture<?> triggerPingTimerForShutdown(final TestLessInputStream.TestLessInputStreamBuilder builder) {
        return this.pingThreadScheduler.scheduleAtFixedRate(new Runnable(){

            public void run() {
                builder.getImmediateCommands().noop();
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    private ScheduledFuture<?> triggerPingTimerForShutdown(final Iterable<TestProvidingInputStream> streams) {
        return this.pingThreadScheduler.scheduleAtFixedRate(new Runnable(){

            public void run() {
                for (TestProvidingInputStream stream : streams) {
                    stream.noop();
                }
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    private ScheduledFuture<?> triggerTimeoutCheck() {
        return this.pingThreadScheduler.scheduleAtFixedRate(new Runnable(){

            public void run() {
                long systemTime = System.currentTimeMillis();
                for (ForkClient forkClient : ForkStarter.this.currentForkClients) {
                    forkClient.tryToTimeout(systemTime, ForkStarter.this.forkedProcessTimeoutInSeconds);
                }
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private static class InputStreamCloser
    implements Runnable {
        private final AtomicReference<InputStream> testProvidingInputStream;

        public InputStreamCloser(InputStream testProvidingInputStream) {
            this.testProvidingInputStream = new AtomicReference<InputStream>(testProvidingInputStream);
        }

        public void run() {
            InputStream stream = this.testProvidingInputStream.getAndSet(null);
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

