/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.Iterator;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractStandardEnforcerRule;
import org.apache.maven.profiles.activation.OperatingSystemProfileActivator;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;

public class RequireOS
extends AbstractStandardEnforcerRule {
    public String family = null;
    public String name = null;
    public String version = null;
    public String arch = null;
    public String message = "";
    public boolean display = false;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        this.displayOSInfo(helper.getLog(), this.display);
        if (this.allParamsEmpty()) {
            throw new EnforcerRuleException("All parameters can not be empty. You must pick at least one of (family, name, version, arch) or use -Denforcer.os.display=true to see the current OS information.");
        }
        if (this.isValidFamily(this.family)) {
            if (!this.isAllowed()) {
                if (StringUtils.isEmpty((String)this.message)) {
                    this.message = "OS Arch: " + Os.OS_ARCH + " Family: " + Os.OS_FAMILY + " Name: " + Os.OS_NAME + " Version: " + Os.OS_VERSION + " is not allowed by" + (this.arch != null ? " Arch=" + this.arch : "") + (this.family != null ? " Family=" + this.family : "") + (this.name != null ? " Name=" + this.name : "") + (this.version != null ? " Version=" + this.version : "");
                }
                throw new EnforcerRuleException(this.message);
            }
        } else {
            StringBuffer buffer = new StringBuffer(50);
            Iterator iter = Os.getValidFamilies().iterator();
            while (iter.hasNext()) {
                buffer.append(iter.next());
                buffer.append(", ");
            }
            String help = StringUtils.stripEnd((String)buffer.toString().trim(), (String)".");
            throw new EnforcerRuleException("Invalid Family type used. Valid family types are: " + help);
        }
    }

    public void displayOSInfo(Log log, boolean info) {
        String string = "OS Info: Arch: " + Os.OS_ARCH + " Family: " + Os.OS_FAMILY + " Name: " + Os.OS_NAME + " Version: " + Os.OS_VERSION;
        if (!info) {
            log.debug((CharSequence)string);
        } else {
            log.info((CharSequence)string);
        }
    }

    public boolean isAllowed() {
        OperatingSystemProfileActivator activator = new OperatingSystemProfileActivator();
        return activator.isActive(this.createProfile());
    }

    public boolean allParamsEmpty() {
        return StringUtils.isEmpty((String)this.family) && StringUtils.isEmpty((String)this.arch) && StringUtils.isEmpty((String)this.name) && StringUtils.isEmpty((String)this.version);
    }

    private Profile createProfile() {
        Profile profile = new Profile();
        profile.setActivation(this.createActivation());
        return profile;
    }

    private Activation createActivation() {
        Activation activation = new Activation();
        activation.setActiveByDefault(false);
        activation.setOs(this.createOsBean());
        return activation;
    }

    private ActivationOS createOsBean() {
        ActivationOS os = new ActivationOS();
        os.setArch(this.arch);
        os.setFamily(this.family);
        os.setName(this.name);
        os.setVersion(this.version);
        return os;
    }

    public boolean isValidFamily(String theFamily) {
        return StringUtils.isEmpty((String)(theFamily = StringUtils.stripStart((String)theFamily, (String)"!"))) || Os.getValidFamilies().contains(theFamily);
    }

    public String getArch() {
        return this.arch;
    }

    public void setArch(String theArch) {
        this.arch = theArch;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String theFamily) {
        this.family = theFamily;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String theVersion) {
        this.version = theVersion;
    }

    public String getCacheId() {
        StringBuffer b = new StringBuffer();
        if (StringUtils.isNotEmpty((String)this.version)) {
            b.append(this.version.hashCode());
        }
        if (StringUtils.isNotEmpty((String)this.name)) {
            b.append(this.name.hashCode());
        }
        if (StringUtils.isNotEmpty((String)this.arch)) {
            b.append(this.arch.hashCode());
        }
        if (StringUtils.isNotEmpty((String)this.family)) {
            b.append(this.family.hashCode());
        }
        return b.toString();
    }

    public boolean isCacheable() {
        return true;
    }

    public boolean isResultValid(EnforcerRule theCachedRule) {
        return true;
    }
}

