/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyConflict;
import org.apache.ivy.ant.IvyDependency;
import org.apache.ivy.ant.IvyExclude;
import org.apache.ivy.ant.IvyResolve;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.FilterHelper;
import org.apache.tools.ant.BuildException;

public abstract class IvyPostResolveTask
extends IvyTask {
    private String conf;
    private boolean haltOnFailure = true;
    private boolean transitive = true;
    private boolean inline = false;
    private String organisation;
    private String branch = null;
    private String module;
    private String revision = "latest.integration";
    private String resolveId;
    private String type;
    private File file;
    private Filter artifactFilter = null;
    private boolean useOrigin = false;
    private Boolean keep = null;
    private boolean refresh = false;
    private String resolveMode = null;
    private String log = "default";
    private boolean changing = false;
    private IvyResolve resolve = new IvyResolve();

    public boolean isUseOrigin() {
        return this.useOrigin;
    }

    public void setUseOrigin(boolean bl) {
        this.useOrigin = bl;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String string) {
        this.log = string;
    }

    public IvyDependency createDependency() {
        return this.resolve.createDependency();
    }

    public IvyExclude createExclude() {
        return this.resolve.createExclude();
    }

    public IvyConflict createConflict() {
        return this.resolve.createConflict();
    }

    protected void prepareAndCheck() {
        Object[] objectArray;
        Ivy ivy = this.getIvyInstance();
        IvySettings ivySettings = ivy.getSettings();
        boolean bl = this.organisation != null && this.module != null;
        this.organisation = this.getProperty(this.organisation, ivySettings, "ivy.organisation");
        this.module = this.getProperty(this.module, ivySettings, "ivy.module");
        if (this.file == null && (objectArray = this.getProperty(ivySettings, "ivy.resolved.file", this.resolveId)) != null) {
            this.file = this.getProject().resolveFile((String)objectArray);
        }
        if (this.isInline()) {
            String string = this.conf = this.conf == null ? "*" : this.conf;
            if (this.organisation == null) {
                throw new BuildException("no organisation provided for ivy cache task in inline mode: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property");
            }
            if (this.module == null) {
                throw new BuildException("no module name provided for ivy cache task in inline mode: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property");
            }
            objectArray = this.getConfsToResolve(this.getOrganisation(), this.getModule() + "-caller", this.conf, true);
            for (int i = 0; i < objectArray.length; ++i) {
                if (!"*".equals(objectArray[i])) continue;
                objectArray[i] = "*(public)";
            }
            if (objectArray.length > 0) {
                Message.verbose("using inline mode to resolve " + this.getOrganisation() + " " + this.getModule() + " " + this.getRevision() + " (" + StringUtils.join(objectArray, ", ") + ")");
                IvyResolve ivyResolve = this.setupResolve(this.isHaltonfailure(), this.isUseOrigin());
                ivyResolve.setOrganisation(this.getOrganisation());
                ivyResolve.setModule(this.getModule());
                ivyResolve.setBranch(this.getBranch());
                ivyResolve.setRevision(this.getRevision());
                ivyResolve.setInline(true);
                ivyResolve.setChanging(this.isChanging());
                ivyResolve.setConf(this.conf);
                ivyResolve.setResolveId(this.resolveId);
                ivyResolve.setTransitive(this.isTransitive());
                ivyResolve.execute();
            } else {
                Message.verbose("inline resolve already done for " + this.getOrganisation() + " " + this.getModule() + " " + this.getRevision() + " (" + this.conf + ")");
            }
            if ("*".equals(this.conf)) {
                this.conf = StringUtils.join(this.getResolvedConfigurations(this.getOrganisation(), this.getModule() + "-caller", true), ", ");
            }
        } else {
            Message.debug("using standard ensure resolved");
            if (!bl) {
                this.ensureResolved(ivySettings);
            }
            this.conf = this.getProperty(this.conf, ivySettings, "ivy.resolved.configurations");
            if ("*".equals(this.conf)) {
                this.conf = this.getProperty(ivySettings, "ivy.resolved.configurations");
                if (this.conf == null) {
                    throw new BuildException("bad conf provided for ivy cache task: '*' can only be used with a prior call to <resolve/>");
                }
            }
        }
        this.organisation = this.getProperty(this.organisation, ivySettings, "ivy.organisation");
        this.module = this.getProperty(this.module, ivySettings, "ivy.module");
        if (this.organisation == null) {
            throw new BuildException("no organisation provided for ivy cache task: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property or a prior call to <resolve/>");
        }
        if (this.module == null) {
            throw new BuildException("no module name provided for ivy cache task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
        }
        if (this.conf == null) {
            throw new BuildException("no conf provided for ivy cache task: It can either be set explicitely via the attribute 'conf' or via 'ivy.resolved.configurations' property or a prior call to <resolve/>");
        }
        this.artifactFilter = FilterHelper.getArtifactTypeFilter(this.type);
    }

    protected void ensureResolved(IvySettings ivySettings) {
        String string = this.getProperty(this.getConf(), ivySettings, "ivy.resolved.configurations");
        Object[] objectArray = null;
        objectArray = this.getResolveId() != null ? this.getConfsToResolve(this.getResolveId(), string) : this.getConfsToResolve(this.getOrganisation(), this.getModule(), string, false);
        if (objectArray.length > 0) {
            IvyResolve ivyResolve = this.setupResolve(this.isHaltonfailure(), this.isUseOrigin());
            ivyResolve.setFile(this.getFile());
            ivyResolve.setTransitive(this.isTransitive());
            ivyResolve.setConf(StringUtils.join(objectArray, ", "));
            ivyResolve.setResolveId(this.getResolveId());
            ivyResolve.execute();
        }
    }

    protected String[] getConfsToResolve(String string, String string2, String string3, boolean bl) {
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)this.getResolvedDescriptor(string, string2, bl);
        String[] stringArray = this.getResolvedConfigurations(string, string2, bl);
        return this.getConfsToResolve(moduleDescriptor, string3, stringArray);
    }

    protected String[] getConfsToResolve(String string, String string2) {
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)this.getResolvedDescriptor(string, false);
        if (moduleDescriptor == null) {
            if (string2 == null) {
                return new String[]{"*"};
            }
            return this.splitConfs(string2);
        }
        String[] stringArray = (String[])this.getProject().getReference("ivy.resolved.configurations.ref." + string);
        return this.getConfsToResolve(moduleDescriptor, string2, stringArray);
    }

    private String[] getConfsToResolve(ModuleDescriptor moduleDescriptor, String string, String[] stringArray) {
        Message.debug("calculating configurations to resolve");
        if (moduleDescriptor == null) {
            Message.debug("module not yet resolved, all confs still need to be resolved");
            if (string == null) {
                return new String[]{"*"};
            }
            return this.splitConfs(string);
        }
        if (string != null) {
            String[] stringArray2 = "*".equals(string) ? moduleDescriptor.getConfigurationsNames() : this.splitConfs(string);
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
            ResolutionCacheManager resolutionCacheManager = this.getSettings().getResolutionCacheManager();
            Object object = hashSet.iterator();
            while (object.hasNext()) {
                File file;
                String string2 = object.next();
                String string3 = this.getResolveId();
                if (string3 == null) {
                    string3 = ResolveOptions.getDefaultResolveId(moduleDescriptor);
                }
                if ((file = resolutionCacheManager.getConfigurationResolveReportInCache(string3, string2)).exists()) continue;
                object.remove();
            }
            object = new HashSet<String>(Arrays.asList(stringArray2));
            Message.debug("resolved configurations:   " + hashSet);
            Message.debug("asked configurations:      " + object);
            ((AbstractSet)object).removeAll(hashSet);
            Message.debug("to resolve configurations: " + object);
            return ((HashSet)object).toArray(new String[((HashSet)object).size()]);
        }
        Message.debug("module already resolved, no configuration to resolve");
        return new String[0];
    }

    protected IvyResolve setupResolve(boolean bl, boolean bl2) {
        Message.verbose("no resolved descriptor found: launching default resolve");
        this.resolve.setTaskName(this.getTaskName());
        this.resolve.setProject(this.getProject());
        this.resolve.setHaltonfailure(bl);
        this.resolve.setUseOrigin(bl2);
        this.resolve.setValidate(this.doValidate(this.getSettings()));
        this.resolve.setKeep(this.isKeep());
        this.resolve.setRefresh(this.isRefresh());
        this.resolve.setLog(this.getLog());
        this.resolve.setSettingsRef(this.getSettingsRef());
        this.resolve.setResolveMode(this.getResolveMode());
        return this.resolve;
    }

    protected ModuleRevisionId getResolvedMrid() {
        return new ModuleRevisionId(this.getResolvedModuleId(), this.getRevision() == null ? Ivy.getWorkingRevision() : this.getRevision());
    }

    protected ModuleId getResolvedModuleId() {
        return this.isInline() ? new ModuleId(this.getOrganisation(), this.getModule() + "-caller") : new ModuleId(this.getOrganisation(), this.getModule());
    }

    protected ResolveReport getResolvedReport() {
        return this.getResolvedReport(this.getOrganisation(), this.isInline() ? this.getModule() + "-caller" : this.getModule(), this.resolveId);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getConf() {
        return this.conf;
    }

    public void setConf(String string) {
        this.conf = string;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String string) {
        this.organisation = string;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String string) {
        this.branch = string;
    }

    public boolean isHaltonfailure() {
        return this.haltOnFailure;
    }

    public void setHaltonfailure(boolean bl) {
        this.haltOnFailure = bl;
    }

    public void setCache(File file) {
        this.cacheAttributeNotSupported();
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public Filter getArtifactFilter() {
        return this.artifactFilter;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public void setTransitive(boolean bl) {
        this.transitive = bl;
    }

    public boolean isInline() {
        return this.inline;
    }

    public void setInline(boolean bl) {
        this.inline = bl;
    }

    public void setResolveId(String string) {
        this.resolveId = string;
    }

    public String getResolveId() {
        return this.resolveId;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setKeep(boolean bl) {
        this.keep = bl;
    }

    public boolean isKeep() {
        return this.keep == null ? !this.isInline() : this.keep;
    }

    public void setChanging(boolean bl) {
        this.changing = bl;
    }

    public boolean isChanging() {
        return this.changing;
    }

    public void setRefresh(boolean bl) {
        this.refresh = bl;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public String getResolveMode() {
        return this.resolveMode;
    }

    public void setResolveMode(String string) {
        this.resolveMode = string;
    }
}

