/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.xerial.util.Mapper;
import org.xerial.util.MinMax;
import org.xerial.util.Reducer;

public class Algorithm {
    private Algorithm() {
    }

    public static <E extends Comparable<E>> MinMax<E> minmax(E e, E e2) {
        int n = e.compareTo(e2);
        if (n <= 0) {
            return new MinMax<E>(e, e2);
        }
        return new MinMax<E>(e2, e);
    }

    public static <E extends Comparable<E>> E min(E e, E e2) {
        return Algorithm.minmax(e, e2).min();
    }

    public static <E extends Comparable<E>> E max(E e, E e2) {
        return Algorithm.minmax(e, e2).min();
    }

    public static <E extends Comparable<E>> int lexicographicalCompare(Iterable<E> iterable, Iterable<E> iterable2) {
        Iterator<E> iterator = iterable.iterator();
        Iterator<E> iterator2 = iterable2.iterator();
        int n = 0;
        while (iterator.hasNext() && iterator2.hasNext()) {
            Comparable comparable;
            Comparable comparable2 = (Comparable)iterator.next();
            n = comparable2.compareTo(comparable = (Comparable)iterator2.next());
            if (n == 0) continue;
            return n;
        }
        if (iterator.hasNext()) {
            return 1;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static int boolToInt(boolean bl) {
        return bl ? 1 : 0;
    }

    public static <E> void add(Collection<E> collection, E[] EArray) {
        for (E e : EArray) {
            collection.add(e);
        }
    }

    public static <E> void add(List<E> list, Collection<E> collection) {
        for (E e : collection) {
            list.add(e);
        }
    }

    public static <Input, Output> List<Output> map(Iterable<Input> iterable, Mapper<Input, Output> mapper) {
        ArrayList<Output> arrayList = new ArrayList<Output>();
        for (Input Input : iterable) {
            arrayList.add(mapper.map(Input));
        }
        return arrayList;
    }

    public static <Input, Output> Output reduce(Iterable<Input> iterable, Reducer<Input, Output> reducer) {
        return reducer.reduce(iterable);
    }

    public static <Input, T, Out> Out mapReduce(Iterable<Input> iterable, Mapper<Input, T> mapper, Reducer<T, Out> reducer) {
        return Algorithm.reduce(Algorithm.map(iterable, mapper), reducer);
    }
}

