/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Alnum
implements Comparable<Alnum> {
    public final String prefix;
    public final int number;
    private int hash = 0;
    private String orig;
    private static final Pattern alnum = Pattern.compile("([^0-9]+)([0-9]+)");

    public Alnum(String string) {
        Matcher matcher = alnum.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("invalid input: " + string);
        }
        this.prefix = matcher.group(1);
        this.number = Integer.parseInt(matcher.group(2));
        this.orig = string;
    }

    public Alnum(String string, int n) {
        this.prefix = string;
        this.number = n;
        this.orig = this.toString();
    }

    public String toString() {
        return this.orig;
    }

    @Override
    public int compareTo(Alnum alnum) {
        int n = this.prefix.compareTo(alnum.prefix);
        if (n != 0) {
            return n;
        }
        return this.number - alnum.number;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int n = this.prefix.hashCode();
            this.hash = n += this.number * 31;
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object instanceof Alnum) {
            Alnum alnum = (Alnum)Alnum.class.cast(object);
            return this.compareTo(alnum) == 0;
        }
        return false;
    }
}

