/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.bean.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.util.ArrayDeque;
import org.xerial.util.Deque;
import org.xerial.util.Pair;
import org.xerial.util.TypeConverter;
import org.xerial.util.TypeInfo;
import org.xerial.util.bean.BeanBinder;
import org.xerial.util.bean.BeanBinderSet;
import org.xerial.util.bean.BeanUpdator;
import org.xerial.util.bean.BeanUpdatorType;
import org.xerial.util.bean.BeanUtil;
import org.xerial.util.bean.impl.BindRuleGenerator;
import org.xerial.util.bean.impl.KeyValuePair;
import org.xerial.util.bean.impl.MapPutter;
import org.xerial.util.log.Logger;
import org.xerial.util.tree.TreeVisitor;
import org.xerial.util.tree.TreeWalker;

public class BeanBindingProcess
implements TreeVisitor {
    private static Logger _logger = Logger.getLogger(BeanBindingProcess.class);
    private final TreeMap<Integer, Object> contextBeanOfEachLevel = new TreeMap();
    private final TreeMap<Integer, Map<?, ?>> mapAssociatedWithBean = new TreeMap();
    private final Deque<StringBuilder> textStack = new ArrayDeque<StringBuilder>();
    private static final StringBuilder EMPTY_TEXT_BUILDER = new StringBuilder(0);
    private int currentLevel = 0;
    private BindRuleGenerator bindRuleGenerator = new BindRuleGeneratorImpl();

    public BeanBindingProcess(Class<?> clazz) throws XerialException {
        this(BeanUtil.createInstance(clazz));
    }

    public BeanBindingProcess(Object object) {
        this.setContextBean(0, object);
    }

    public static BeanBindingProcess newBinderWithRootContext(Object object) {
        BeanBindingProcess beanBindingProcess = new BeanBindingProcess(object);
        beanBindingProcess.currentLevel = 1;
        return beanBindingProcess;
    }

    public BeanBindingProcess(Object object, BindRuleGenerator bindRuleGenerator) {
        this.setContextBean(0, object);
        this.bindRuleGenerator = bindRuleGenerator;
    }

    public Object getResultBean() {
        return this.getContextBean(0);
    }

    public Object getContextBean(int n) {
        if (n < 0 || n >= this.contextBeanOfEachLevel.size()) {
            return null;
        }
        return this.contextBeanOfEachLevel.get(n);
    }

    private void setContextBean(int n, Object object) {
        this.contextBeanOfEachLevel.put(n, object);
    }

    private void removeContextBean(int n) {
        this.contextBeanOfEachLevel.remove(n);
    }

    @Override
    public void finish(TreeWalker treeWalker) throws XerialException {
    }

    @Override
    public void init(TreeWalker treeWalker) throws XerialException {
    }

    protected <T> BeanBinderSet getBindRuleSet(Class<T> clazz) throws XerialException {
        return this.bindRuleGenerator.getBeanBinderSet(clazz);
    }

    @Override
    public void visitNode(String string, String string2, TreeWalker treeWalker) throws XerialException {
        this.textStack.addLast(EMPTY_TEXT_BUILDER);
        int n = this.currentLevel++;
        Object object = this.getContextBean(n - 1);
        if (object == null) {
            return;
        }
        Object object2 = this.getContextBean(n);
        if (object2 == null) {
            assert (this.currentLevel > 0);
            BeanBinderSet beanBinderSet = this.getBindRuleSet(object.getClass());
            BeanUpdator beanUpdator = BeanBindingProcess.getUpdator(beanBinderSet, string);
            if (beanUpdator != null) {
                int n2 = 0;
                Method method = beanUpdator.getMethod();
                switch (beanUpdator.getType()) {
                    case SETTER: 
                    case COLLECTION_ADDER: 
                    case APPENDER: {
                        Object object3;
                        Class<?> clazz = beanUpdator.getInputType();
                        if (object instanceof KeyValuePair) {
                            object3 = (KeyValuePair)KeyValuePair.class.cast(object);
                            method = ((KeyValuePair)object3).putter();
                            if (string.equalsIgnoreCase("key")) {
                                clazz = ((KeyValuePair)object3).keyType();
                            } else if (string.equalsIgnoreCase("value")) {
                                clazz = ((KeyValuePair)object3).valueType();
                                n2 = 1;
                            }
                        }
                        if (TypeInfo.isBasicType(clazz)) {
                            this.bindValue(object, string, string2, n);
                            break;
                        }
                        if (TypeInfo.isMap(clazz)) {
                            object3 = BeanUtil.getGenericMapTypesOfMethodArgument(method, n2);
                            BeanBinderSet beanBinderSet2 = this.getBindRuleSet(clazz);
                            MapPutter mapPutter = beanBinderSet2.getStandardMapPutter();
                            if (object3 != null) {
                                this.setContextBean(n, new KeyValuePair(mapPutter, (Class)((Pair)object3).getFirst(), (Class)((Pair)object3).getSecond()));
                                break;
                            }
                            this.setContextBean(n, new KeyValuePair(mapPutter));
                            break;
                        }
                        if (clazz != Object.class) {
                            object3 = BeanUtil.createInstance(clazz);
                            this.setContextBean(n, object3);
                            break;
                        }
                        this.bindValue(object, string, string2, n);
                        break;
                    }
                    case MAP_PUTTER: {
                        MapPutter mapPutter = (MapPutter)MapPutter.class.cast(beanUpdator);
                        KeyValuePair keyValuePair = new KeyValuePair(mapPutter);
                        if (string2 != null) {
                            keyValuePair.setValue(string2);
                        }
                        this.setContextBean(n, keyValuePair);
                        break;
                    }
                    default: {
                        throw new XerialException(XerialErrorCode.UnknownBeanUpdator);
                    }
                }
            } else {
                treeWalker.skipDescendants();
            }
        }
    }

    private void bindValue(Object object, String string, String string2, int n) throws XerialException {
        if (object == null) {
            return;
        }
        BeanBinderSet beanBinderSet = this.getBindRuleSet(object.getClass());
        BeanUpdator beanUpdator = BeanBindingProcess.getUpdator(beanBinderSet, string);
        if (beanUpdator != null) {
            Object object2 = this.getContextBean(n);
            if (object2 == null && string2 != null && string2.length() > 0) {
                object2 = string2;
            }
            if (object2 == null) {
                return;
            }
            switch (beanUpdator.getType()) {
                case SETTER: 
                case COLLECTION_ADDER: 
                case APPENDER: {
                    try {
                        if (object instanceof KeyValuePair) {
                            KeyValuePair keyValuePair = (KeyValuePair)KeyValuePair.class.cast(object);
                            if (string.equalsIgnoreCase("key")) {
                                this.bindValue(object, beanUpdator, keyValuePair.keyType(), object2);
                                break;
                            }
                            if (!string.equalsIgnoreCase("value")) break;
                            this.bindValue(object, beanUpdator, keyValuePair.valueType(), object2);
                            break;
                        }
                        this.bindValue(object, beanUpdator, object2);
                    }
                    catch (XerialException xerialException) {
                        _logger.error(xerialException);
                    }
                    break;
                }
                case MAP_PUTTER: {
                    try {
                        KeyValuePair keyValuePair = (KeyValuePair)KeyValuePair.class.cast(object2);
                        if (keyValuePair.getValue() == null) {
                            keyValuePair.setValue(string2);
                        }
                        if (keyValuePair.hasKeyAndValue()) {
                            this.bindMapElement(object, (MapPutter)MapPutter.class.cast(beanUpdator), keyValuePair);
                        }
                        this.mapAssociatedWithBean.remove(object.hashCode());
                    }
                    catch (ClassCastException classCastException) {
                        _logger.error(classCastException);
                    }
                    break;
                }
                default: {
                    throw new XerialException(XerialErrorCode.UnknownBeanUpdator);
                }
            }
        }
    }

    @Override
    public void text(String string, String string2, TreeWalker treeWalker) throws XerialException {
        Object object = this.getContextBean(this.currentLevel - 2);
        if (object != null) {
            BeanBinderSet beanBinderSet = this.getBindRuleSet(object.getClass());
            BeanUpdator beanUpdator = BeanBindingProcess.getUpdator(beanBinderSet, string);
            if (beanUpdator != null && beanUpdator.getType() == BeanUpdatorType.APPENDER) {
                this.bindValue(object, beanUpdator, string2);
            } else {
                StringBuilder stringBuilder = this.textStack.peekLast();
                if (stringBuilder == EMPTY_TEXT_BUILDER) {
                    this.textStack.removeLast();
                    stringBuilder = new StringBuilder();
                    this.textStack.addLast(stringBuilder);
                }
                stringBuilder.append(string2);
            }
        }
    }

    @Override
    public void leaveNode(String string, TreeWalker treeWalker) throws XerialException {
        int n = --this.currentLevel;
        StringBuilder stringBuilder = this.textStack.removeLast();
        Object object = this.getContextBean(n - 1);
        if (object == null) {
            return;
        }
        this.bindValue(object, string, stringBuilder.toString(), n);
        this.removeContextBean(n);
    }

    public static BeanUpdator getUpdator(BeanBinderSet beanBinderSet, String string) throws XerialException {
        BeanBinder beanBinder = beanBinderSet.findRule(string);
        if (beanBinder == null) {
            return null;
        }
        if (!BeanUpdator.class.isAssignableFrom(beanBinder.getClass())) {
            _logger.warn(beanBinder.getClass().getName() + " cannot be used to bind data");
            return null;
        }
        return (BeanUpdator)((Object)beanBinder);
    }

    private void bindMapElement(Object object, MapPutter mapPutter, KeyValuePair keyValuePair) throws XerialException {
        try {
            mapPutter.getMethod().invoke(object, BeanBindingProcess.convertType(mapPutter.getKeyType(), keyValuePair.getKey()), BeanBindingProcess.convertType(mapPutter.getValueType(), keyValuePair.getValue()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XerialException((ErrorCode)XerialErrorCode.IllegalArgument, (Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XerialException((ErrorCode)XerialErrorCode.IllegalAccess, (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XerialException((ErrorCode)XerialErrorCode.InvocationTargetException, (Throwable)invocationTargetException);
        }
    }

    private void bindValue(Object object, BeanUpdator beanUpdator, Class clazz, Object object2) throws XerialException {
        try {
            if (object2.getClass() == KeyValuePair.class && TypeInfo.isMap(clazz)) {
                Map<?, ?> map = null;
                if (this.mapAssociatedWithBean.containsKey(object.hashCode())) {
                    map = this.mapAssociatedWithBean.get(object.hashCode());
                } else {
                    map = (Map<?, ?>)Map.class.cast(BeanUtil.createInstance(clazz));
                    this.mapAssociatedWithBean.put(object.hashCode(), map);
                }
                KeyValuePair keyValuePair = (KeyValuePair)KeyValuePair.class.cast(object2);
                map.put(keyValuePair.getKey(), keyValuePair.getValue());
                beanUpdator.getMethod().invoke(object, map);
            } else {
                beanUpdator.getMethod().invoke(object, BeanBindingProcess.convertType(clazz, object2));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XerialException((ErrorCode)XerialErrorCode.IllegalArgument, (Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XerialException((ErrorCode)XerialErrorCode.IllegalAccess, (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable == null) {
                throw new XerialException((ErrorCode)XerialErrorCode.InvocationTargetException, String.format("value=%s, updator=%s", object2, beanUpdator.getMethod().getName()));
            }
            throw new XerialException((ErrorCode)XerialErrorCode.InvocationTargetException, throwable);
        }
    }

    private void bindValue(Object object, BeanUpdator beanUpdator, Object object2) throws XerialException {
        this.bindValue(object, beanUpdator, beanUpdator.getInputType(), object2);
    }

    public static Object convertType(Class clazz, Object object) throws XerialException {
        return TypeConverter.convertType(clazz, object);
    }

    class BindRuleGeneratorImpl
    implements BindRuleGenerator {
        BindRuleGeneratorImpl() {
        }

        @Override
        public <T> BeanBinderSet getBeanBinderSet(Class<T> clazz) throws XerialException {
            return BeanUtil.getBeanLoadRule(clazz);
        }
    }
}

