/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.graph;

import org.xerial.util.graph.AdjacencyList;
import org.xerial.util.graph.Edge;
import org.xerial.util.graph.Graph;

public class GraphHelper {
    private GraphHelper() {
    }

    public static <NodeLabel, EdgeLabel> NodeLabel getSourceNodeLabel(Graph<NodeLabel, EdgeLabel> graph, Edge edge) {
        return graph.getNodeLabel(edge.getSourceNodeID());
    }

    public static <NodeLabel, EdgeLabel> NodeLabel getDestNodeLabel(Graph<NodeLabel, EdgeLabel> graph, Edge edge) {
        return graph.getNodeLabel(edge.getDestNodeID());
    }

    public static <NodeLabel, EdgeLabel> String toString(Graph<NodeLabel, EdgeLabel> graph, Edge edge) {
        return String.format("(%s,%s)", graph.getNodeLabel(edge.getSourceNodeID()).toString(), graph.getNodeLabel(edge.getDestNodeID()).toString());
    }

    public static <NodeLabel, EdgeLabel> Graph<NodeLabel, EdgeLabel> transitiveClosure(Graph<NodeLabel, EdgeLabel> graph) {
        AdjacencyList adjacencyList = AdjacencyList.copy(graph);
        int n = 0;
        do {
            n = 0;
            for (Object NodeLabel : adjacencyList.getNodeLabelSet()) {
                block2: for (Object NodeLabel2 : adjacencyList.getNodeLabelSet()) {
                    if (adjacencyList.hasEdge(NodeLabel, NodeLabel2)) continue;
                    int n2 = adjacencyList.getNodeID(NodeLabel2);
                    for (Edge edge : adjacencyList.getOutEdgeSet(NodeLabel)) {
                        int n3 = edge.getDestNodeID();
                        if (!adjacencyList.hasEdge(new Edge(n3, n2))) continue;
                        adjacencyList.addEdge(NodeLabel, NodeLabel2);
                        ++n;
                        continue block2;
                    }
                }
            }
        } while (n > 0);
        return adjacencyList;
    }
}

