/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.lens.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialError;
import org.xerial.core.XerialErrorCode;
import org.xerial.util.ReflectionUtil;
import org.xerial.util.StringUtil;
import org.xerial.util.TypeInfo;
import org.xerial.util.lens.ObjectLens;

public abstract class ParameterGetter {
    private final String paramName;
    private final String cName;
    private String naturalParamName = null;

    public ParameterGetter(String string) {
        this.paramName = string;
        this.cName = ObjectLens.getCanonicalParameterName(string);
    }

    public String getCanonicalParamName() {
        return this.cName;
    }

    public String getNaturalParamName() {
        if (this.naturalParamName == null) {
            this.naturalParamName = StringUtil.varNameToNaturalName(this.paramName);
        }
        return this.naturalParamName;
    }

    public abstract Object get(Object var1);

    public abstract Object get(Object var1, String var2);

    public boolean returnsMapType() {
        return TypeInfo.isMap(this.getReturnType());
    }

    public static ParameterGetter newFieldGetter(Field field, String string) {
        return new FieldGetter(field, string);
    }

    public static ParameterGetter newPropertyFieldGetter(Field field, String string) {
        return new PropertyFieldGetter(field, string);
    }

    public static ParameterGetter newGetter(Method method, String string) {
        return new GetterMethod(method, string);
    }

    public static ParameterGetter newMapEntryGetter(Method method) {
        return new MapEntryGetter(method);
    }

    public abstract Class<?> getReturnType();

    public String toString() {
        return this.paramName;
    }

    private static class MapEntryGetter
    extends ParameterGetter {
        final Method getter;

        public MapEntryGetter(Method method) {
            super("");
            this.getter = method;
            if (method.getParameterTypes().length != 1) {
                throw new XerialError((ErrorCode)XerialErrorCode.INVALID_INPUT, "not a map entry getter");
            }
        }

        @Override
        public Object get(Object object) {
            throw new UnsupportedOperationException("get(Object)");
        }

        @Override
        public Object get(Object object, String string) {
            return ReflectionUtil.invokeGetter(object, this.getter, string);
        }

        @Override
        public Class<?> getReturnType() {
            return this.getter.getReturnType();
        }
    }

    private static class GetterMethod
    extends ParameterGetter {
        final Method getter;

        public GetterMethod(Method method, String string) {
            super(string);
            this.getter = method;
            if (method.getParameterTypes().length != 0) {
                throw new XerialError((ErrorCode)XerialErrorCode.INVALID_INPUT, "not a getter");
            }
        }

        @Override
        public Object get(Object object) {
            return ReflectionUtil.invokeGetter(object, this.getter);
        }

        @Override
        public Object get(Object object, String string) {
            if (!this.returnsMapType()) {
                throw new UnsupportedOperationException("get(Object, String)");
            }
            return ReflectionUtil.invokeGetter(object, this.getter, string);
        }

        @Override
        public Class<?> getReturnType() {
            return this.getter.getReturnType();
        }
    }

    private static class PropertyFieldGetter
    extends ParameterGetter {
        final Field field;

        public PropertyFieldGetter(Field field, String string) {
            super(string);
            this.field = field;
        }

        @Override
        public Object get(Object object) {
            return ReflectionUtil.getFieldValue(object, this.field);
        }

        @Override
        public Object get(Object object, String string) {
            Object object2 = ReflectionUtil.getFieldValue(object, this.field);
            if (object2 != null && Map.class.isAssignableFrom(object2.getClass())) {
                Map map = (Map)Map.class.cast(object2);
                return map.get(string);
            }
            throw new UnsupportedOperationException("get(Object, String)");
        }

        @Override
        public Class<?> getReturnType() {
            return this.field.getType();
        }
    }

    private static class FieldGetter
    extends ParameterGetter {
        final Field field;

        public FieldGetter(Field field, String string) {
            super(string);
            this.field = field;
        }

        @Override
        public Object get(Object object) {
            return ReflectionUtil.getFieldValue(object, this.field);
        }

        @Override
        public Object get(Object object, String string) {
            throw new UnsupportedOperationException("get(Object, String)");
        }

        @Override
        public Class<?> getReturnType() {
            return this.field.getType();
        }
    }
}

