/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.opt;

import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialError;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.util.TypeInfo;
import org.xerial.util.opt.Argument;
import org.xerial.util.opt.Option;
import org.xerial.util.opt.OptionParserException;
import org.xerial.util.opt.impl.ArgumentItem;
import org.xerial.util.opt.impl.OptionItem;
import org.xerial.util.opt.impl.OptionSchema;

public class OptionParser {
    private OptionSchema schema;
    private Object optionHolder;
    private boolean ignoreUnknownOption = false;
    private HashSet<Option> activatedOption = new HashSet();
    private HashSet<Argument> activatedArgument = new HashSet();
    private List<String> unusedArgument = new ArrayList<String>();
    private boolean ignoreAfterTheFirstArgument = false;

    public <T> OptionParser(T t) {
        this.setOptionHolder(t);
    }

    public <T> OptionParser(Class<T> clazz) {
        try {
            this.optionHolder = TypeInfo.createInstance(clazz);
        }
        catch (XerialException xerialException) {
            throw new XerialError((ErrorCode)XerialErrorCode.INVALID_ARGUMENT, (Throwable)xerialException);
        }
        this.setOptionHolder(this.optionHolder);
    }

    public <T> void setOptionHolder(T t) {
        this.optionHolder = t == null ? new EmptyOptionHolder() : t;
        this.schema = OptionSchema.newOptionSchema(this.optionHolder);
    }

    public <T> T getOptionHolder() {
        return (T)this.optionHolder;
    }

    OptionItem findOptionItem(OptionSchema optionSchema, String string) throws OptionParserException {
        OptionItem optionItem = optionSchema.getOption(string);
        if (optionItem == null && !this.ignoreUnknownOption) {
            throw new OptionParserException((ErrorCode)XerialErrorCode.SYNTAX_ERROR, "unknown option: " + string);
        }
        return optionItem;
    }

    public void printUsage() {
        this.printUsage(System.out);
    }

    public void printUsage(Writer writer) {
        assert (this.schema != null);
        this.schema.printUsage(writer);
    }

    public void printUsage(OutputStream outputStream) {
        assert (this.schema != null);
        this.schema.printUsage(outputStream);
    }

    public String getUsage() {
        StringWriter stringWriter = new StringWriter();
        this.printUsage(stringWriter);
        return stringWriter.toString();
    }

    public String[] getUnusedArguments() {
        String[] stringArray = new String[this.unusedArgument.size()];
        for (int i = 0; i < this.unusedArgument.size(); ++i) {
            stringArray[i] = this.unusedArgument.get(i);
        }
        return stringArray;
    }

    public void parse(String[] stringArray, boolean bl) throws OptionParserException {
        this.setIgnoreUnknownOption(bl);
        this.parse(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseUntilTheFirstArgument(String[] stringArray) throws OptionParserException {
        this.ignoreAfterTheFirstArgument = true;
        try {
            this.parse(stringArray);
        }
        finally {
            this.ignoreAfterTheFirstArgument = false;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(String[] stringArray) throws OptionParserException {
        this.unusedArgument.clear();
        this.activatedOption.clear();
        this.activatedArgument.clear();
        for (OptionItem optionItem : this.schema.getOptionItemList()) {
            optionItem.initialize(this.optionHolder);
        }
        for (ArgumentItem argumentItem : this.schema.getArgumentItemList()) {
            argumentItem.initialize(this.optionHolder);
        }
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            void var3_8;
            OptionItem optionItem;
            Object object;
            String string = stringArray[i];
            if (string.startsWith("--")) {
                String string2;
                int n = string.indexOf(61);
                if (n == -1) {
                    string2 = string.substring(2);
                    object = this.findOptionItem(this.schema, string2);
                    if (object == null) {
                        this.unusedArgument.add(string);
                        continue;
                    }
                    if (((OptionItem)object).needsArgument()) {
                        throw new OptionParserException((ErrorCode)XerialErrorCode.SYNTAX_ERROR, "parameter value is required for --" + string2);
                    }
                    this.setOption((OptionItem)object, "true");
                    if (!((OptionItem)object).takesMultipleArguments() && this.activatedOption.contains(((OptionItem)object).getOption())) {
                        throw new OptionParserException((ErrorCode)XerialErrorCode.DUPLICATE_OPTION, ((OptionItem)object).getOption().toString());
                    }
                    this.activatedOption.add(((OptionItem)object).getOption());
                    continue;
                }
                string2 = string.substring(2, n);
                object = string.substring(n + 1);
                optionItem = this.findOptionItem(this.schema, string2);
                if (optionItem == null) {
                    this.unusedArgument.add(string);
                    continue;
                }
                if (!optionItem.needsArgument()) {
                    throw new OptionParserException((ErrorCode)XerialErrorCode.SYNTAX_ERROR, "syntax error --" + string2);
                }
                this.setOption(optionItem, (String)object);
                if (!optionItem.takesMultipleArguments() && this.activatedOption.contains(optionItem.getOption())) {
                    throw new OptionParserException((ErrorCode)XerialErrorCode.DUPLICATE_OPTION, optionItem.getOption().toString());
                }
                this.activatedOption.add(optionItem.getOption());
                continue;
            }
            if (string.startsWith("-")) {
                String string3 = string.substring(1);
                for (int j = 0; j < string3.length(); ++j) {
                    object = string3.substring(j, j + 1);
                    optionItem = this.findOptionItem(this.schema, (String)object);
                    if (optionItem == null) {
                        this.unusedArgument.add(string);
                        continue;
                    }
                    if (optionItem.needsArgument()) {
                        if (string3.length() != 1) {
                            throw new OptionParserException((ErrorCode)XerialErrorCode.SYNTAX_ERROR, String.format("short name option -%s with an arguments must be a single notation", object));
                        }
                        this.setOption(optionItem, stringArray[++i]);
                    } else {
                        this.setOption(optionItem, "true");
                    }
                    if (!optionItem.takesMultipleArguments() && this.activatedOption.contains(optionItem.getOption())) {
                        throw new OptionParserException((ErrorCode)XerialErrorCode.DUPLICATE_OPTION, optionItem.getOption().toString());
                    }
                    this.activatedOption.add(optionItem.getOption());
                }
                continue;
            }
            ArgumentItem argumentItem = this.schema.getArgument((int)var3_8);
            if (argumentItem == null) {
                if (!this.ignoreUnknownOption) throw new OptionParserException((ErrorCode)XerialErrorCode.SYNTAX_ERROR, "unused argument: " + (String)string);
                this.unusedArgument.add(string);
            } else {
                try {
                    argumentItem.set(this.optionHolder, string);
                }
                catch (XerialException xerialException) {
                    throw new OptionParserException((ErrorCode)XerialErrorCode.INVALID_ARGUMENT, xerialException.getMessage());
                }
                if (!argumentItem.takesMultipleArguments() && this.activatedArgument.contains(argumentItem.getArgumentDescriptor())) {
                    throw new OptionParserException((ErrorCode)XerialErrorCode.DUPLICATE_OPTION, argumentItem.getArgumentDescriptor().toString());
                }
                this.activatedArgument.add(argumentItem.getArgumentDescriptor());
                ++var3_8;
            }
            if (!this.ignoreAfterTheFirstArgument) continue;
            ++i;
            while (i < stringArray.length) {
                this.unusedArgument.add(stringArray[i]);
                ++i;
            }
        }
        for (ArgumentItem argumentItem : this.schema.getArgumentItemList()) {
            if (!argumentItem.getArgumentDescriptor().required() || this.activatedArgument.contains(argumentItem.getArgumentDescriptor())) continue;
            throw new OptionParserException((ErrorCode)XerialErrorCode.MISSING_ARGUMENT, argumentItem.toString());
        }
    }

    private void setOption(OptionItem optionItem, String string) throws OptionParserException {
        try {
            optionItem.setOption(this.optionHolder, string);
        }
        catch (XerialException xerialException) {
            XerialErrorCode xerialErrorCode = (XerialErrorCode)xerialException.getErrorCode();
            switch (xerialErrorCode) {
                case InvalidFormat: {
                    throw new OptionParserException((ErrorCode)XerialErrorCode.INVALID_ARGUMENT, String.format("cannot set %s to %s", string, optionItem.toString()));
                }
            }
            throw new OptionParserException((ErrorCode)xerialException.getErrorCode(), xerialException.getMessage());
        }
    }

    public void setIgnoreUnknownOption(boolean bl) {
        this.ignoreUnknownOption = bl;
    }

    private static class EmptyOptionHolder {
        private EmptyOptionHolder() {
        }
    }
}

