/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.opt.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialError;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.util.Algorithm;
import org.xerial.util.Mapper;
import org.xerial.util.Range;
import org.xerial.util.ResourcePath;
import org.xerial.util.StringUtil;
import org.xerial.util.opt.Argument;
import org.xerial.util.opt.Option;
import org.xerial.util.opt.Usage;
import org.xerial.util.opt.impl.ArgumentItem;
import org.xerial.util.opt.impl.OptionItem;
import org.xerial.util.text.Template;

public class OptionSchema {
    private final ArrayList<OptionItem> optionItemList = new ArrayList();
    private final ArrayList<ArgumentItem> argumentItemList = new ArrayList();
    private Usage usage = null;

    public List<OptionItem> getOptionItemList() {
        return this.optionItemList;
    }

    public List<ArgumentItem> getArgumentItemList() {
        return this.argumentItemList;
    }

    Usage getUsage() {
        return this.usage;
    }

    protected static String optionDescription(OptionItem optionItem) {
        StringBuilder stringBuilder = new StringBuilder();
        Option option = optionItem.getOption();
        if (optionItem.hasSymbol()) {
            stringBuilder.append(String.format("-%s", option.symbol()));
            if (optionItem.hasLongName()) {
                stringBuilder.append(String.format(", --%s", option.longName()));
                if (optionItem.needsArgument()) {
                    stringBuilder.append(String.format("=%s", option.varName()));
                }
            } else if (optionItem.needsArgument()) {
                stringBuilder.append(String.format(" ", option.varName()));
            }
        } else if (optionItem.hasLongName()) {
            stringBuilder.append(String.format("    --%s", option.longName()));
            if (optionItem.needsArgument()) {
                stringBuilder.append(String.format("=%s", option.varName()));
            }
        } else {
            throw new XerialError((ErrorCode)XerialErrorCode.NO_OPTION, optionItem.toString());
        }
        return stringBuilder.toString();
    }

    protected static String argumentExpression(ArgumentItem argumentItem) {
        StringBuilder stringBuilder = new StringBuilder();
        Argument argument = argumentItem.getArgumentDescriptor();
        String string = argument.required() ? (argumentItem.takesMultipleArguments() ? "%s ..." : "%s") : (argumentItem.takesMultipleArguments() ? "[%s ...]" : "[%s]");
        String string2 = StringUtil.varNameToNaturalName(argumentItem.getArgumentName());
        stringBuilder.append(String.format(string, string2));
        return stringBuilder.toString();
    }

    public void printUsage(OutputStream outputStream) {
        this.printUsage(new OutputStreamWriter(outputStream));
    }

    public void printUsage(Writer writer) {
        String string;
        Object iOException;
        Properties properties = new Properties();
        Collections.sort(this.argumentItemList, new Comparator<ArgumentItem>(){

            @Override
            public int compare(ArgumentItem argumentItem, ArgumentItem argumentItem2) {
                return argumentItem.getRange().compareTo(argumentItem2.getRange());
            }
        });
        List<String> list = Algorithm.map(this.argumentItemList, new Mapper<ArgumentItem, String>(){

            @Override
            public String map(ArgumentItem argumentItem) {
                return OptionSchema.argumentExpression(argumentItem);
            }
        });
        if (this.usage != null) {
            properties.put(TemplateVariable.COMMAND.name(), this.usage.command());
            if (this.usage.description() != null && this.usage.description().length() > 0) {
                properties.put(TemplateVariable.DESCRIPTION.name(), this.usage.description());
            }
        }
        properties.put(TemplateVariable.ARGUMENT_LIST.name(), StringUtil.join(list, " "));
        Collections.sort(this.optionItemList, new Comparator<OptionItem>(){

            @Override
            public int compare(OptionItem optionItem, OptionItem optionItem2) {
                int n;
                Option option = optionItem.getOption();
                Option option2 = optionItem2.getOption();
                if (optionItem.hasSymbol()) {
                    if (!optionItem2.hasSymbol()) {
                        return -1;
                    }
                } else if (optionItem2.hasSymbol()) {
                    return 1;
                }
                if ((n = option.symbol().compareTo(option2.symbol())) == 0) {
                    return option.longName().compareTo(option2.longName());
                }
                return n;
            }
        });
        List<String> list2 = Algorithm.map(this.optionItemList, new Mapper<OptionItem, String>(){

            @Override
            public String map(OptionItem optionItem) {
                return OptionSchema.optionDescription(optionItem);
            }
        });
        int n = 15;
        for (String object22 : list2) {
            if (object22.length() <= n) continue;
            n = object22.length();
        }
        String string2 = String.format(" %%-%ds  %%s", n);
        StringWriter stringWriter = new StringWriter();
        for (int resourcePath = 0; resourcePath < this.optionItemList.size(); ++resourcePath) {
            iOException = this.optionItemList.get(resourcePath);
            string = list2.get(resourcePath);
            String string3 = String.format(string2, string, ((OptionItem)iOException).getOption().description());
            stringWriter.append(string3);
            stringWriter.append(StringUtil.newline());
        }
        properties.put(TemplateVariable.OPTION_LIST.name(), stringWriter.toString());
        ResourcePath resourcePath = new ResourcePath(this.usage != null ? this.usage.templatePath() : "org/xerial/util/opt/help-message.template");
        try {
            iOException = new Template(resourcePath.openBinaryStream());
            string = ((Template)iOException).apply(properties);
            writer.append(string);
            writer.flush();
        }
        catch (IOException xerialException) {
            throw new XerialError((ErrorCode)XerialErrorCode.OUTPUT_ERROR, (Throwable)xerialException);
        }
        catch (XerialException xerialException) {
            throw new XerialError(xerialException);
        }
    }

    public OptionItem getOption(String string) {
        for (OptionItem optionItem : this.optionItemList) {
            Option option = optionItem.getOption();
            if (string.equals(option.symbol())) {
                return optionItem;
            }
            String string2 = option.longName();
            if (string2 == null || !string.equals(string2)) continue;
            return optionItem;
        }
        return null;
    }

    public ArgumentItem getArgument(int n) {
        for (ArgumentItem argumentItem : this.argumentItemList) {
            Argument argument = argumentItem.getArgumentDescriptor();
            if (argument.index() == n) {
                return argumentItem;
            }
            if (argument.index() >= n || !argumentItem.takesMultipleArguments()) continue;
            return argumentItem;
        }
        return null;
    }

    public void addOptionItem(Method method) {
        OptionItem optionItem = new OptionItem(method);
        this.optionItemList.add(optionItem);
    }

    public void addOptionItem(Field field) {
        OptionItem optionItem = new OptionItem(field);
        this.optionItemList.add(optionItem);
    }

    public void addArgumentItem(Method method) {
        ArgumentItem argumentItem = new ArgumentItem(method);
        this.validate(argumentItem);
        this.argumentItemList.add(argumentItem);
    }

    public void addArgumentItem(Field field) {
        ArgumentItem argumentItem = new ArgumentItem(field);
        this.validate(argumentItem);
        this.argumentItemList.add(argumentItem);
    }

    private void validate(ArgumentItem argumentItem) {
        Range range = argumentItem.getRange();
        for (ArgumentItem argumentItem2 : this.argumentItemList) {
            Range range2 = argumentItem2.getRange();
            if (!range2.overlaps(range)) continue;
            throw new XerialError((ErrorCode)XerialErrorCode.DUPLICATE_OPTION, String.format("argument %s and %s have an overlap", argumentItem2, argumentItem));
        }
    }

    public static OptionSchema newOptionSchema(Class<?> clazz) {
        OptionSchema optionSchema = new OptionSchema();
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            for (Method method : clazz2.getDeclaredMethods()) {
                if (method.getAnnotation(Option.class) != null) {
                    optionSchema.addOptionItem(method);
                }
                if (method.getAnnotation(Argument.class) == null) continue;
                optionSchema.addArgumentItem(method);
            }
            for (AccessibleObject accessibleObject : clazz2.getDeclaredFields()) {
                if (((Field)accessibleObject).getAnnotation(Option.class) != null) {
                    optionSchema.addOptionItem((Field)accessibleObject);
                }
                if (((Field)accessibleObject).getAnnotation(Argument.class) == null) continue;
                optionSchema.addArgumentItem((Field)accessibleObject);
            }
            if (clazz2.getAnnotation(Usage.class) == null) continue;
            optionSchema.setUsage(clazz2);
        }
        return optionSchema;
    }

    private void setUsage(Class<?> clazz) {
        Usage usage = clazz.getAnnotation(Usage.class);
        if (usage == null) {
            throw new XerialError((ErrorCode)XerialErrorCode.NO_USAGE_ANNOTATION, clazz.toString());
        }
        if (this.usage == null) {
            this.usage = usage;
        }
    }

    public static <OptionHolder> OptionSchema newOptionSchema(OptionHolder OptionHolder) {
        return OptionSchema.newOptionSchema(OptionHolder.getClass());
    }

    private static enum TemplateVariable {
        COMMAND,
        ARGUMENT_LIST,
        DESCRIPTION,
        OPTION_LIST;

    }
}

