/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.tree;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.xerial.core.XerialException;
import org.xerial.util.ArrayDeque;
import org.xerial.util.Deque;
import org.xerial.util.StringUtil;
import org.xerial.util.log.Logger;
import org.xerial.util.tree.TreeVisitor;
import org.xerial.util.tree.TreeWalker;

public class TreeWalkLog
implements TreeVisitor {
    private static Logger _logger = Logger.getLogger(TreeWalkLog.class);
    private final List<EventLog> log = new LinkedList<EventLog>();
    private final Deque<StringBuilder> textStack = new ArrayDeque<StringBuilder>();
    private final StringBuilder EMPTY_BUFFER = new StringBuilder(0);
    private String pendingVisitNode = null;

    @Override
    public void finish(TreeWalker treeWalker) throws XerialException {
        this.log.add(new EventLog(Event.FINISH));
    }

    @Override
    public void init(TreeWalker treeWalker) throws XerialException {
        this.log.add(new EventLog(Event.INIT));
        this.textStack.addLast(this.EMPTY_BUFFER);
    }

    @Override
    public void leaveNode(String string, TreeWalker treeWalker) throws XerialException {
        if (string == null) {
            return;
        }
        this.popPendingNode();
        this.log.add(new EventLog(Event.LEAVE, string, null));
        this.textStack.removeLast();
    }

    @Override
    public void text(String string, String string2, TreeWalker treeWalker) throws XerialException {
        if (this.textStack.peekLast() == this.EMPTY_BUFFER) {
            this.textStack.removeLast();
            this.textStack.addLast(new StringBuilder());
        }
        this.textStack.peekLast().append(string2);
    }

    private void popPendingNode() {
        if (this.pendingVisitNode != null) {
            if (this.textStack.peekLast() != this.EMPTY_BUFFER) {
                this.log.add(new EventLog(Event.VISIT, this.pendingVisitNode, this.textStack.peekLast().toString()));
            } else {
                this.log.add(new EventLog(Event.VISIT, this.pendingVisitNode, null));
            }
            this.pendingVisitNode = null;
        }
    }

    @Override
    public void visitNode(String string, String string2, TreeWalker treeWalker) throws XerialException {
        this.popPendingNode();
        if (string == null) {
            return;
        }
        this.pendingVisitNode = StringUtil.varNameToCanonicalName(string);
        if (string2 != null) {
            this.textStack.addLast(new StringBuilder(string2));
        } else {
            this.textStack.addLast(this.EMPTY_BUFFER);
        }
    }

    public List<EventLog> getLog() {
        return this.log;
    }

    public String toString() {
        return StringUtil.join(this.log, "\n");
    }

    public static boolean compare(TreeWalkLog treeWalkLog, TreeWalkLog treeWalkLog2) {
        List<EventLog> list = treeWalkLog.getLog();
        List<EventLog> list2 = treeWalkLog2.getLog();
        Iterator<EventLog> iterator = list.iterator();
        Iterator<EventLog> iterator2 = list2.iterator();
        boolean bl = true;
        while (iterator.hasNext() && iterator2.hasNext()) {
            EventLog eventLog;
            EventLog eventLog2 = iterator.next();
            if (!eventLog2.equals(eventLog = iterator2.next()) && bl) {
                _logger.warn(String.format("<mismatch>: %-20s %-20s", eventLog2, eventLog));
                bl = false;
                continue;
            }
            _logger.debug(String.format("compare ok: %-20s %-20s", eventLog2, eventLog));
        }
        if (list.size() != list2.size()) {
            bl = false;
        }
        return bl;
    }

    public static class EventLog {
        Event event;
        String nodeName = null;
        String value = null;

        public EventLog(Event event) {
            this.event = event;
        }

        public EventLog(Event event, String string, String string2) {
            this.event = event;
            this.nodeName = string;
            this.value = string2;
        }

        public static boolean strCmp(String string, String string2) {
            if (string == null) {
                return string2 == null;
            }
            if (string2 == null) {
                return false;
            }
            return string.equals(string2);
        }

        public boolean equals(Object object) {
            EventLog eventLog = (EventLog)object;
            if (this.event != eventLog.event) {
                return false;
            }
            if (!EventLog.strCmp(StringUtil.varNameToCanonicalName(this.nodeName), StringUtil.varNameToCanonicalName(eventLog.nodeName))) {
                return false;
            }
            return EventLog.strCmp(this.value, eventLog.value);
        }

        public String toString() {
            if (this.nodeName != null) {
                if (this.value != null) {
                    return String.format("%s:%s=%s", new Object[]{this.event, this.nodeName, this.value});
                }
                return String.format("%s:%s", new Object[]{this.event, this.nodeName});
            }
            if (this.value != null) {
                return String.format("%s:%s", new Object[]{this.event, this.value});
            }
            return String.format("%s", new Object[]{this.event});
        }
    }

    public static enum Event {
        INIT,
        FINISH,
        VISIT,
        LEAVE;

    }
}

