/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.duration.Duration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import wvlet.log.Guard;
import wvlet.log.LogLevelScanner$;
import wvlet.log.LogLevelScanner$RUNNING$;
import wvlet.log.LogLevelScanner$STOPPED$;
import wvlet.log.LogLevelScanner$STOPPING$;
import wvlet.log.LogLevelScannerConfig;
import wvlet.log.LogLevelScannerConfig$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mx!B\u0001\u0003\u0011\u00039\u0011a\u0004'pO2+g/\u001a7TG\u0006tg.\u001a:\u000b\u0005\r!\u0011a\u00017pO*\tQ!A\u0003xm2,Go\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003\u001f1{w\rT3wK2\u001c6-\u00198oKJ\u001c\"!\u0003\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0012\u0002\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0004\u0017\u0013\t\u0007I\u0011B\f\u0002\r1|wmZ3s+\u0005A\u0002C\u0001\u0005\u001a\u0013\tQ\"A\u0001\u0004M_\u001e<WM\u001d\u0005\u00079%\u0001\u000b\u0011\u0002\r\u0002\u000f1|wmZ3sA!)a$\u0003C\u0001?\u0005a1/\u001a;M_\u001edUM^3mgR\u0011\u0001e\t\t\u0003\u001b\u0005J!A\t\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006Iu\u0001\r!J\u0001\u0005M&dW\r\u0005\u0002'W5\tqE\u0003\u0002)S\u0005\u0011\u0011n\u001c\u0006\u0002U\u0005!!.\u0019<b\u0013\tasE\u0001\u0003GS2,\u0007b\u0002\u0018\n\u0005\u0004%\taL\u0001!\t\u00163\u0015)\u0016'U?2{u\tT#W\u000b2{f)\u0013'F?\u000e\u000be\nR%E\u0003R+5+F\u00011!\r\tDGN\u0007\u0002e)\u00111GD\u0001\u000bG>dG.Z2uS>t\u0017BA\u001b3\u0005\r\u0019V-\u001d\t\u0003oij\u0011\u0001\u000f\u0006\u0003s%\nA\u0001\\1oO&\u00111\b\u000f\u0002\u0007'R\u0014\u0018N\\4\t\ruJ\u0001\u0015!\u00031\u0003\u0005\"UIR!V\u0019R{FjT$M\u000bZ+Ej\u0018$J\u0019\u0016{6)\u0011(E\u0013\u0012\u000bE+R*!\u0011\u0015y\u0014\u0002\"\u0001A\u00035\u00198-\u00198M_\u001edUM^3mgV\t\u0001\u0005C\u0003@\u0013\u0011\u0005!\t\u0006\u0002!\u0007\")A)\u0011a\u0001\u000b\u00061Bn\\4mKZ,GNR5mK\u000e\u000bg\u000eZ5eCR,7\u000fE\u0002G\u001dBs!a\u0012'\u000f\u0005![U\"A%\u000b\u0005)3\u0011A\u0002\u001fs_>$h(C\u0001\u0010\u0013\tie\"A\u0004qC\u000e\\\u0017mZ3\n\u0005Uz%BA'\u000f!\t\tVK\u0004\u0002S'B\u0011\u0001JD\u0005\u0003):\ta\u0001\u0015:fI\u00164\u0017BA\u001eW\u0015\t!f\u0002C\u0003Y\u0013\u0011\u0005\u0001)\u0001\u000btG\",G-\u001e7f\u0019><G*\u001a<fYN\u001b\u0017M\u001c\u0005\n5&A)\u0019!C\u0001\u0005m\u000bq\u0002\\8h\u0019\u00164X\r\\*dC:tWM]\u000b\u00029B\u0011\u0001\"\u0018\u0004\u0006\u0015\t\u0001!AX\n\u0004;2y\u0006C\u0001\u0005a\u0013\t\t'AA\u0003Hk\u0006\u0014H\rC\u0003\u0014;\u0012\u00051\rF\u0001]\u0011\u001d)WL1A\u0005\n\u0019\faaY8oM&<W#A4\u0011\u0007!|\u0017/D\u0001j\u0015\tQ7.\u0001\u0004bi>l\u0017n\u0019\u0006\u0003Y6\f!bY8oGV\u0014(/\u001a8u\u0015\tq\u0017&\u0001\u0003vi&d\u0017B\u00019j\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007C\u0001\u0005s\u0013\t\u0019(AA\u000bM_\u001edUM^3m'\u000e\fgN\\3s\u0007>tg-[4\t\rUl\u0006\u0015!\u0003h\u0003\u001d\u0019wN\u001c4jO\u0002Bqa^/C\u0002\u0013%\u00010A\u0007d_:4\u0017nZ\"iC:<W\rZ\u000b\u0002sB\u0011!0`\u0007\u0002w*\u0011Ap[\u0001\u0006Y>\u001c7n]\u0005\u0003}n\u0014\u0011bQ8oI&$\u0018n\u001c8\t\u000f\u0005\u0005Q\f)A\u0005s\u0006q1m\u001c8gS\u001e\u001c\u0005.\u00198hK\u0012\u0004\u0003BCA\u0003;\n\u0007I\u0011\u0001\u0002\u0002\b\u0005I1oY1o\u0007>,h\u000e^\u000b\u0003\u0003\u0013\u00012\u0001[A\u0006\u0013\r\ti!\u001b\u0002\u000b\u0003R|W.[2M_:<\u0007\u0002CA\t;\u0002\u0006I!!\u0003\u0002\u0015M\u001c\u0017M\\\"pk:$\b\u0005C\u0004\u0002\u0016u#\t!a\u0006\u0002\u0013\u001d,GoQ8oM&<W#A9\t\u000f\u0005mQ\f\"\u0001\u0002\u001e\u0005I1/\u001a;D_:4\u0017n\u001a\u000b\u0004A\u0005}\u0001BB3\u0002\u001a\u0001\u0007\u0011\u000fC\u0005\u0002$u\u0013\r\u0011\"\u0003\u0002&\u0005)1\u000f^1uKV\u0011\u0011q\u0005\t\u0005Q>\fI\u0003\u0005\u0003\u0002,\u0005UbbAA\u0017\u00019!\u0011qFA\u001a\u001d\rA\u0015\u0011G\u0005\u0002\u000b%\u00111\u0001\u0002\u0004\u000b\u0003oI\u0001\u0013aI\u0011\u0005\u0005e\"\u0001D*dC:tWM]*uCR,7cAA\u001b\u0019%B\u0011QGA\u001f\u0003\u001b\nIF\u0002\u0005\u0002@%A\tAAA!\u0005\u001d\u0011VK\u0014(J\u001d\u001e\u001bR!!\u0010\r\u0003\u0007\u0002B!!\u0012\u000265\t\u0011\u0002C\u0004\u0014\u0003{!\t!!\u0013\u0015\u0005\u0005-\u0003\u0003BA#\u0003{1\u0001\"a\u0014\n\u0011\u0003\u0011\u0011\u0011\u000b\u0002\b'R{\u0005\u000bU#E'\u0015\ti\u0005DA\"\u0011\u001d\u0019\u0012Q\nC\u0001\u0003+\"\"!a\u0016\u0011\t\u0005\u0015\u0013Q\n\u0004\t\u00037J\u0001\u0012\u0001\u0002\u0002^\tA1\u000bV(Q!&suiE\u0003\u0002Z1\t\u0019\u0005C\u0004\u0014\u00033\"\t!!\u0019\u0015\u0005\u0005\r\u0004\u0003BA#\u00033B\u0001\"a\u001a^A\u0003%\u0011qE\u0001\u0007gR\fG/\u001a\u0011\t\r\u0005-T\f\"\u0001A\u0003\u0015\u0019H/\u0019:u\u0011\u0019\ty'\u0018C\u0001\u0001\u0006!1\u000f^8q\u0011%\t\u0019(\u0018a\u0001\n\u0013\t)(A\nmCN$8k\u00195fIVdW\rZ'jY2L7/\u0006\u0002\u0002xA)Q\"!\u001f\u0002~%\u0019\u00111\u0010\b\u0003\r=\u0003H/[8o!\ri\u0011qP\u0005\u0004\u0003\u0003s!\u0001\u0002'p]\u001eD\u0011\"!\"^\u0001\u0004%I!a\"\u0002/1\f7\u000f^*dQ\u0016$W\u000f\\3e\u001b&dG.[:`I\u0015\fHc\u0001\u0011\u0002\n\"Q\u00111RAB\u0003\u0003\u0005\r!a\u001e\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002\u0010v\u0003\u000b\u0015BA<\u0003Qa\u0017m\u001d;TG\",G-\u001e7fI6KG\u000e\\5tA!I\u00111S/A\u0002\u0013%\u0011QO\u0001\u0012Y\u0006\u001cHoU2b]:,G-T5mY&\u001c\b\"CAL;\u0002\u0007I\u0011BAM\u0003Ua\u0017m\u001d;TG\u0006tg.\u001a3NS2d\u0017n]0%KF$2\u0001IAN\u0011)\tY)!&\u0002\u0002\u0003\u0007\u0011q\u000f\u0005\t\u0003?k\u0006\u0015)\u0003\u0002x\u0005\u0011B.Y:u'\u000e\fgN\\3e\u001b&dG.[:!\u0011\u0019\t\u0019+\u0018C\u0005\u0001\u0006\u0019!/\u001e8\u0007\r\u0005\u001dV\fBAU\u0005Uaun\u001a'fm\u0016d7kY1o]\u0016\u0014H\u000b\u001b:fC\u0012\u001cB!!*\u0002,B\u0019q'!,\n\u0007\u0005=\u0006H\u0001\u0004UQJ,\u0017\r\u001a\u0005\b'\u0005\u0015F\u0011AAZ)\t\t)\f\u0005\u0003\u00028\u0006\u0015V\"A/\t\u0011\u0005\r\u0016Q\u0015C!\u0003w#\u0012\u0001\t\u0005\u00071&!\t!a0\u0015\u0007\u0001\n\t\r\u0003\u0004f\u0003{\u0003\r!\u001d\u0005\u00071&!\t!!2\u0015\u0007\u0001\n9\r\u0003\u0005\u0002J\u0006\r\u0007\u0019AAf\u0003!!WO]1uS>t\u0007\u0003BAg\u0003'l!!a4\u000b\t\u0005%\u0017\u0011\u001b\u0006\u0003Y:IA!!6\u0002P\nAA)\u001e:bi&|g\u000e\u0003\u0004\u0002Z&!\t\u0001Q\u0001\u001agR|\u0007oU2iK\u0012,H.\u001a3M_\u001edUM^3m'\u000e\fg\u000e\u0003\u0005\u0002^&!\tAAAp\u0003\u0011\u00198-\u00198\u0015\r\u0005]\u0014\u0011]As\u0011\u001d\t\u0019/a7A\u0002\u0015\u000ba\u0003\\8h\u0019\u00164X\r\u001c$jY\u0016\u001c\u0015M\u001c3jI\u0006$Xm\u001d\u0005\t\u0003'\u000bY\u000e1\u0001\u0002x\u001dA\u0011\u0011^\u0005\t\u0002\t\tY%A\u0004S+:s\u0015JT$\b\u0011\u00055\u0018\u0002#\u0001\u0003\u0003G\n\u0001b\u0015+P!BKejR\u0004\t\u0003cL\u0001\u0012\u0001\u0002\u0002X\u000591\u000bV(Q!\u0016#\u0005")
public class LogLevelScanner
implements Guard {
    private final AtomicReference<LogLevelScannerConfig> config;
    private final Condition configChanged;
    private final AtomicLong scanCount;
    private final AtomicReference<ScannerState> state;
    private Option<Object> lastScheduledMillis;
    private Option<Object> lastScannedMillis;
    private final ReentrantLock wvlet$log$Guard$$lock;

    public static void stopScheduledLogLevelScan() {
        LogLevelScanner$.MODULE$.stopScheduledLogLevelScan();
    }

    public static void scheduleLogLevelScan(Duration duration) {
        LogLevelScanner$.MODULE$.scheduleLogLevelScan(duration);
    }

    public static void scheduleLogLevelScan(LogLevelScannerConfig logLevelScannerConfig) {
        LogLevelScanner$.MODULE$.scheduleLogLevelScan(logLevelScannerConfig);
    }

    public static void scheduleLogLevelScan() {
        LogLevelScanner$.MODULE$.scheduleLogLevelScan();
    }

    public static void scanLogLevels(Seq<String> seq) {
        LogLevelScanner$.MODULE$.scanLogLevels(seq);
    }

    public static void scanLogLevels() {
        LogLevelScanner$.MODULE$.scanLogLevels();
    }

    public static Seq<String> DEFAULT_LOGLEVEL_FILE_CANDIDATES() {
        return LogLevelScanner$.MODULE$.DEFAULT_LOGLEVEL_FILE_CANDIDATES();
    }

    public static void setLogLevels(File file) {
        LogLevelScanner$.MODULE$.setLogLevels(file);
    }

    @Override
    public Condition newCondition() {
        return Guard.newCondition$(this);
    }

    @Override
    public <U> U guard(Function0<U> body) {
        return (U)Guard.guard$(this, body);
    }

    @Override
    public ReentrantLock wvlet$log$Guard$$lock() {
        return this.wvlet$log$Guard$$lock;
    }

    @Override
    public final void wvlet$log$Guard$_setter_$wvlet$log$Guard$$lock_$eq(ReentrantLock x$1) {
        this.wvlet$log$Guard$$lock = x$1;
    }

    private AtomicReference<LogLevelScannerConfig> config() {
        return this.config;
    }

    private Condition configChanged() {
        return this.configChanged;
    }

    public AtomicLong scanCount() {
        return this.scanCount;
    }

    public LogLevelScannerConfig getConfig() {
        return this.config().get();
    }

    public void setConfig(LogLevelScannerConfig config) {
        this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogLevelScannerConfig prev = this.config().get();
            Seq<String> seq = prev.logLevelFileCandidates();
            Seq<String> seq2 = config.logLevelFileCandidates();
            if (seq == null ? seq2 != null : !seq.equals(seq2)) {
                this.lastScannedMillis_$eq((Option<Object>)None$.MODULE$);
            }
            this.config().set(config);
            this.configChanged().signalAll();
        });
    }

    private AtomicReference<ScannerState> state() {
        return this.state;
    }

    public void start() {
        this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                this.state().compareAndSet(LogLevelScanner$STOPPING$.MODULE$, LogLevelScanner$RUNNING$.MODULE$);
                if (!this.state().compareAndSet(LogLevelScanner$STOPPED$.MODULE$, LogLevelScanner$RUNNING$.MODULE$)) break block0;
                new LogLevelScannerThread().start();
            }
        });
    }

    public void stop() {
        this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.state().set(LogLevelScanner$STOPPING$.MODULE$));
    }

    private Option<Object> lastScheduledMillis() {
        return this.lastScheduledMillis;
    }

    private void lastScheduledMillis_$eq(Option<Object> x$1) {
        this.lastScheduledMillis = x$1;
    }

    private Option<Object> lastScannedMillis() {
        return this.lastScannedMillis;
    }

    private void lastScannedMillis_$eq(Option<Object> x$1) {
        this.lastScannedMillis = x$1;
    }

    public void wvlet$log$LogLevelScanner$$run() {
        while (!this.state().compareAndSet(LogLevelScanner$STOPPING$.MODULE$, LogLevelScanner$STOPPED$.MODULE$)) {
            long currentTimeMillis = System.currentTimeMillis();
            long scanIntervalMillis = this.getConfig().scanInterval().toMillis();
            if (this.lastScheduledMillis().isEmpty() || currentTimeMillis - BoxesRunTime.unboxToLong((Object)this.lastScheduledMillis().get()) > scanIntervalMillis) {
                Option<Object> updatedLastScannedMillis = LogLevelScanner$.MODULE$.scan(this.getConfig().logLevelFileCandidates(), this.lastScannedMillis());
                this.scanCount().incrementAndGet();
                this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lastScannedMillis_$eq(updatedLastScannedMillis));
                this.lastScheduledMillis_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)currentTimeMillis)));
            }
            long sleepTime = scanIntervalMillis - package$.MODULE$.max(0L, package$.MODULE$.min(scanIntervalMillis, currentTimeMillis - BoxesRunTime.unboxToLong((Object)this.lastScheduledMillis().get())));
            this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (!this.configChanged().await(sleepTime, TimeUnit.MILLISECONDS)) {
                    // empty if block
                }
            });
        }
    }

    public LogLevelScanner() {
        Guard.$init$(this);
        this.config = new AtomicReference<LogLevelScannerConfig>(new LogLevelScannerConfig((Seq<String>)((Seq)Seq$.MODULE$.empty()), LogLevelScannerConfig$.MODULE$.apply$default$2()));
        this.configChanged = this.newCondition();
        this.scanCount = new AtomicLong(0L);
        this.state = new AtomicReference<LogLevelScanner$STOPPED$>(LogLevelScanner$STOPPED$.MODULE$);
        this.lastScheduledMillis = None$.MODULE$;
        this.lastScannedMillis = None$.MODULE$;
    }

    public class LogLevelScannerThread
    extends Thread {
        @Override
        public void run() {
            this.wvlet$log$LogLevelScanner$LogLevelScannerThread$$$outer().wvlet$log$LogLevelScanner$$run();
        }

        public /* synthetic */ LogLevelScanner wvlet$log$LogLevelScanner$LogLevelScannerThread$$$outer() {
            return LogLevelScanner.this;
        }

        public LogLevelScannerThread() {
            if (LogLevelScanner.this == null) {
                throw null;
            }
            this.setName("WvletLogLevelScanner");
            this.setDaemon(true);
        }
    }

    public static interface ScannerState {
    }
}

