/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.junit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.junit.experimental.categories.Category;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryFilter
extends Filter {
    private final Set<Class<?>> included;
    private final Set<Class<?>> excluded;
    private final boolean includedAny;
    private final boolean excludedAny;

    public static CategoryFilter include(boolean bl, Class<?> ... classArray) {
        if (CategoryFilter.hasNull(classArray)) {
            throw new NullPointerException("has null category");
        }
        return CategoryFilter.categoryFilter(bl, CategoryFilter.createSet(classArray), true, null);
    }

    public static CategoryFilter include(Class<?> clazz) {
        return CategoryFilter.include(true, clazz);
    }

    public static CategoryFilter include(Class<?> ... classArray) {
        return CategoryFilter.include(true, classArray);
    }

    public static CategoryFilter exclude(boolean bl, Class<?> ... classArray) {
        if (CategoryFilter.hasNull(classArray)) {
            throw new NullPointerException("has null category");
        }
        return CategoryFilter.categoryFilter(true, null, bl, CategoryFilter.createSet(classArray));
    }

    public static CategoryFilter exclude(Class<?> clazz) {
        return CategoryFilter.exclude(true, clazz);
    }

    public static CategoryFilter exclude(Class<?> ... classArray) {
        return CategoryFilter.exclude(true, classArray);
    }

    public static CategoryFilter categoryFilter(boolean bl, Set<Class<?>> set, boolean bl2, Set<Class<?>> set2) {
        return new CategoryFilter(bl, set, bl2, set2);
    }

    protected CategoryFilter(boolean bl, Set<Class<?>> set, boolean bl2, Set<Class<?>> set2) {
        this.includedAny = bl;
        this.excludedAny = bl2;
        this.included = CategoryFilter.copyAndRefine(set);
        this.excluded = CategoryFilter.copyAndRefine(set2);
    }

    public String describe() {
        return this.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("categories ").append(this.included.isEmpty() ? "[all]" : this.included);
        if (!this.excluded.isEmpty()) {
            stringBuilder.append(" - ").append(this.excluded);
        }
        return stringBuilder.toString();
    }

    public boolean shouldRun(Description description) {
        if (this.hasCorrectCategoryAnnotation(description)) {
            return true;
        }
        for (Description description2 : description.getChildren()) {
            if (!this.shouldRun(description2)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCorrectCategoryAnnotation(Description description) {
        Set<Class<?>> set = CategoryFilter.categories(description);
        if (set.isEmpty()) {
            return this.included.isEmpty();
        }
        if (!this.excluded.isEmpty() && (this.excludedAny ? this.matchesAnyParentCategories(set, this.excluded) : this.matchesAllParentCategories(set, this.excluded))) {
            return false;
        }
        if (this.included.isEmpty()) {
            return true;
        }
        if (this.includedAny) {
            return this.matchesAnyParentCategories(set, this.included);
        }
        return this.matchesAllParentCategories(set, this.included);
    }

    private boolean matchesAnyParentCategories(Set<Class<?>> set, Set<Class<?>> set2) {
        for (Class<?> clazz : set2) {
            if (!CategoryFilter.hasAssignableTo(set, clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesAllParentCategories(Set<Class<?>> set, Set<Class<?>> set2) {
        for (Class<?> clazz : set2) {
            if (CategoryFilter.hasAssignableTo(set, clazz)) continue;
            return false;
        }
        return true;
    }

    private static Set<Class<?>> categories(Description description) {
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, CategoryFilter.directCategories(description));
        Collections.addAll(hashSet, CategoryFilter.directCategories(CategoryFilter.parentDescription(description)));
        return hashSet;
    }

    private static Description parentDescription(Description description) {
        Class clazz = description.getTestClass();
        return clazz == null ? null : Description.createSuiteDescription((Class)clazz);
    }

    private static Class<?>[] directCategories(Description description) {
        if (description == null) {
            return new Class[0];
        }
        Category category = (Category)description.getAnnotation(Category.class);
        return category == null ? new Class[]{} : category.value();
    }

    private static Set<Class<?>> copyAndRefine(Set<Class<?>> set) {
        HashSet hashSet = new HashSet();
        if (set != null) {
            hashSet.addAll(set);
        }
        hashSet.remove(null);
        return hashSet;
    }

    private static boolean hasNull(Class<?> ... classArray) {
        if (classArray == null) {
            return false;
        }
        for (Class<?> clazz : classArray) {
            if (clazz != null) continue;
            return true;
        }
        return false;
    }

    private static Set<Class<?>> createSet(Class<?> ... classArray) {
        HashSet hashSet = new HashSet();
        if (classArray != null) {
            Collections.addAll(hashSet, classArray);
        }
        return hashSet;
    }

    private static boolean hasAssignableTo(Set<Class<?>> set, Class<?> clazz) {
        for (Class<?> clazz2 : set) {
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return true;
        }
        return false;
    }
}

