/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.html.page;

import java.io.IOException;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.internal.ReportOutputFolder;
import org.jacoco.report.internal.html.IHTMLReportContext;
import org.jacoco.report.internal.html.page.PackagePage;
import org.jacoco.report.internal.html.page.ReportPage;
import org.jacoco.report.internal.html.page.TablePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundlePage
extends TablePage<ICoverageNode> {
    private final ISourceFileLocator locator;
    private IBundleCoverage bundle;

    public BundlePage(IBundleCoverage bundle, ReportPage parent, ISourceFileLocator locator, ReportOutputFolder folder, IHTMLReportContext context) {
        super(bundle.getPlainCopy(), parent, folder, context);
        this.bundle = bundle;
        this.locator = locator;
    }

    @Override
    public void render() throws IOException {
        this.renderPackages();
        super.render();
        this.bundle = null;
    }

    private void renderPackages() throws IOException {
        for (IPackageCoverage p : this.bundle.getPackages()) {
            String packagename = p.getName();
            String foldername = packagename.length() == 0 ? "default" : packagename.replace('/', '.');
            PackagePage page = new PackagePage(p, this, this.locator, this.folder.subFolder(foldername), this.context);
            page.render();
            this.addItem(page);
        }
    }

    @Override
    protected String getOnload() {
        return "initialSort(['breadcrumb', 'coveragetable'])";
    }

    @Override
    protected String getFileName() {
        return "index.html";
    }
}

