/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tomcat.internal;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.logger.FileLogger;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.startup.Embedded;
import org.apache.coyote.tomcat4.CoyoteConnector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.appserver.IWebappServer;
import org.eclipse.tomcat.internal.SocketUtil;
import org.eclipse.tomcat.internal.TomcatPlugin;
import org.eclipse.tomcat.internal.TomcatResources;
import org.eclipse.tomcat.internal.WebAppClassLoader;

public class TomcatAppServer
implements IWebappServer {
    private String hostAddress;
    private int port;
    private boolean isStarted = false;
    private boolean running = false;
    private Embedded embedded = null;
    private Engine engine = null;
    private Host host = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int port, String hostAddress) throws CoreException {
        this.hostAddress = hostAddress;
        this.port = port;
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        try {
            Connector connector;
            FileLogger logger = new FileLogger();
            logger.setDirectory(TomcatPlugin.getDefault().getStateLocation().toOSString());
            this.embedded = new Embedded((Logger)logger, (Realm)new MemoryRealm());
            this.embedded.setDebug(0);
            this.embedded.setLogger((Logger)logger);
            URL installURL = TomcatPlugin.getDefault().getBundle().getEntry("/");
            URL resolvedURL = Platform.resolve((URL)installURL);
            String home = Platform.asLocalURL((URL)resolvedURL).getFile();
            System.setProperty("catalina.home", home);
            String base = home;
            System.setProperty("catalina.base", base);
            this.embedded.start();
            this.engine = this.embedded.createEngine();
            this.host = this.embedded.createHost("localhost", home + "/webapps");
            this.engine.setDefaultHost(this.host.getName());
            if (this.host instanceof StandardHost) {
                ((StandardHost)this.host).setErrorReportValveClass("org.eclipse.tomcat.internal.EclipseErrorReportValve");
            }
            this.engine.addChild((Container)this.host);
            PrintStream sysOut = System.out;
            System.setOut(new PrintStream(new ByteArrayOutputStream()));
            try {
                this.embedded.addEngine(this.engine);
            }
            finally {
                System.setOut(sysOut);
            }
            Context root = this.embedded.createContext("", home + "/webapps/ROOT");
            if (root instanceof StandardContext) {
                ((StandardContext)root).setWorkDir(this.getWorkingDirectory("ROOT"));
            }
            root.setLoader(this.embedded.createLoader(this.getClass().getClassLoader()));
            this.host.addChild((Container)root);
            InetAddress iAddress = null;
            if (this.hostAddress != null) {
                try {
                    iAddress = InetAddress.getByName(this.hostAddress);
                }
                catch (UnknownHostException uhe) {
                    // empty catch block
                }
            }
            if (this.port == 0) {
                this.port = SocketUtil.findUnusedLocalPort(iAddress);
                if (this.port == -1) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.getString("TomcatAppServer.start.CannotObtainPort"), null));
                }
            }
            if ((connector = this.embedded.createConnector(null, this.port, false)) instanceof CoyoteConnector) {
                int minProcessors;
                int maxProcessors;
                Preferences pref;
                int acceptCount;
                CoyoteConnector connectorImpl = (CoyoteConnector)connector;
                if (iAddress != null) {
                    connectorImpl.setAddress(iAddress.getHostAddress());
                }
                if ((acceptCount = (pref = TomcatPlugin.getDefault().getPluginPreferences()).getInt("acceptCount")) > 0) {
                    connectorImpl.setAcceptCount(acceptCount);
                }
                if ((maxProcessors = pref.getInt("maxProcessors")) > 0) {
                    connectorImpl.setMaxProcessors(maxProcessors);
                }
                if ((minProcessors = pref.getInt("minProcessors")) > 0) {
                    connectorImpl.setMinProcessors(minProcessors);
                }
                connectorImpl.addLifecycleListener(new LifecycleListener(){

                    public void lifecycleEvent(LifecycleEvent event) {
                        if ("start".equals(event.getType())) {
                            TomcatAppServer.this.running = true;
                        }
                    }
                });
            }
            PrintStream sysErr = System.err;
            System.setErr(new PrintStream(new ByteArrayOutputStream()));
            try {
                this.embedded.addConnector(connector);
            }
            finally {
                System.setErr(sysErr);
            }
            if (this.hostAddress == null) {
                this.hostAddress = "127.0.0.1";
            }
        }
        catch (Exception exc) {
            TomcatPlugin.logError(TomcatResources.getString("TomcatAppServer.start"), exc);
            if (exc instanceof CoreException) {
                throw (CoreException)exc;
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.getString("TomcatAppServer.start"), (Throwable)exc));
        }
        if (!this.running) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.getString("TomcatAppServer.start"), null));
        }
    }

    public void start(String webappName, IPath path, ClassLoader customLoader) throws CoreException {
        if (!this.isStarted) {
            this.start(this.port, this.hostAddress);
        }
        if (!this.running) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.getString("TomcatAppServer.addingWebapp", webappName, path.toOSString()), null));
        }
        String contextPath = webappName;
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        try {
            Context context = this.embedded.createContext(contextPath, path.toOSString());
            if (context instanceof StandardContext) {
                ((StandardContext)context).setWorkDir(this.getWorkingDirectory(webappName));
            }
            WebAppClassLoader webappLoader = new WebAppClassLoader(customLoader);
            context.setLoader(this.embedded.createLoader((ClassLoader)webappLoader));
            this.host.addChild((Container)context);
        }
        catch (Exception exc) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.getString("TomcatAppServer.addingWebapp", webappName, path.toOSString()), (Throwable)exc));
        }
    }

    public void stop(String webappName) throws CoreException {
        if (!this.running) {
            return;
        }
        Context context = (Context)this.host.findChild("/" + webappName);
        if (context != null) {
            this.embedded.removeContext(context);
        }
    }

    public String getHost() {
        if (!this.running) {
            return null;
        }
        return this.hostAddress;
    }

    public int getPort() {
        if (!this.running) {
            return 0;
        }
        return this.port;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() throws CoreException {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.embedded.removeEngine(this.engine);
        }
        catch (Exception exc) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.getString("TomcatAppServer.engineRemove"), (Throwable)exc));
        }
        try {
            this.embedded.stop();
        }
        catch (LifecycleException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.getString("TomcatAppServer.embeddedStop"), (Throwable)e));
        }
    }

    private String getWorkingDirectory(String webApp) {
        return TomcatPlugin.getDefault().getStateLocation().append(webApp).toOSString();
    }
}

