/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.AbstractHandler;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.Priority;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorSashContainer;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.EditorStack;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.MultiEditorInnerPane;
import org.eclipse.ui.internal.MultiEditorOuterPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.part.MultiEditor;

public class EditorAreaHelper {
    private WorkbenchPage page;
    private ArrayList editorTable = new ArrayList(4);
    private EditorSashContainer editorArea;
    private HandlerSubmission openEditorDropDownHandlerSubmission;

    public EditorAreaHelper(WorkbenchPage page) {
        this.page = page;
        this.editorArea = new EditorSashContainer("org.eclipse.ui.editorss", page);
        this.editorArea.createControl(page.getClientComposite());
        Shell shell = page.getWorkbenchWindow().getShell();
        AbstractHandler openEditorDropDownHandler = new AbstractHandler(){

            public Object execute(Map parameterValuesByName) throws ExecutionException {
                EditorAreaHelper.this.displayEditorList();
                return null;
            }
        };
        this.openEditorDropDownHandlerSubmission = new HandlerSubmission(null, shell, null, "org.eclipse.ui.window.openEditorDropDown", openEditorDropDownHandler, Priority.MEDIUM);
        PlatformUI.getWorkbench().getCommandSupport().addHandlerSubmission(this.openEditorDropDownHandlerSubmission);
    }

    public void displayEditorList() {
        EditorStack activeWorkbook = this.editorArea.getActiveWorkbook();
        if (activeWorkbook != null) {
            activeWorkbook.showPartList();
        }
    }

    public void closeAllEditors() {
        this.editorArea.removeAllEditors();
        ArrayList editorsToDispose = (ArrayList)this.editorTable.clone();
        this.editorTable.clear();
        for (int i = 0; i < editorsToDispose.size(); ++i) {
            ((EditorPane)editorsToDispose.get(i)).dispose();
        }
    }

    public void closeEditor(IEditorReference ref) {
        EditorPane pane = (EditorPane)((WorkbenchPartReference)((Object)ref)).getPane();
        this.closeEditor(pane);
    }

    public void closeEditor(IEditorPart part) {
        EditorPane pane = (EditorPane)((PartSite)((Object)part.getEditorSite())).getPane();
        this.closeEditor(pane);
    }

    private void closeEditor(EditorPane pane) {
        if (pane != null) {
            if (!(pane instanceof MultiEditorInnerPane)) {
                this.editorArea.removeEditor(pane);
            }
            this.editorTable.remove(pane);
            pane.dispose();
        }
    }

    public static void derefPart(LayoutPart part) {
        LayoutPart parent;
        ILayoutContainer parentContainer;
        ILayoutContainer oldContainer = part.getContainer();
        if (oldContainer == null) {
            return;
        }
        oldContainer.remove(part);
        LayoutPart[] children = oldContainer.getChildren();
        if ((children == null || children.length == 0) && oldContainer instanceof LayoutPart && (parentContainer = (parent = (LayoutPart)((Object)oldContainer)).getContainer()) != null) {
            parentContainer.remove(parent);
            parent.dispose();
        }
    }

    public void dispose() {
        PlatformUI.getWorkbench().getCommandSupport().removeHandlerSubmission(this.openEditorDropDownHandlerSubmission);
        if (this.editorArea != null) {
            this.editorArea.dispose();
        }
    }

    public String getActiveEditorWorkbookID() {
        return this.editorArea.getActiveWorkbookID();
    }

    public IEditorReference[] getEditors() {
        int nSize = this.editorTable.size();
        IEditorReference[] retArray = new IEditorReference[nSize];
        for (int i = 0; i < retArray.length; ++i) {
            retArray[i] = ((EditorPane)this.editorTable.get(i)).getEditorReference();
        }
        return retArray;
    }

    public LayoutPart getLayoutPart() {
        return this.editorArea;
    }

    public IEditorReference getVisibleEditor() {
        EditorStack activeWorkbook = this.editorArea.getActiveWorkbook();
        EditorPane pane = activeWorkbook.getVisibleEditor();
        if (pane != null) {
            IEditorReference result = pane.getEditorReference();
            IEditorPart editorPart = (IEditorPart)result.getPart(false);
            if (editorPart != null && editorPart instanceof MultiEditor) {
                editorPart = ((MultiEditor)editorPart).getActiveEditor();
                EditorSite site = (EditorSite)editorPart.getSite();
                result = (IEditorReference)site.getPane().getPartReference();
            }
            return result;
        }
        return null;
    }

    public void fixVisibleEditor() {
        IEditorReference result;
        IEditorPart editorPart;
        LayoutPart[] editors;
        EditorStack activeWorkbook = this.editorArea.getActiveWorkbook();
        EditorPane pane = activeWorkbook.getVisibleEditor();
        if (pane == null && (editors = activeWorkbook.getChildren()).length > 0) {
            pane = (EditorPane)editors[0];
        }
        if (pane != null && (editorPart = (IEditorPart)(result = pane.getEditorReference()).getPart(true)) != null) {
            activeWorkbook.setVisibleEditor(pane);
        }
    }

    public void moveEditor(IEditorPart part, int position) {
        EditorPane pane = (EditorPane)((EditorSite)part.getSite()).getPane();
    }

    public void openEditor(IEditorReference ref, IEditorReference[] innerEditors, boolean setVisible) {
        MultiEditorOuterPane pane = new MultiEditorOuterPane(ref, this.page, this.editorArea.getActiveWorkbook());
        this.initPane(pane, ref);
        for (int i = 0; i < innerEditors.length; ++i) {
            MultiEditorInnerPane innerPane = new MultiEditorInnerPane(pane, innerEditors[i], this.page, this.editorArea.getActiveWorkbook());
            this.initPane(innerPane, innerEditors[i]);
        }
        this.editorArea.addEditor(pane);
        if (setVisible) {
            this.setVisibleEditor(ref, false);
        }
    }

    public void openEditor(IEditorReference ref, boolean setVisible) {
        EditorPane pane = new EditorPane(ref, this.page, this.editorArea.getActiveWorkbook());
        this.initPane(pane, ref);
        this.editorArea.addEditor(pane);
        if (setVisible) {
            this.setVisibleEditor(ref, false);
        }
    }

    private EditorPane initPane(EditorPane pane, IEditorReference ref) {
        ((WorkbenchPartReference)((Object)ref)).setPane(pane);
        this.editorTable.add(pane);
        return pane;
    }

    public IStatus restoreState(IMemento memento) {
        return this.editorArea.restoreState(memento);
    }

    public IStatus restorePresentationState(IMemento areaMem) {
        return this.editorArea.restorePresentationState(areaMem);
    }

    public IStatus saveState(IMemento memento) {
        return this.editorArea.saveState(memento);
    }

    public void setActiveEditorWorkbookFromID(String id) {
        this.editorArea.setActiveWorkbookFromID(id);
    }

    public void showVisibleEditor() {
        EditorStack activeWorkbook = this.editorArea.getActiveWorkbook();
        if (activeWorkbook != null) {
            activeWorkbook.showVisibleEditor();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setVisibleEditor(IEditorReference ref, boolean setFocus) {
        IEditorReference visibleEditor = this.getVisibleEditor();
        if (ref == visibleEditor) return false;
        IEditorPart part = (IEditorPart)ref.getPart(true);
        EditorPane pane = null;
        if (part != null) {
            pane = (EditorPane)((PartSite)((Object)part.getEditorSite())).getPane();
        }
        if (pane == null) return false;
        if (pane instanceof MultiEditorInnerPane) {
            EditorPane parentPane = ((MultiEditorInnerPane)pane).getParentPane();
            EditorStack activeWorkbook = parentPane.getWorkbook();
            EditorPane activePane = activeWorkbook.getVisibleEditor();
            if (activePane == parentPane) return false;
            parentPane.getWorkbook().setVisibleEditor(parentPane);
        } else {
            pane.getWorkbook().setVisibleEditor(pane);
        }
        if (!setFocus) return true;
        part.setFocus();
        return true;
    }

    public ArrayList getWorkbooks() {
        return this.editorArea.getEditorWorkbooks();
    }
}

