/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class SashForm
extends Composite {
    public int SASH_WIDTH = 3;
    private static final int DRAG_MINIMUM = 20;
    private int orientation = 256;
    private Sash[] sashes = new Sash[0];
    private Color background = null;
    private Color foreground = null;
    private Control[] controls = new Control[0];
    private Control maxControl = null;
    private Listener sashListener;
    private static final String LAYOUT_RATIO = "layout ratio";

    public SashForm(Composite parent, int style) {
        super(parent, SashForm.checkStyle(style));
        if ((style & 0x200) != 0) {
            this.orientation = 512;
        }
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                SashForm.this.layout(true);
            }
        });
        this.sashListener = new Listener(){

            public void handleEvent(Event e) {
                SashForm.this.onDragSash(e);
            }
        };
    }

    private static int checkStyle(int style) {
        int mask = 0x6000800;
        return style & mask;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        boolean vertical;
        this.checkWidget();
        Control[] cArray = this.getControls(true);
        if (cArray.length == 0) {
            return new Point(wHint, hHint);
        }
        int sashwidth = this.sashes.length > 0 ? this.SASH_WIDTH + this.sashes[0].getBorderWidth() * 2 : this.SASH_WIDTH;
        int width = 0;
        int height = 0;
        boolean bl = vertical = this.orientation == 512;
        if (vertical) {
            height += (cArray.length - 1) * sashwidth;
        } else {
            width += (cArray.length - 1) * sashwidth;
        }
        for (int i = 0; i < cArray.length; ++i) {
            Point size;
            if (vertical) {
                size = cArray[i].computeSize(wHint, -1);
                height += size.y;
                width = Math.max(width, size.x);
                continue;
            }
            size = cArray[i].computeSize(-1, hHint);
            width += size.x;
            height = Math.max(height, size.y);
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Control getMaximizedControl() {
        return this.maxControl;
    }

    public int[] getWeights() {
        this.checkWidget();
        Control[] cArray = this.getControls(false);
        int[] ratios = new int[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            Long ratio = (Long)cArray[i].getData(LAYOUT_RATIO);
            ratios[i] = ratio != null ? (int)(ratio * 1000L >> 16) : 200;
        }
        return ratios;
    }

    Control[] getControls(boolean onlyVisible) {
        Control[] children = this.getChildren();
        Control[] result = new Control[]{};
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof Sash || onlyVisible && !children[i].getVisible()) continue;
            Control[] newResult = new Control[result.length + 1];
            System.arraycopy(result, 0, newResult, 0, result.length);
            newResult[result.length] = children[i];
            result = newResult;
        }
        return result;
    }

    public void layout(boolean changed) {
        Sash[] newSashes;
        this.checkWidget();
        Rectangle area = this.getClientArea();
        if (area.width == 0 || area.height == 0) {
            return;
        }
        Control[] newControls = this.getControls(true);
        if (this.controls.length == 0 && newControls.length == 0) {
            return;
        }
        this.controls = newControls;
        if (this.maxControl != null && !this.maxControl.isDisposed()) {
            for (int i = 0; i < this.controls.length; ++i) {
                if (this.controls[i] != this.maxControl) {
                    this.controls[i].setBounds(-200, -200, 0, 0);
                    continue;
                }
                this.controls[i].setBounds(area);
            }
            return;
        }
        if (this.sashes.length < this.controls.length - 1) {
            int sashStyle;
            newSashes = new Sash[this.controls.length - 1];
            System.arraycopy(this.sashes, 0, newSashes, 0, this.sashes.length);
            int n = sashStyle = this.orientation == 256 ? 512 : 256;
            if ((this.getStyle() & 0x800) != 0) {
                sashStyle |= 0x800;
            }
            for (int i = this.sashes.length; i < newSashes.length; ++i) {
                newSashes[i] = new Sash(this, sashStyle);
                newSashes[i].setBackground(this.background);
                newSashes[i].setForeground(this.foreground);
                newSashes[i].addListener(13, this.sashListener);
            }
            this.sashes = newSashes;
        }
        if (this.sashes.length > this.controls.length - 1) {
            if (this.controls.length == 0) {
                for (int i = 0; i < this.sashes.length; ++i) {
                    this.sashes[i].dispose();
                }
                this.sashes = new Sash[0];
            } else {
                newSashes = new Sash[this.controls.length - 1];
                System.arraycopy(this.sashes, 0, newSashes, 0, newSashes.length);
                for (int i = this.controls.length - 1; i < this.sashes.length; ++i) {
                    this.sashes[i].dispose();
                }
                this.sashes = newSashes;
            }
        }
        if (this.controls.length == 0) {
            return;
        }
        int sashwidth = this.sashes.length > 0 ? this.SASH_WIDTH + this.sashes[0].getBorderWidth() * 2 : this.SASH_WIDTH;
        long[] ratios = new long[this.controls.length];
        long total = 0L;
        for (int i = 0; i < this.controls.length; ++i) {
            Long ratio = (Long)this.controls[i].getData(LAYOUT_RATIO);
            ratios[i] = ratio != null ? ratio : 13108L;
            total += ratios[i];
        }
        total = this.orientation == 256 ? (total += (((long)(this.sashes.length * sashwidth) << 16) + (long)area.width - 1L) / (long)area.width) : (total += (((long)(this.sashes.length * sashwidth) << 16) + (long)area.height - 1L) / (long)area.height);
        if (this.orientation == 256) {
            int width = (int)(ratios[0] * (long)area.width / total);
            int x = area.x;
            this.controls[0].setBounds(x, area.y, width, area.height);
            x += width;
            for (int i = 1; i < this.controls.length - 1; ++i) {
                this.sashes[i - 1].setBounds(x, area.y, sashwidth, area.height);
                width = (int)(ratios[i] * (long)area.width / total);
                this.controls[i].setBounds(x += sashwidth, area.y, width, area.height);
                x += width;
            }
            if (this.controls.length > 1) {
                this.sashes[this.sashes.length - 1].setBounds(x, area.y, sashwidth, area.height);
                width = area.width - (x += sashwidth);
                this.controls[this.controls.length - 1].setBounds(x, area.y, width, area.height);
            }
        } else {
            int height = (int)(ratios[0] * (long)area.height / total);
            int y = area.y;
            this.controls[0].setBounds(area.x, y, area.width, height);
            y += height;
            for (int i = 1; i < this.controls.length - 1; ++i) {
                this.sashes[i - 1].setBounds(area.x, y, area.width, sashwidth);
                height = (int)(ratios[i] * (long)area.height / total);
                this.controls[i].setBounds(area.x, y += sashwidth, area.width, height);
                y += height;
            }
            if (this.controls.length > 1) {
                this.sashes[this.sashes.length - 1].setBounds(area.x, y, area.width, sashwidth);
                height = area.height - (y += sashwidth);
                this.controls[this.controls.length - 1].setBounds(area.x, y, area.width, height);
            }
        }
    }

    void onDragSash(Event event) {
        if (event.detail == 1) {
            Rectangle area = this.getClientArea();
            if (this.orientation == 256) {
                event.x = Math.min(Math.max(20, event.x), area.width - 20);
            } else {
                event.y = Math.min(Math.max(20, event.y), area.height - 20);
            }
            return;
        }
        Sash sash = (Sash)event.widget;
        int sashIndex = -1;
        for (int i = 0; i < this.sashes.length; ++i) {
            if (this.sashes[i] != sash) continue;
            sashIndex = i;
            break;
        }
        if (sashIndex == -1) {
            return;
        }
        Control c1 = this.controls[sashIndex];
        Control c2 = this.controls[sashIndex + 1];
        Rectangle b1 = c1.getBounds();
        Rectangle b2 = c2.getBounds();
        Rectangle sashBounds = sash.getBounds();
        Rectangle area = this.getClientArea();
        if (this.orientation == 256) {
            int shift = event.x - sashBounds.x;
            b1.width += shift;
            b2.x += shift;
            b2.width -= shift;
            if (b1.width < 20 || b2.width < 20) {
                return;
            }
            c1.setData(LAYOUT_RATIO, new Long((((long)b1.width << 16) + (long)area.width - 1L) / (long)area.width));
            c2.setData(LAYOUT_RATIO, new Long((((long)b2.width << 16) + (long)area.width - 1L) / (long)area.width));
        } else {
            int shift = event.y - sashBounds.y;
            b1.height += shift;
            b2.y += shift;
            b2.height -= shift;
            if (b1.height < 20 || b2.height < 20) {
                return;
            }
            c1.setData(LAYOUT_RATIO, new Long((((long)b1.height << 16) + (long)area.height - 1L) / (long)area.height));
            c2.setData(LAYOUT_RATIO, new Long((((long)b2.height << 16) + (long)area.height - 1L) / (long)area.height));
        }
        c1.setBounds(b1);
        sash.setBounds(event.x, event.y, event.width, event.height);
        c2.setBounds(b2);
    }

    public void setOrientation(int orientation) {
        int sashStyle;
        this.checkWidget();
        if (this.orientation == orientation) {
            return;
        }
        if (orientation != 256 && orientation != 512) {
            SWT.error(5);
        }
        this.orientation = orientation;
        int n = sashStyle = orientation == 256 ? 512 : 256;
        if ((this.getStyle() & 0x800) != 0) {
            sashStyle |= 0x800;
        }
        for (int i = 0; i < this.sashes.length; ++i) {
            this.sashes[i].dispose();
            this.sashes[i] = new Sash(this, sashStyle);
            this.sashes[i].setBackground(this.background);
            this.sashes[i].setForeground(this.foreground);
            this.sashes[i].addListener(13, this.sashListener);
        }
        this.layout();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.background = color;
        for (int i = 0; i < this.sashes.length; ++i) {
            this.sashes[i].setBackground(this.background);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground = color;
        for (int i = 0; i < this.sashes.length; ++i) {
            this.sashes[i].setForeground(this.foreground);
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMaximizedControl(Control control) {
        this.checkWidget();
        if (control == null) {
            if (this.maxControl != null) {
                this.maxControl = null;
                this.layout();
                for (int i = 0; i < this.sashes.length; ++i) {
                    this.sashes[i].setVisible(true);
                }
            }
            return;
        }
        for (int i = 0; i < this.sashes.length; ++i) {
            this.sashes[i].setVisible(false);
        }
        this.maxControl = control;
        this.layout();
    }

    public void setWeights(int[] weights) {
        int i;
        this.checkWidget();
        Control[] cArray = this.getControls(false);
        if (weights == null || weights.length != cArray.length) {
            SWT.error(5);
        }
        int total = 0;
        for (i = 0; i < weights.length; ++i) {
            if (weights[i] < 0) {
                SWT.error(5);
            }
            total += weights[i];
        }
        if (total == 0) {
            SWT.error(5);
        }
        for (i = 0; i < cArray.length; ++i) {
            cArray[i].setData(LAYOUT_RATIO, new Long((((long)weights[i] << 16) + (long)total - 1L) / (long)total));
        }
        this.layout();
    }
}

