/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class GridLayout
extends Layout {
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int numColumns = 1;
    public boolean makeColumnsEqualWidth = false;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;
    Vector grid = new Vector();
    int[] pixelColumnWidths;
    int[] pixelRowHeights;
    int[] expandableColumns;
    int[] expandableRows;

    public GridLayout() {
    }

    public GridLayout(int numColumns, boolean makeColumnsEqualWidth) {
        this.numColumns = numColumns;
        this.makeColumnsEqualWidth = makeColumnsEqualWidth;
    }

    void adjustGridDimensions(Composite composite, boolean flushCache) {
        for (int row = 0; row < this.grid.size(); ++row) {
            for (int column = 0; column < this.numColumns; ++column) {
                int rowHeight;
                int i;
                int j;
                int i2;
                int extraSpaceNeeded;
                int spannedSize;
                int lastSpanIndex;
                Point extent;
                Control child;
                GridData spec = ((GridData[])this.grid.elementAt(row))[column];
                if (!spec.isItemData()) continue;
                if (spec.hSpan > 1) {
                    child = composite.getChildren()[spec.childIndex];
                    extent = child.computeSize(spec.widthHint, spec.heightHint, flushCache);
                    lastSpanIndex = column + spec.hSpan;
                    spannedSize = 0;
                    for (int c = column; c < lastSpanIndex; ++c) {
                        spannedSize = spannedSize + this.pixelColumnWidths[c] + this.horizontalSpacing;
                    }
                    if (extent.x + spec.horizontalIndent > (spannedSize -= this.horizontalSpacing)) {
                        int colWidth;
                        extraSpaceNeeded = extent.x + spec.horizontalIndent - spannedSize;
                        int lastColumn = column + spec.hSpan - 1;
                        if (this.makeColumnsEqualWidth) {
                            int columnExtra = extraSpaceNeeded / this.numColumns;
                            int columnRemainder = extraSpaceNeeded % this.numColumns;
                            for (int i3 = 0; i3 < this.pixelColumnWidths.length; ++i3) {
                                this.pixelColumnWidths[i3] = colWidth = this.pixelColumnWidths[i3] + columnExtra;
                            }
                            this.pixelColumnWidths[lastColumn] = colWidth = this.pixelColumnWidths[lastColumn] + columnRemainder;
                        } else {
                            Vector<Integer> localExpandableColumns = new Vector<Integer>();
                            for (i2 = column; i2 <= lastColumn; ++i2) {
                                for (j = 0; j < this.expandableColumns.length; ++j) {
                                    if (this.expandableColumns[j] != i2) continue;
                                    localExpandableColumns.addElement(new Integer(i2));
                                }
                            }
                            if (localExpandableColumns.size() > 0) {
                                int columnExtra = extraSpaceNeeded / localExpandableColumns.size();
                                int columnRemainder = extraSpaceNeeded % localExpandableColumns.size();
                                for (i = 0; i < localExpandableColumns.size(); ++i) {
                                    int expandableCol = (Integer)localExpandableColumns.elementAt(i);
                                    this.pixelColumnWidths[expandableCol] = colWidth = this.pixelColumnWidths[expandableCol] + columnExtra;
                                }
                                this.pixelColumnWidths[lastColumn] = colWidth = this.pixelColumnWidths[lastColumn] + columnRemainder;
                            } else {
                                this.pixelColumnWidths[lastColumn] = colWidth = this.pixelColumnWidths[lastColumn] + extraSpaceNeeded;
                            }
                        }
                    }
                }
                if (spec.verticalSpan <= 1) continue;
                child = composite.getChildren()[spec.childIndex];
                extent = child.computeSize(spec.widthHint, spec.heightHint, flushCache);
                lastSpanIndex = row + spec.verticalSpan;
                spannedSize = 0;
                for (int r = row; r < lastSpanIndex; ++r) {
                    spannedSize = spannedSize + this.pixelRowHeights[r] + this.verticalSpacing;
                }
                if (extent.y <= (spannedSize -= this.verticalSpacing)) continue;
                extraSpaceNeeded = extent.y - spannedSize;
                int lastRow = row + spec.verticalSpan - 1;
                Vector<Integer> localExpandableRows = new Vector<Integer>();
                for (i2 = row; i2 <= lastRow; ++i2) {
                    for (j = 0; j < this.expandableRows.length; ++j) {
                        if (this.expandableRows[j] != i2) continue;
                        localExpandableRows.addElement(new Integer(i2));
                    }
                }
                if (localExpandableRows.size() > 0) {
                    int rowExtra = extraSpaceNeeded / localExpandableRows.size();
                    int rowRemainder = extraSpaceNeeded % localExpandableRows.size();
                    for (i = 0; i < localExpandableRows.size(); ++i) {
                        int expandableRow = (Integer)localExpandableRows.elementAt(i);
                        this.pixelRowHeights[expandableRow] = rowHeight = this.pixelRowHeights[expandableRow] + rowExtra;
                    }
                    this.pixelRowHeights[lastRow] = rowHeight = this.pixelRowHeights[lastRow] + rowRemainder;
                    continue;
                }
                this.pixelRowHeights[lastRow] = rowHeight = this.pixelRowHeights[lastRow] + extraSpaceNeeded;
            }
        }
    }

    void calculateGridDimensions(Composite composite, boolean flushCache) {
        GridData spec;
        int maxWidth;
        Control[] children = composite.getChildren();
        Point[] childSizes = new Point[children.length];
        this.pixelColumnWidths = new int[this.numColumns];
        this.pixelRowHeights = new int[this.grid.size()];
        for (int column = 0; column < this.numColumns; ++column) {
            maxWidth = 0;
            for (int row = 0; row < this.grid.size(); ++row) {
                spec = ((GridData[])this.grid.elementAt(row))[column];
                if (!spec.isItemData()) continue;
                Control child = children[spec.childIndex];
                childSizes[spec.childIndex] = child.computeSize(spec.widthHint, spec.heightHint, flushCache);
                int childWidth = childSizes[spec.childIndex].x + spec.horizontalIndent;
                if (spec.hSpan != 1) continue;
                maxWidth = Math.max(maxWidth, childWidth);
            }
            this.pixelColumnWidths[column] = maxWidth;
        }
        if (this.makeColumnsEqualWidth) {
            int i;
            maxWidth = 0;
            for (i = 0; i < this.numColumns; ++i) {
                maxWidth = Math.max(maxWidth, this.pixelColumnWidths[i]);
            }
            maxWidth += this.horizontalSpacing;
            for (i = 0; i < this.numColumns; ++i) {
                this.pixelColumnWidths[i] = maxWidth;
            }
        }
        for (int row = 0; row < this.grid.size(); ++row) {
            int maxHeight = 0;
            for (int column = 0; column < this.numColumns; ++column) {
                spec = ((GridData[])this.grid.elementAt(row))[column];
                if (!spec.isItemData()) continue;
                int childHeight = childSizes[spec.childIndex].y;
                if (spec.verticalSpan != 1) continue;
                maxHeight = Math.max(maxHeight, childHeight);
            }
            this.pixelRowHeights[row] = maxHeight;
        }
    }

    void computeExpandableCells() {
        Hashtable<Integer, Object> growColumns = new Hashtable<Integer, Object>();
        Hashtable<Integer, Object> growRows = new Hashtable<Integer, Object>();
        for (int col = 0; col < this.numColumns; ++col) {
            for (int row = 0; row < this.grid.size(); ++row) {
                GridData spec = ((GridData[])this.grid.elementAt(row))[col];
                if (spec.grabExcessHorizontalSpace) {
                    growColumns.put(new Integer(col + spec.hSpan - 1), new Object());
                }
                if (!spec.grabExcessVerticalSpace) continue;
                growRows.put(new Integer(row + spec.verticalSpan - 1), new Object());
            }
        }
        int i = 0;
        Enumeration enumeration = growColumns.keys();
        this.expandableColumns = new int[growColumns.size()];
        while (enumeration.hasMoreElements()) {
            this.expandableColumns[i] = (Integer)enumeration.nextElement();
            ++i;
        }
        i = 0;
        enumeration = growRows.keys();
        this.expandableRows = new int[growRows.size()];
        while (enumeration.hasMoreElements()) {
            this.expandableRows[i] = (Integer)enumeration.nextElement();
            ++i;
        }
    }

    Point computeLayoutSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        int i;
        if (this.grid.size() == 0) {
            this.createGrid(composite);
            this.calculateGridDimensions(composite, flushCache);
            this.computeExpandableCells();
            this.adjustGridDimensions(composite, flushCache);
        }
        int cols = this.numColumns;
        int rows = this.grid.size();
        int totalMarginHeight = this.marginHeight;
        int totalMarginWidth = this.marginWidth;
        int totalWidth = totalMarginWidth * 2 + (cols - 1) * this.horizontalSpacing;
        for (i = 0; i < this.pixelColumnWidths.length; ++i) {
            totalWidth += this.pixelColumnWidths[i];
        }
        int totalHeight = totalMarginHeight * 2 + (rows - 1) * this.verticalSpacing;
        for (i = 0; i < this.pixelRowHeights.length; ++i) {
            totalHeight += this.pixelRowHeights[i];
        }
        if (wHint != -1) {
            totalWidth = wHint;
        }
        if (hHint != -1) {
            totalHeight = hHint;
        }
        return new Point(totalWidth, totalHeight);
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children = composite.getChildren();
        int numChildren = children.length;
        if (numChildren == 0) {
            return new Point(0, 0);
        }
        if (flushCache) {
            this.grid.removeAllElements();
        }
        return this.computeLayoutSize(composite, wHint, hHint, flushCache);
    }

    Point getFirstEmptyCell(int row, int column) {
        GridData[] rowData = (GridData[])this.grid.elementAt(row);
        while (column < this.numColumns && rowData[column] != null) {
            ++column;
        }
        if (column == this.numColumns) {
            column = 0;
            if (++row == this.grid.size()) {
                this.grid.addElement(this.emptyRow());
            }
            return this.getFirstEmptyCell(row, column);
        }
        return new Point(row, column);
    }

    Point getLastEmptyCell(int row, int column) {
        GridData[] rowData = (GridData[])this.grid.elementAt(row);
        while (column < this.numColumns && rowData[column] == null) {
            ++column;
        }
        return new Point(row, column - 1);
    }

    Point getCell(int row, int column, int width, int height) {
        Point start = this.getFirstEmptyCell(row, column);
        Point end = this.getLastEmptyCell(start.x, start.y);
        if (end.y + 1 - start.y >= width) {
            return start;
        }
        GridData[] rowData = (GridData[])this.grid.elementAt(start.x);
        for (int j = start.y; j < end.y + 1; ++j) {
            GridData spacerSpec = new GridData();
            spacerSpec.isItemData = false;
            rowData[j] = spacerSpec;
        }
        return this.getCell(end.x, end.y, width, height);
    }

    void createGrid(Composite composite) {
        GridData spacerSpec;
        Control[] children = composite.getChildren();
        this.grid.addElement(this.emptyRow());
        int row = 0;
        int column = 0;
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            GridData spec = (GridData)child.getLayoutData();
            if (spec == null) {
                spec = new GridData();
                child.setLayoutData(spec);
            }
            spec.hSpan = Math.min(spec.horizontalSpan, this.numColumns);
            Point p = this.getCell(row, column, spec.hSpan, spec.verticalSpan);
            row = p.x;
            column = p.y;
            for (int j = 2; j <= spec.verticalSpan; ++j) {
                if (row + j <= this.grid.size()) continue;
                this.grid.addElement(this.emptyRow());
            }
            ((GridData[])this.grid.elementAt((int)row))[column] = spec;
            spec.childIndex = i;
            int rowFill = spec.verticalSpan - 1;
            int columnFill = spec.hSpan - 1;
            for (int r = 1; r <= rowFill; ++r) {
                for (int c = 0; c < spec.hSpan; ++c) {
                    spacerSpec = new GridData();
                    spacerSpec.isItemData = false;
                    ((GridData[])this.grid.elementAt((int)(row + r)))[column + c] = spacerSpec;
                }
            }
            for (int c = 1; c <= columnFill; ++c) {
                for (int r = 0; r < spec.verticalSpan; ++r) {
                    spacerSpec = new GridData();
                    spacerSpec.isItemData = false;
                    ((GridData[])this.grid.elementAt((int)(row + r)))[column + c] = spacerSpec;
                }
            }
            column = column + spec.hSpan - 1;
        }
        for (int r = row; r < this.grid.size(); ++r) {
            GridData[] rowData = (GridData[])this.grid.elementAt(r);
            for (int c = 0; c < this.numColumns; ++c) {
                if (rowData[c] != null) continue;
                spacerSpec = new GridData();
                spacerSpec.isItemData = false;
                rowData[c] = spacerSpec;
            }
        }
    }

    GridData[] emptyRow() {
        GridData[] row = new GridData[this.numColumns];
        for (int i = 0; i < this.numColumns; ++i) {
            row[i] = null;
        }
        return row;
    }

    protected void layout(Composite composite, boolean flushCache) {
        GridData spec;
        int i;
        int i2;
        int last;
        int remainder;
        int excess;
        int i3;
        Control[] children;
        if (flushCache) {
            this.grid.removeAllElements();
        }
        if ((children = composite.getChildren()).length == 0) {
            return;
        }
        Point extent = this.computeSize(composite, -1, -1, flushCache);
        int[] columnWidths = new int[this.numColumns];
        for (i3 = 0; i3 < this.pixelColumnWidths.length; ++i3) {
            columnWidths[i3] = this.pixelColumnWidths[i3];
        }
        int[] rowHeights = new int[this.grid.size()];
        for (i3 = 0; i3 < this.pixelRowHeights.length; ++i3) {
            rowHeights[i3] = this.pixelRowHeights[i3];
        }
        int columnWidth = 0;
        int rowSize = Math.max(1, this.grid.size());
        int compositeWidth = extent.x;
        int compositeHeight = extent.y;
        int excessHorizontal = composite.getClientArea().width - compositeWidth;
        int excessVertical = composite.getClientArea().height - compositeHeight;
        if (this.expandableColumns.length != 0) {
            int colWidth;
            excess = excessHorizontal / this.expandableColumns.length;
            remainder = excessHorizontal % this.expandableColumns.length;
            last = 0;
            for (i2 = 0; i2 < this.expandableColumns.length; ++i2) {
                int expandableCol = this.expandableColumns[i2];
                colWidth = columnWidths[expandableCol];
                columnWidths[expandableCol] = colWidth += excess;
                last = Math.max(last, expandableCol);
            }
            colWidth = columnWidths[last];
            columnWidths[last] = colWidth += remainder;
        }
        for (i = 0; i < this.expandableColumns.length; ++i) {
            int expandableCol = this.expandableColumns[i];
            int colWidth = columnWidths[expandableCol];
            int minWidth = 0;
            for (int j = 0; j < this.grid.size(); ++j) {
                GridData[] row = (GridData[])this.grid.elementAt(j);
                spec = row[expandableCol];
                if (spec.hSpan != 1) continue;
                minWidth = Math.max(minWidth, spec.widthHint);
            }
            columnWidths[expandableCol] = Math.max(colWidth, minWidth);
        }
        if (this.expandableRows.length != 0) {
            int rowHeight;
            excess = excessVertical / this.expandableRows.length;
            remainder = excessVertical % this.expandableRows.length;
            last = 0;
            for (i2 = 0; i2 < this.expandableRows.length; ++i2) {
                int expandableRow = this.expandableRows[i2];
                rowHeight = rowHeights[expandableRow];
                rowHeights[expandableRow] = rowHeight += excess;
                last = Math.max(last, expandableRow);
            }
            rowHeight = rowHeights[last];
            rowHeights[last] = rowHeight += remainder;
        }
        for (i = 0; i < this.expandableRows.length; ++i) {
            int expandableRow = this.expandableRows[i];
            int rowHeight = rowHeights[expandableRow];
            int minHeight = 0;
            GridData[] row = (GridData[])this.grid.elementAt(expandableRow);
            for (int j = 0; j < this.numColumns; ++j) {
                spec = row[j];
                if (spec.verticalSpan != 1) continue;
                minHeight = Math.max(minHeight, spec.heightHint);
            }
            rowHeights[expandableRow] = Math.max(rowHeight, minHeight);
        }
        int columnX = this.marginWidth + composite.getClientArea().x;
        int rowY = this.marginHeight + composite.getClientArea().y;
        for (int r = 0; r < rowSize; ++r) {
            int rowHeight = rowHeights[r];
            GridData[] row = (GridData[])this.grid.elementAt(r);
            for (int c = 0; c < row.length; ++c) {
                int k;
                int spannedWidth = 0;
                int spannedHeight = 0;
                int hAlign = 0;
                int vAlign = 0;
                int widgetX = 0;
                int widgetY = 0;
                int widgetW = 0;
                int widgetH = 0;
                GridData spec2 = row[c];
                if (this.makeColumnsEqualWidth) {
                    columnWidth = composite.getClientArea().width - 2 * this.marginWidth - (this.numColumns - 1) * this.horizontalSpacing;
                    columnWidth /= this.numColumns;
                    for (int i4 = 0; i4 < columnWidths.length; ++i4) {
                        columnWidths[i4] = columnWidth;
                    }
                } else {
                    columnWidth = columnWidths[c];
                }
                spannedWidth = columnWidth;
                for (k = 1; k < spec2.hSpan; ++k) {
                    if (c + k > this.numColumns) continue;
                    if (!this.makeColumnsEqualWidth) {
                        columnWidth = columnWidths[c + k];
                    }
                    spannedWidth = spannedWidth + columnWidth + this.horizontalSpacing;
                }
                spannedHeight = rowHeight;
                for (k = 1; k < spec2.verticalSpan; ++k) {
                    if (r + k > this.grid.size()) continue;
                    spannedHeight = spannedHeight + rowHeights[r + k] + this.verticalSpacing;
                }
                if (spec2.isItemData()) {
                    Control child = children[spec2.childIndex];
                    Point childExtent = child.computeSize(spec2.widthHint, spec2.heightHint, flushCache);
                    hAlign = spec2.horizontalAlignment;
                    widgetX = columnX;
                    widgetX = hAlign == 2 || hAlign == 0x1000000 ? widgetX + spannedWidth / 2 - childExtent.x / 2 : (hAlign == 3 || hAlign == 0x1000008 || hAlign == 131072 ? widgetX + spannedWidth - childExtent.x - spec2.horizontalIndent : (widgetX += spec2.horizontalIndent));
                    if (hAlign == 4) {
                        widgetW = spannedWidth - spec2.horizontalIndent;
                        widgetX = columnX + spec2.horizontalIndent;
                    } else {
                        widgetW = childExtent.x;
                    }
                    vAlign = spec2.verticalAlignment;
                    widgetY = rowY;
                    if (vAlign == 2 || vAlign == 0x1000000) {
                        widgetY = widgetY + spannedHeight / 2 - childExtent.y / 2;
                    } else if (vAlign == 3 || vAlign == 0x1000008 || vAlign == 1024) {
                        widgetY = widgetY + spannedHeight - childExtent.y;
                    }
                    if (vAlign == 4) {
                        widgetH = spannedHeight;
                        widgetY = rowY;
                    } else {
                        widgetH = childExtent.y;
                    }
                    child.setBounds(widgetX, widgetY, widgetW, widgetH);
                }
                columnX = columnX + columnWidths[c] + this.horizontalSpacing;
            }
            rowY = rowY + rowHeights[r] + this.verticalSpacing;
            columnX = this.marginWidth + composite.getClientArea().x;
        }
    }
}

