/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class EqualExpression
extends BinaryExpression {
    public EqualExpression(Expression left, Expression right, int operator) {
        super(left, right, operator);
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if ((this.bits & 0xFC0) >> 6 == 18) {
            if (this.left.constant != NotAConstant && this.left.constant.typeID() == 5) {
                if (this.left.constant.booleanValue()) {
                    return this.right.analyseCode(currentScope, flowContext, flowInfo);
                }
                return this.right.analyseCode(currentScope, flowContext, flowInfo).asNegatedCondition();
            }
            if (this.right.constant != NotAConstant && this.right.constant.typeID() == 5) {
                if (this.right.constant.booleanValue()) {
                    return this.left.analyseCode(currentScope, flowContext, flowInfo);
                }
                return this.left.analyseCode(currentScope, flowContext, flowInfo).asNegatedCondition();
            }
            return this.right.analyseCode(currentScope, flowContext, this.left.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits()).unconditionalInits();
        }
        if (this.left.constant != NotAConstant && this.left.constant.typeID() == 5) {
            if (!this.left.constant.booleanValue()) {
                return this.right.analyseCode(currentScope, flowContext, flowInfo);
            }
            return this.right.analyseCode(currentScope, flowContext, flowInfo).asNegatedCondition();
        }
        if (this.right.constant != NotAConstant && this.right.constant.typeID() == 5) {
            if (!this.right.constant.booleanValue()) {
                return this.left.analyseCode(currentScope, flowContext, flowInfo);
            }
            return this.left.analyseCode(currentScope, flowContext, flowInfo).asNegatedCondition();
        }
        return this.right.analyseCode(currentScope, flowContext, this.left.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits()).asNegatedCondition().unconditionalInits();
    }

    public final boolean areTypesCastCompatible(BlockScope scope, TypeBinding castType, TypeBinding expressionType) {
        if (castType == expressionType) {
            return true;
        }
        if (expressionType.isArrayType()) {
            if (castType.isArrayType()) {
                TypeBinding expressionEltType = ((ArrayBinding)expressionType).elementsType(scope);
                if (expressionEltType.isBaseType()) {
                    return ((ArrayBinding)castType).elementsType(scope) == expressionEltType;
                }
                return this.areTypesCastCompatible(scope, ((ArrayBinding)castType).elementsType(scope), expressionEltType);
            }
            if (castType.isBaseType()) {
                return false;
            }
            if (castType.isClass()) {
                return castType.id == 1;
            }
            if (castType.isInterface()) {
                return castType.id == 36 || castType.id == 37;
            }
            return false;
        }
        if (expressionType == BaseTypes.NullBinding) {
            return !castType.isBaseType();
        }
        if (expressionType.isBaseType()) {
            return false;
        }
        if (expressionType.isClass()) {
            if (castType.isArrayType() && expressionType.id == 1) {
                return true;
            }
            if (castType.isBaseType()) {
                return false;
            }
            if (castType.isClass()) {
                if (expressionType.isCompatibleWith(castType)) {
                    return true;
                }
                return castType.isCompatibleWith(expressionType);
            }
            if (castType.isInterface()) {
                if (expressionType.isCompatibleWith(castType)) {
                    return true;
                }
                if (!((ReferenceBinding)expressionType).isFinal()) {
                    return true;
                }
            }
            return false;
        }
        if (expressionType.isInterface()) {
            if (castType.isArrayType()) {
                return expressionType.id == 36 || expressionType.id == 37;
            }
            if (castType.isBaseType()) {
                return false;
            }
            if (castType.isClass()) {
                if (castType.id == 1) {
                    return true;
                }
                if (((ReferenceBinding)castType).isFinal()) {
                    return castType.isCompatibleWith(expressionType);
                }
                return true;
            }
            if (castType.isInterface()) {
                if (expressionType.isCompatibleWith(castType)) {
                    return true;
                }
                if (!castType.isCompatibleWith(expressionType)) {
                    MethodBinding[] castTbMethods = ((ReferenceBinding)castType).methods();
                    int castTbMethodsLength = castTbMethods.length;
                    MethodBinding[] expressionTbMethods = ((ReferenceBinding)expressionType).methods();
                    int expressionTbMethodsLength = expressionTbMethods.length;
                    for (int i = 0; i < castTbMethodsLength; ++i) {
                        for (int j = 0; j < expressionTbMethodsLength; ++j) {
                            if (!CharOperation.equals(castTbMethods[i].selector, expressionTbMethods[j].selector) || castTbMethods[i].returnType == expressionTbMethods[j].returnType || !castTbMethods[i].areParametersEqual(expressionTbMethods[j])) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public final void computeConstant(TypeBinding leftType, TypeBinding rightType) {
        if (this.left.constant != NotAConstant && this.right.constant != NotAConstant) {
            this.constant = Constant.computeConstantOperationEQUAL_EQUAL(this.left.constant, leftType.id, 18, this.right.constant, rightType.id);
            if ((this.bits & 0xFC0) >> 6 == 29) {
                this.constant = Constant.fromValue(!this.constant.booleanValue());
            }
        } else {
            this.constant = NotAConstant;
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        if (this.constant != NotAConstant) {
            int pc = codeStream.position;
            if (valueRequired) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
            return;
        }
        this.bits |= 0x20;
        Label falseLabel = new Label(codeStream);
        this.generateOptimizedBoolean(currentScope, codeStream, null, falseLabel, valueRequired);
        if (falseLabel.hasForwardReferences()) {
            if (valueRequired) {
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.ireturn();
                    falseLabel.place();
                    codeStream.iconst_0();
                } else {
                    Label endLabel = new Label(codeStream);
                    codeStream.goto_(endLabel);
                    codeStream.decrStackSize(1);
                    falseLabel.place();
                    codeStream.iconst_0();
                    endLabel.place();
                }
            } else {
                falseLabel.place();
            }
        }
    }

    public void generateOptimizedBoolean(BlockScope currentScope, CodeStream codeStream, Label trueLabel, Label falseLabel, boolean valueRequired) {
        if (this.constant != Constant.NotAConstant) {
            super.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
            return;
        }
        if ((this.bits & 0xFC0) >> 6 == 18) {
            if ((this.left.implicitConversion & 0xF) == 5) {
                this.generateOptimizedBooleanEqual(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
            } else {
                this.generateOptimizedNonBooleanEqual(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
            }
        } else if ((this.left.implicitConversion & 0xF) == 5) {
            this.generateOptimizedBooleanEqual(currentScope, codeStream, falseLabel, trueLabel, valueRequired);
        } else {
            this.generateOptimizedNonBooleanEqual(currentScope, codeStream, falseLabel, trueLabel, valueRequired);
        }
    }

    public void generateOptimizedBooleanEqual(BlockScope currentScope, CodeStream codeStream, Label trueLabel, Label falseLabel, boolean valueRequired) {
        if (this.left.constant != NotAConstant) {
            boolean inline = this.left.constant.booleanValue();
            this.right.generateOptimizedBoolean(currentScope, codeStream, inline ? trueLabel : falseLabel, inline ? falseLabel : trueLabel, valueRequired);
            return;
        }
        if (this.right.constant != NotAConstant) {
            boolean inline = this.right.constant.booleanValue();
            this.left.generateOptimizedBoolean(currentScope, codeStream, inline ? trueLabel : falseLabel, inline ? falseLabel : trueLabel, valueRequired);
            return;
        }
        this.left.generateCode(currentScope, codeStream, valueRequired);
        this.right.generateCode(currentScope, codeStream, valueRequired);
        if (valueRequired) {
            if (falseLabel == null) {
                if (trueLabel != null) {
                    codeStream.if_icmpeq(trueLabel);
                }
            } else if (trueLabel == null) {
                codeStream.if_icmpne(falseLabel);
            }
        }
        codeStream.updateLastRecordedEndPC(codeStream.position);
    }

    public void generateOptimizedNonBooleanEqual(BlockScope currentScope, CodeStream codeStream, Label trueLabel, Label falseLabel, boolean valueRequired) {
        int pc = codeStream.position;
        Constant inline = this.right.constant;
        if (inline != NotAConstant && this.left.implicitConversion >> 4 == 10 && inline.intValue() == 0) {
            this.left.generateCode(currentScope, codeStream, valueRequired);
            if (valueRequired) {
                if (falseLabel == null) {
                    if (trueLabel != null) {
                        codeStream.ifeq(trueLabel);
                    }
                } else if (trueLabel == null) {
                    codeStream.ifne(falseLabel);
                }
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
            return;
        }
        inline = this.left.constant;
        if (inline != NotAConstant && this.left.implicitConversion >> 4 == 10 && inline.intValue() == 0) {
            this.right.generateCode(currentScope, codeStream, valueRequired);
            if (valueRequired) {
                if (falseLabel == null) {
                    if (trueLabel != null) {
                        codeStream.ifeq(trueLabel);
                    }
                } else if (trueLabel == null) {
                    codeStream.ifne(falseLabel);
                }
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
            return;
        }
        if (this.right instanceof NullLiteral) {
            if (this.left instanceof NullLiteral) {
                if (valueRequired) {
                    if ((this.bits & 0x20) != 0) {
                        if ((this.bits & 0xFC0) >> 6 == 18) {
                            codeStream.iconst_1();
                        } else {
                            codeStream.iconst_0();
                        }
                    } else if (falseLabel == null && trueLabel != null) {
                        codeStream.goto_(trueLabel);
                    }
                }
            } else {
                this.left.generateCode(currentScope, codeStream, valueRequired);
                if (valueRequired) {
                    if (falseLabel == null) {
                        if (trueLabel != null) {
                            codeStream.ifnull(trueLabel);
                        }
                    } else if (trueLabel == null) {
                        codeStream.ifnonnull(falseLabel);
                    }
                }
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
            return;
        }
        if (this.left instanceof NullLiteral) {
            this.right.generateCode(currentScope, codeStream, valueRequired);
            if (valueRequired) {
                if (falseLabel == null) {
                    if (trueLabel != null) {
                        codeStream.ifnull(trueLabel);
                    }
                } else if (trueLabel == null) {
                    codeStream.ifnonnull(falseLabel);
                }
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
            return;
        }
        this.left.generateCode(currentScope, codeStream, valueRequired);
        this.right.generateCode(currentScope, codeStream, valueRequired);
        if (valueRequired) {
            if (falseLabel == null) {
                if (trueLabel != null) {
                    switch (this.left.implicitConversion >> 4) {
                        case 10: {
                            codeStream.if_icmpeq(trueLabel);
                            break;
                        }
                        case 9: {
                            codeStream.fcmpl();
                            codeStream.ifeq(trueLabel);
                            break;
                        }
                        case 7: {
                            codeStream.lcmp();
                            codeStream.ifeq(trueLabel);
                            break;
                        }
                        case 8: {
                            codeStream.dcmpl();
                            codeStream.ifeq(trueLabel);
                            break;
                        }
                        default: {
                            codeStream.if_acmpeq(trueLabel);
                            break;
                        }
                    }
                }
            } else if (trueLabel == null) {
                switch (this.left.implicitConversion >> 4) {
                    case 10: {
                        codeStream.if_icmpne(falseLabel);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpl();
                        codeStream.ifne(falseLabel);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.ifne(falseLabel);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpl();
                        codeStream.ifne(falseLabel);
                        break;
                    }
                    default: {
                        codeStream.if_acmpne(falseLabel);
                    }
                }
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public boolean isCompactableOperation() {
        return false;
    }

    public TypeBinding resolveType(BlockScope scope) {
        boolean leftIsCast = this.left instanceof CastExpression;
        if (leftIsCast) {
            this.left.bits |= 0x20;
        }
        TypeBinding leftType = this.left.resolveType(scope);
        boolean rightIsCast = this.right instanceof CastExpression;
        if (rightIsCast) {
            this.right.bits |= 0x20;
        }
        TypeBinding rightType = this.right.resolveType(scope);
        if (leftType == null || rightType == null) {
            this.constant = NotAConstant;
            return null;
        }
        if (leftType.isBaseType() && rightType.isBaseType()) {
            int operatorSignature = OperatorSignatures[18][(leftType.id << 4) + rightType.id];
            this.left.implicitConversion = operatorSignature >>> 12;
            this.right.implicitConversion = operatorSignature >>> 4 & 0xFF;
            this.bits |= operatorSignature & 0xF;
            if ((operatorSignature & 0xF) == 0) {
                this.constant = Constant.NotAConstant;
                scope.problemReporter().invalidOperator(this, leftType, rightType);
                return null;
            }
            if (leftIsCast || rightIsCast) {
                CastExpression.checkNeedForArgumentCasts(scope, 18, operatorSignature, this.left, leftType.id, leftIsCast, this.right, rightType.id, rightIsCast);
            }
            this.computeConstant(leftType, rightType);
            this.resolvedType = BaseTypes.BooleanBinding;
            return this.resolvedType;
        }
        if (this.areTypesCastCompatible(scope, rightType, leftType) || this.areTypesCastCompatible(scope, leftType, rightType)) {
            boolean unnecessaryRightCast;
            if (rightType.id == 11 && leftType.id == 11) {
                this.computeConstant(leftType, rightType);
            } else {
                this.constant = NotAConstant;
            }
            if (rightType.id == 11) {
                this.right.implicitConversion = 187;
            }
            if (leftType.id == 11) {
                this.left.implicitConversion = 187;
            }
            boolean unnecessaryLeftCast = (this.left.bits & 0x4000) != 0;
            boolean bl = unnecessaryRightCast = (this.right.bits & 0x4000) != 0;
            if (unnecessaryLeftCast || unnecessaryRightCast) {
                TypeBinding alternateRightType;
                TypeBinding alternateLeftType = unnecessaryLeftCast ? ((CastExpression)this.left).expression.resolvedType : leftType;
                TypeBinding typeBinding = alternateRightType = unnecessaryRightCast ? ((CastExpression)this.right).expression.resolvedType : rightType;
                if (this.areTypesCastCompatible(scope, alternateLeftType, alternateRightType) || this.areTypesCastCompatible(scope, alternateRightType, alternateLeftType)) {
                    if (unnecessaryLeftCast) {
                        scope.problemReporter().unnecessaryCast((CastExpression)this.left);
                    }
                    if (unnecessaryRightCast) {
                        scope.problemReporter().unnecessaryCast((CastExpression)this.right);
                    }
                }
            }
            this.resolvedType = BaseTypes.BooleanBinding;
            return this.resolvedType;
        }
        this.constant = NotAConstant;
        scope.problemReporter().notCompatibleTypesError(this, leftType, rightType);
        return null;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.left.traverse(visitor, scope);
            this.right.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

