/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.participants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.IConditionChecker;
import org.eclipse.ltk.internal.core.refactoring.Assert;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.Resources;

public class ValidateEditChecker
implements IConditionChecker {
    private List fFiles = new ArrayList();
    private Object fContext;

    public ValidateEditChecker(Object context) {
        this.fContext = context;
    }

    public void addFile(IFile file) {
        Assert.isNotNull(file);
        this.fFiles.add(file);
    }

    public void addFiles(IFile[] files) {
        Assert.isNotNull(files);
        this.fFiles.addAll(Arrays.asList(files));
    }

    public RefactoringStatus check(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IResource[] resources = this.fFiles.toArray(new IResource[this.fFiles.size()]);
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync(resources);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create(status));
        }
        if (!(status = Resources.makeCommittable(resources, this.fContext)).isOK()) {
            result.merge(RefactoringStatus.create(status));
            if (!result.hasFatalError()) {
                result.addFatalError(RefactoringCoreMessages.getString("ValidateEditChecker.failed"));
            }
        }
        return result;
    }
}

