/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.JobQueue;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import com.intellij.util.messages.impl.MessageDeliveryListener;
import com.intellij.util.messages.impl.SimpleMessageBusConnectionImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class MessageBusImpl
implements MessageBus {
    protected static final Logger LOG = Logger.getInstance(MessageBusImpl.class);
    private static final Object NA = new Object();
    protected final ThreadLocal<JobQueue> messageQueue;
    protected final int[] order;
    protected final ConcurrentMap<Topic<?>, Object> publisherCache;
    protected final Collection<MessageHandlerHolder> subscribers;
    protected final Map<Topic<?>, List<?>> subscriberCache;
    @Nullable
    protected final CompositeMessageBus parentBus;
    protected final RootBus rootBus;
    protected final MessageBusOwner owner;
    private int disposeState;
    private Disposable connectionDisposable;
    protected MessageDeliveryListener messageDeliveryListener;

    MessageBusImpl(@NotNull MessageBusOwner owner) {
        if (owner == null) {
            MessageBusImpl.$$$reportNull$$$0(2);
        }
        this.messageQueue = ThreadLocal.withInitial(JobQueue::new);
        this.publisherCache = new ConcurrentHashMap();
        this.subscribers = new ConcurrentLinkedQueue<MessageHandlerHolder>();
        this.subscriberCache = new ConcurrentHashMap();
        this.connectionDisposable = Disposer.newDisposable();
        this.owner = owner;
        this.order = ArrayUtil.EMPTY_INT_ARRAY;
        this.rootBus = (RootBus)this;
        this.parentBus = null;
    }

    public final String toString() {
        return "MessageBus(owner=" + this.owner + ", disposeState= " + this.disposeState + ")";
    }

    @Override
    @NotNull
    public final MessageBusConnection connect() {
        return this.connect(this.connectionDisposable);
    }

    @Override
    @NotNull
    public final MessageBusConnectionImpl connect(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MessageBusImpl.$$$reportNull$$$0(3);
        }
        this.checkNotDisposed();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        this.subscribers.add(connection);
        Disposer.register(parentDisposable, connection);
        MessageBusConnectionImpl messageBusConnectionImpl = connection;
        if (messageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(4);
        }
        return messageBusConnectionImpl;
    }

    @Override
    @NotNull
    public final SimpleMessageBusConnection simpleConnect() {
        this.checkNotDisposed();
        SimpleMessageBusConnectionImpl connection = new SimpleMessageBusConnectionImpl(this);
        this.subscribers.add(connection);
        SimpleMessageBusConnectionImpl simpleMessageBusConnectionImpl = connection;
        if (simpleMessageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(5);
        }
        return simpleMessageBusConnectionImpl;
    }

    @Override
    @NotNull
    public final <L> L syncPublisher(@NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(6);
        }
        this.checkNotDisposed();
        Object object = this.publisherCache.computeIfAbsent(topic, this::createPublisherInvocationHandler);
        if (object == null) {
            MessageBusImpl.$$$reportNull$$$0(7);
        }
        return (L)object;
    }

    @NotNull
    private <L> L createPublisherInvocationHandler(@NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(8);
        }
        Class<L> listenerClass = topic.getListenerClass();
        Object object = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, this.createPublisher(topic, topic.getBroadcastDirection()));
        if (object == null) {
            MessageBusImpl.$$$reportNull$$$0(9);
        }
        return (L)object;
    }

    @NotNull
    protected <L> MessagePublisher<L> createPublisher(@NotNull Topic<L> topic, @NotNull Topic.BroadcastDirection direction) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(10);
        }
        if (direction == null) {
            MessageBusImpl.$$$reportNull$$$0(11);
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT) {
            return new ToParentMessagePublisher<L>(topic, this);
        }
        if (direction == Topic.BroadcastDirection.TO_DIRECT_CHILDREN) {
            throw new IllegalArgumentException("Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic broadcast direction to NONE or TO_PARENT");
        }
        LOG.warn("Broadcast direction TO_CHILDREN  is not allowed for module level message bus. Please change to NONE or TO_PARENT");
        return new MessagePublisher<L>(topic, this);
    }

    @Override
    public void dispose() {
        if (this.disposeState == 2) {
            LOG.error("Already disposed: " + this);
        }
        this.disposeState = 2;
        this.disposeChildren();
        if (this.connectionDisposable != null) {
            Disposer.dispose(this.connectionDisposable);
        }
        JobQueue jobs = this.messageQueue.get();
        this.messageQueue.remove();
        if (!jobs.queue.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        if (this.parentBus == null) {
            this.rootBus.myWaitingBuses.remove();
        } else {
            this.parentBus.onChildBusDisposed(this);
        }
    }

    protected void disposeChildren() {
    }

    public final boolean isDisposed() {
        return this.disposeState == 2 || this.owner.isDisposed();
    }

    private void checkNotDisposed() {
        if (this.isDisposed()) {
            LOG.error("Already disposed: " + this);
        }
    }

    protected <L> void doComputeSubscribers(@NotNull Topic<L> topic, @NotNull List<? super L> result2, boolean subscribeLazyListeners) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(13);
        }
        if (result2 == null) {
            MessageBusImpl.$$$reportNull$$$0(14);
        }
        for (MessageHandlerHolder subscriber : this.subscribers) {
            if (subscriber.isDisposed()) continue;
            subscriber.collectHandlers(topic, result2);
        }
    }

    @NotNull
    protected <L> List<L> computeSubscribers(@NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(15);
        }
        ArrayList result2 = new ArrayList();
        this.doComputeSubscribers(topic, result2, true);
        List list2 = result2.isEmpty() ? Collections.emptyList() : result2;
        if (list2 == null) {
            MessageBusImpl.$$$reportNull$$$0(16);
        }
        return list2;
    }

    private void jobRemoved(@NotNull JobQueue jobQueue) {
        if (jobQueue == null) {
            MessageBusImpl.$$$reportNull$$$0(17);
        }
        if (jobQueue.current == null && jobQueue.queue.isEmpty()) {
            this.rootBus.myWaitingBuses.get().remove(this);
        }
    }

    private static void pumpMessages(@NotNull Set<? extends MessageBusImpl> waitingBuses) {
        if (waitingBuses == null) {
            MessageBusImpl.$$$reportNull$$$0(18);
        }
        ArrayList<MessageBusImpl> liveBuses = new ArrayList<MessageBusImpl>(waitingBuses.size());
        for (MessageBusImpl messageBusImpl : waitingBuses) {
            if (messageBusImpl.isDisposed()) {
                waitingBuses.remove(messageBusImpl);
                LOG.error("Accessing disposed message bus " + messageBusImpl);
                continue;
            }
            liveBuses.add(messageBusImpl);
        }
        if (!liveBuses.isEmpty()) {
            MessageBusImpl.pumpWaitingBuses(liveBuses);
        }
    }

    private static void pumpWaitingBuses(@NotNull List<? extends MessageBusImpl> buses) {
        if (buses == null) {
            MessageBusImpl.$$$reportNull$$$0(19);
        }
        List<Throwable> exceptions = null;
        for (MessageBusImpl messageBusImpl : buses) {
            if (messageBusImpl.isDisposed()) continue;
            JobQueue jobQueue = messageBusImpl.messageQueue.get();
            Message<?> job = jobQueue.current;
            if (job != null) {
                exceptions = messageBusImpl.deliverMessage(job, jobQueue, messageBusImpl.messageDeliveryListener, exceptions);
            }
            while ((job = jobQueue.queue.pollFirst()) != null) {
                exceptions = messageBusImpl.deliverMessage(job, jobQueue, messageBusImpl.messageDeliveryListener, exceptions);
            }
        }
        if (exceptions != null) {
            EventDispatcher.throwExceptions(exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <L> List<Throwable> deliverMessage(@NotNull Message<L> job, @NotNull JobQueue jobQueue, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
        if (job == null) {
            MessageBusImpl.$$$reportNull$$$0(20);
        }
        if (jobQueue == null) {
            MessageBusImpl.$$$reportNull$$$0(21);
        }
        ClientId oldClientId = ClientId.getCurrentOrNull();
        try {
            ClientId.trySetCurrentClientId(job.clientId);
            jobQueue.current = job;
            List handlers2 = job.handlers;
            int index2 = job.currentHandlerIndex;
            int size = handlers2.size();
            int lastIndex = size - 1;
            while (index2 < size) {
                if (index2 == lastIndex) {
                    jobQueue.current = null;
                    this.jobRemoved(jobQueue);
                }
                ++job.currentHandlerIndex;
                exceptions = MessageBusImpl.invokeListener(job.listenerMethod, job.args, job.topic, handlers2.get(index2), messageDeliveryListener, exceptions);
                if (++index2 == job.currentHandlerIndex) continue;
                List<Throwable> list2 = exceptions;
                return list2;
            }
            List<Throwable> list3 = exceptions;
            return list3;
        }
        finally {
            ClientId.trySetCurrentClientId(oldClientId);
        }
    }

    protected boolean hasChildren() {
        return false;
    }

    final void notifyOnSubscription(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(22);
        }
        this.subscriberCache.remove(topic);
        if (topic.getBroadcastDirection() != Topic.BroadcastDirection.TO_CHILDREN) {
            return;
        }
        MessageBusImpl parentBus = this;
        while ((parentBus = parentBus.parentBus) != null) {
            parentBus.subscriberCache.remove(topic);
        }
        if (this.hasChildren()) {
            this.notifyOnSubscriptionToTopicToChildren(topic);
        }
    }

    protected void notifyOnSubscriptionToTopicToChildren(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(23);
        }
    }

    protected void removeEmptyConnectionsRecursively() {
        this.subscribers.removeIf(MessageHandlerHolder::isDisposed);
    }

    boolean notifyConnectionTerminated(Object @NotNull [] topicAndHandlerPairs) {
        if (topicAndHandlerPairs == null) {
            MessageBusImpl.$$$reportNull$$$0(25);
        }
        if (this.disposeState != 0) {
            return false;
        }
        this.rootBus.scheduleEmptyConnectionRemoving();
        return MessageBusImpl.clearSubscriberCacheOnConnectionTerminated(topicAndHandlerPairs, this);
    }

    private static boolean clearSubscriberCacheOnConnectionTerminated(Object @NotNull [] topicAndHandlerPairs, @NotNull MessageBusImpl bus) {
        if (bus == null) {
            MessageBusImpl.$$$reportNull$$$0(26);
        }
        if (topicAndHandlerPairs == null) {
            MessageBusImpl.$$$reportNull$$$0(27);
        }
        boolean isChildClearingNeeded = false;
        for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
            Topic.BroadcastDirection direction;
            Topic topic = (Topic)topicAndHandlerPairs[i];
            if (bus.subscriberCache.remove(topic) != null) {
                bus.removeDisposedHandlers(topic, topicAndHandlerPairs[i + 1]);
            }
            if ((direction = topic.getBroadcastDirection()) != Topic.BroadcastDirection.TO_CHILDREN) continue;
            MessageBusImpl parentBus = bus;
            while ((parentBus = parentBus.parentBus) != null) {
                if (parentBus.subscriberCache.remove(topic) == null) continue;
                parentBus.removeDisposedHandlers(topic, topicAndHandlerPairs[i + 1]);
            }
            if (!bus.hasChildren()) continue;
            isChildClearingNeeded = true;
        }
        return isChildClearingNeeded;
    }

    protected void clearSubscriberCache(Object @NotNull [] topicAndHandlerPairs) {
        if (topicAndHandlerPairs == null) {
            MessageBusImpl.$$$reportNull$$$0(28);
        }
        for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
            this.subscriberCache.remove(topicAndHandlerPairs[i]);
        }
    }

    final void deliverImmediately(@NotNull MessageBusConnectionImpl connection) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(29);
        }
        if (this.disposeState == 2) {
            LOG.error("Already disposed: " + this);
        }
        if (this.owner.isDisposed()) {
            return;
        }
        JobQueue jobQueue = this.messageQueue.get();
        Deque jobs = jobQueue.queue;
        if (jobs.isEmpty()) {
            return;
        }
        List newJobs = MessageBusImpl.deliverImmediately(connection, jobs);
        if (newJobs == null) {
            return;
        }
        for (int i = newJobs.size() - 1; i >= 0; --i) {
            jobs.addFirst(newJobs.get(i));
        }
        List<Throwable> exceptions = null;
        for (Message job : newJobs) {
            jobs.removeFirstOccurrence(job);
            exceptions = this.deliverMessage(job, jobQueue, this.messageDeliveryListener, exceptions);
        }
        if (exceptions != null) {
            EventDispatcher.throwExceptions(exceptions);
        }
    }

    @Nullable
    private static <L> List<Message<L>> deliverImmediately(@NotNull MessageBusConnectionImpl connection, @NotNull Deque<Message<L>> jobs) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(30);
        }
        if (jobs == null) {
            MessageBusImpl.$$$reportNull$$$0(31);
        }
        SmartList<Message<L>> newJobs = null;
        Iterator<Message<L>> jobIterator = jobs.iterator();
        while (jobIterator.hasNext()) {
            Message<L> filteredJob;
            Message<L> job = jobIterator.next();
            SmartList connectionHandlers = null;
            Iterator handlerIterator = job.handlers.iterator();
            while (handlerIterator.hasNext()) {
                Object handler2 = handlerIterator.next();
                if (!connection.isMyHandler(job.topic, handler2)) continue;
                handlerIterator.remove();
                if (connectionHandlers == null) {
                    connectionHandlers = new SmartList();
                }
                connectionHandlers.add(handler2);
            }
            if (connectionHandlers == null) continue;
            if (job.handlers.isEmpty()) {
                jobIterator.remove();
                filteredJob = job;
                job.handlers.addAll(connectionHandlers);
            } else {
                filteredJob = new Message(job.topic, job.listenerMethod, job.args, connectionHandlers);
            }
            if (newJobs == null) {
                newJobs = new SmartList<Message<L>>();
            }
            newJobs.add(filteredJob);
        }
        return newJobs;
    }

    @Nullable
    private static <L> List<Throwable> invokeListener(@NotNull Method method, Object[] args, @NotNull Topic<L> topic, @NotNull L handler2, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
        if (method == null) {
            MessageBusImpl.$$$reportNull$$$0(32);
        }
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(33);
        }
        if (handler2 == null) {
            MessageBusImpl.$$$reportNull$$$0(34);
        }
        try {
            if (handler2 instanceof MessageHandler) {
                ((MessageHandler)handler2).handle(method, args);
            } else if (messageDeliveryListener == null) {
                method.invoke(handler2, args);
            } else {
                long startTime = System.nanoTime();
                method.invoke(handler2, args);
                messageDeliveryListener.messageDelivered(topic, method.getName(), handler2, System.nanoTime() - startTime);
            }
        }
        catch (Throwable e) {
            exceptions = EventDispatcher.handleException(e, exceptions);
        }
        return exceptions;
    }

    private void removeDisposedHandlers(@NotNull Topic<?> topic, @NotNull Object handler2) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(36);
        }
        if (handler2 == null) {
            MessageBusImpl.$$$reportNull$$$0(37);
        }
        JobQueue jobQueue = this.messageQueue.get();
        if (!jobQueue.queue.isEmpty() && jobQueue.queue.removeIf(job -> job.topic == topic && job.handlers.removeIf(it -> it == handler2) && job.handlers.isEmpty())) {
            this.jobRemoved(jobQueue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 22: 
            case 23: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jobQueue";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "waitingBuses";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buses";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 25: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topicAndHandlerPairs";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jobs";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "connect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "simpleConnect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "syncPublisher";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPublisherInvocationHandler";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSubscribers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "syncPublisher";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPublisherInvocationHandler";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPublisher";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasUndeliveredEvents";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doComputeSubscribers";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeSubscribers";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "jobRemoved";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "pumpMessages";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "pumpWaitingBuses";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "deliverMessage";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscription";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscriptionToTopicToChildren";
                break;
            }
            case 24: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "clearSubscriberCache";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "notifyConnectionTerminated";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "clearSubscriberCacheOnConnectionTerminated";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "deliverImmediately";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "invokeListener";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "disconnectPluginConnections";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeDisposedHandlers";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RootBus
    extends CompositeMessageBus {
        private final AtomicReference<CompletableFuture<?>> compactionFutureRef;
        private final AtomicInteger emptyConnectionCounter;
        final ThreadLocal<Set<MessageBusImpl>> myWaitingBuses;

        RootBus(@NotNull MessageBusOwner owner) {
            if (owner == null) {
                RootBus.$$$reportNull$$$0(0);
            }
            super(owner);
            this.compactionFutureRef = new AtomicReference();
            this.emptyConnectionCounter = new AtomicInteger();
            this.myWaitingBuses = ThreadLocal.withInitial(() -> new TreeSet((bus1, bus2) -> ArrayUtil.lexicographicCompare(bus1.order, bus2.order)));
        }

        void scheduleEmptyConnectionRemoving() {
            CompletableFuture<Void> future;
            int counter = this.emptyConnectionCounter.incrementAndGet();
            if (counter < 128 || !this.emptyConnectionCounter.compareAndSet(counter, 0)) {
                return;
            }
            CompletableFuture<?> oldFuture = this.compactionFutureRef.get();
            if (oldFuture == null && !this.compactionFutureRef.compareAndSet(null, future = CompletableFuture.runAsync(() -> {
                this.removeEmptyConnectionsRecursively();
                this.compactionFutureRef.set(null);
            }, AppExecutorUtil.getAppExecutorService()))) {
                future.cancel(false);
            }
        }

        @Override
        public void dispose() {
            CompletableFuture compactionFuture = this.compactionFutureRef.getAndSet(null);
            if (compactionFuture != null) {
                compactionFuture.cancel(false);
            }
            super.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/messages/impl/MessageBusImpl$RootBus", "<init>"));
        }
    }

    protected static final class ToParentMessagePublisher<L>
    extends MessagePublisher<L>
    implements InvocationHandler {
        ToParentMessagePublisher(@NotNull Topic<L> topic, @NotNull MessageBusImpl bus) {
            if (topic == null) {
                ToParentMessagePublisher.$$$reportNull$$$0(0);
            }
            if (bus == null) {
                ToParentMessagePublisher.$$$reportNull$$$0(1);
            }
            super(topic, bus);
        }

        @Override
        protected boolean publish(@NotNull Method method, Object[] args, @Nullable JobQueue jobQueue) {
            if (method == null) {
                ToParentMessagePublisher.$$$reportNull$$$0(2);
            }
            List<Throwable> exceptions = null;
            MessageBusImpl parentBus = this.bus;
            boolean hasHandlers = false;
            do {
                List<?> existing;
                List<Object> handlers2;
                if ((handlers2 = parentBus.subscriberCache.get(this.topic)) == null && (existing = parentBus.subscriberCache.putIfAbsent(this.topic, handlers2 = parentBus.computeSubscribers(this.topic))) != null) {
                    handlers2 = existing;
                }
                if (handlers2.isEmpty()) continue;
                hasHandlers = true;
                exceptions = this.executeOrAddToQueue(this.topic, method, args, handlers2, jobQueue, this.bus.messageDeliveryListener, exceptions);
            } while ((parentBus = parentBus.parentBus) != null);
            if (exceptions != null) {
                EventDispatcher.throwExceptions(exceptions);
            }
            return hasHandlers;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topic";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bus";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/messages/impl/MessageBusImpl$ToParentMessagePublisher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "publish";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class MessagePublisher<L>
    implements InvocationHandler {
        @NotNull
        protected final Topic<L> topic;
        @NotNull
        protected final MessageBusImpl bus;

        MessagePublisher(@NotNull Topic<L> topic, @NotNull MessageBusImpl bus) {
            if (topic == null) {
                MessagePublisher.$$$reportNull$$$0(0);
            }
            if (bus == null) {
                MessagePublisher.$$$reportNull$$$0(1);
            }
            this.topic = topic;
            this.bus = bus;
        }

        @Override
        public final Object invoke(Object proxy, Method method, Object[] args) {
            JobQueue jobQueue;
            Set<MessageBusImpl> busQueue;
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                return EventDispatcher.handleObjectMethod(proxy, args, method.getName());
            }
            this.bus.checkNotDisposed();
            boolean isImmediateDelivery = this.topic.isImmediateDelivery();
            if (isImmediateDelivery) {
                busQueue = null;
                jobQueue = null;
            } else {
                busQueue = this.bus.rootBus.myWaitingBuses.get();
                jobQueue = this.bus.messageQueue.get();
                MessageBusImpl.pumpMessages(busQueue);
            }
            if (this.publish(method, args, jobQueue) && !isImmediateDelivery) {
                busQueue.add(this.bus);
                MessageBusImpl.pumpMessages(busQueue);
            }
            return NA;
        }

        protected boolean publish(@NotNull Method method, Object[] args, @Nullable JobQueue jobQueue) {
            List handlers2;
            if (method == null) {
                MessagePublisher.$$$reportNull$$$0(2);
            }
            if ((handlers2 = this.bus.subscriberCache.computeIfAbsent(this.topic, topic1 -> this.bus.computeSubscribers(topic1))).isEmpty()) {
                return false;
            }
            List<Throwable> exceptions = this.executeOrAddToQueue(this.topic, method, args, handlers2, jobQueue, this.bus.messageDeliveryListener, null);
            if (exceptions != null) {
                EventDispatcher.throwExceptions(exceptions);
            }
            return true;
        }

        protected List<Throwable> executeOrAddToQueue(@NotNull Topic<L> topic, @NotNull Method method, Object[] args, @NotNull List<L> handlers2, @Nullable JobQueue jobQueue, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
            if (topic == null) {
                MessagePublisher.$$$reportNull$$$0(3);
            }
            if (method == null) {
                MessagePublisher.$$$reportNull$$$0(4);
            }
            if (handlers2 == null) {
                MessagePublisher.$$$reportNull$$$0(5);
            }
            if (jobQueue == null) {
                for (L handler2 : handlers2) {
                    exceptions = MessageBusImpl.invokeListener(method, args, topic, handler2, messageDeliveryListener, exceptions);
                }
            } else {
                Message<L> message = new Message<L>(topic, method, args, handlers2);
                jobQueue.queue.offerLast(message);
            }
            return exceptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topic";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bus";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handlers";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/messages/impl/MessageBusImpl$MessagePublisher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "publish";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeOrAddToQueue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface MessageHandlerHolder {
        public <L> void collectHandlers(@NotNull Topic<L> var1, @NotNull List<? super L> var2);

        public boolean isDisposed();
    }
}

