/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.profiling;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.profiling.AsyncProfilerHelper;
import org.jetbrains.kotlin.cli.common.profiling.AsyncProfilerReflected;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/cli/common/profiling/ProfilingCompilerPerformanceManager;", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "profilerPath", "", "command", "outputDir", "Ljava/io/File;", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;)V", "active", "", "getCommand", "()Ljava/lang/String;", "formatter", "Ljava/text/SimpleDateFormat;", "getOutputDir", "()Ljava/io/File;", "profiler", "Lorg/jetbrains/kotlin/cli/common/profiling/AsyncProfilerReflected;", "runDate", "Ljava/util/Date;", "dumpProfile", "", "postfix", "notifyCompilationFinished", "notifyRepeat", "total", "", "number", "restartProfiling", "startProfiling", "stopProfiling", "Companion", "cli"})
public final class ProfilingCompilerPerformanceManager
extends CommonCompilerPerformanceManager {
    private final AsyncProfilerReflected profiler;
    private final Date runDate;
    private final SimpleDateFormat formatter;
    private boolean active;
    @NotNull
    private final String command;
    @NotNull
    private final File outputDir;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void startProfiling() {
        this.profiler.execute(this.command);
        this.active = true;
    }

    private final void stopProfiling() {
        if (this.active) {
            this.profiler.stop();
        }
        this.active = false;
    }

    private final void restartProfiling() {
        this.stopProfiling();
        this.startProfiling();
    }

    private final void dumpProfile(String postfix) {
        this.outputDir.mkdirs();
        File outputFile = FilesKt.resolve((File)this.outputDir, (String)("snapshot-" + this.formatter.format(this.runDate) + '-' + postfix + ".collapsed"));
        FilesKt.writeText$default((File)outputFile, (String)this.profiler.execute("collapsed"), null, (int)2, null);
        this.active = false;
    }

    @Override
    public void notifyRepeat(int total, int number2) {
        this.dumpProfile("repeat" + number2);
        this.restartProfiling();
    }

    @Override
    public void notifyCompilationFinished() {
        this.dumpProfile("final");
        this.stopProfiling();
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    @NotNull
    public final File getOutputDir() {
        return this.outputDir;
    }

    public ProfilingCompilerPerformanceManager(@NotNull String profilerPath, @NotNull String command, @NotNull File outputDir2) {
        Intrinsics.checkNotNullParameter((Object)profilerPath, (String)"profilerPath");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)outputDir2, (String)"outputDir");
        super("Profiling");
        this.command = command;
        this.outputDir = outputDir2;
        this.profiler = AsyncProfilerHelper.INSTANCE.getInstance(profilerPath);
        this.runDate = new Date();
        this.formatter = new SimpleDateFormat("yyyy-MM-dd__HH-mm");
        this.startProfiling();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/cli/common/profiling/ProfilingCompilerPerformanceManager$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/cli/common/profiling/ProfilingCompilerPerformanceManager;", "profileCompilerArgument", "", "cli"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ProfilingCompilerPerformanceManager create(@NotNull String profileCompilerArgument) {
            void command;
            void path2;
            List list2;
            Intrinsics.checkNotNullParameter((Object)profileCompilerArgument, (String)"profileCompilerArgument");
            List list3 = list2 = StringsKt.split$default((CharSequence)profileCompilerArgument, (String[])new String[]{":"}, (boolean)false, (int)3, (int)2, null);
            String string2 = (String)list3.get(0);
            list3 = list2;
            String string3 = (String)list3.get(1);
            list3 = list2;
            String outputDir2 = (String)list3.get(2);
            return new ProfilingCompilerPerformanceManager((String)path2, (String)command, new File(outputDir2));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

