/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.stats;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0002R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/utils/stats/Buckets;", "", "thresholds", "", "", "(Ljava/util/List;)V", "snapshot", "Lorg/jitsi/utils/stats/Buckets$Snapshot;", "getSnapshot", "()Lorg/jitsi/utils/stats/Buckets$Snapshot;", "thresholdCounts", "", "Ljava/util/concurrent/atomic/LongAdder;", "[Ljava/util/concurrent/atomic/LongAdder;", "addValue", "", "value", "", "findBucket", "", "Snapshot", "jitsi-utils"})
public final class Buckets {
    @NotNull
    private final List<Long> thresholds;
    @NotNull
    private final LongAdder[] thresholdCounts;

    public Buckets(@NotNull List<Long> thresholds) {
        Intrinsics.checkNotNullParameter(thresholds, (String)"thresholds");
        this.thresholds = thresholds;
        int n = 0;
        int n2 = this.thresholds.size() - 1;
        LongAdder[] longAdderArray = new LongAdder[n2];
        Buckets buckets = this;
        while (n < n2) {
            int n3 = n++;
            longAdderArray[n3] = new LongAdder();
        }
        buckets.thresholdCounts = longAdderArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Snapshot getSnapshot() {
        int n;
        int n2 = 0;
        int n3 = this.thresholdCounts.length;
        Pair[] pairArray = new Pair[n3];
        while (n2 < n3) {
            int n4 = n2++;
            pairArray[n4] = new Pair((Object)new Pair((Object)this.thresholds.get(n4), (Object)this.thresholds.get(n4 + 1)), (Object)this.thresholdCounts[n4].sum());
        }
        Pair[] bucketCounts = pairArray;
        long p99 = 0L;
        p99 = Long.MAX_VALUE;
        long p999 = 0L;
        p999 = Long.MAX_VALUE;
        long sum = 0L;
        Pair[] pairArray2 = bucketCounts;
        long l = 0L;
        int n5 = pairArray2.length;
        for (n = 0; n < n5; ++n) {
            void it;
            Pair pair;
            Pair pair2 = pair = pairArray2[n];
            long l2 = l;
            boolean bl = false;
            long l3 = ((Number)it.getSecond()).longValue();
            l = l2 + l3;
        }
        long totalCount = l;
        Pair[] $this$forEach$iv = bucketCounts;
        boolean $i$f$forEach = false;
        n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Pair element$iv;
            Pair it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            sum += ((Number)it.getSecond()).longValue();
            if (((Number)((Pair)it.getFirst()).getSecond()).longValue() < p99 && (double)sum > 0.99 * (double)totalCount) {
                p99 = ((Number)((Pair)it.getFirst()).getSecond()).longValue();
            }
            if (((Number)((Pair)it.getFirst()).getSecond()).longValue() >= p999 || !((double)sum > 0.999 * (double)totalCount)) continue;
            p999 = ((Number)((Pair)it.getFirst()).getSecond()).longValue();
        }
        if (totalCount < 100L || p99 == Long.MAX_VALUE) {
            p99 = -1L;
        }
        if (totalCount < 1000L || p999 == Long.MAX_VALUE) {
            p999 = -1L;
        }
        return new Snapshot(bucketCounts, p99, p999);
    }

    private final LongAdder findBucket(double value) {
        int n = this.thresholdCounts.length;
        for (int i = 0; i < n; ++i) {
            if (!(value < (double)((Number)this.thresholds.get(i + 1)).longValue())) continue;
            return this.thresholdCounts[i];
        }
        return (LongAdder)ArraysKt.last((Object[])this.thresholdCounts);
    }

    public final boolean addValue(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        double v = value.doubleValue();
        if (v < (double)((Number)CollectionsKt.first(this.thresholds)).longValue() || v > (double)((Number)CollectionsKt.last(this.thresholds)).longValue()) {
            return false;
        }
        this.findBucket(v).increment();
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012$\u0010\u0002\u001a \u0012\u001c\u0012\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ,\u0010\u000f\u001a \u0012\u001c\u0012\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00050\u00040\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003JJ\u0010\u0012\u001a\u00020\u00002&\b\u0002\u0010\u0002\u001a \u0012\u001c\u0012\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00050\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R1\u0010\u0002\u001a \u0012\u001c\u0012\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/jitsi/utils/stats/Buckets$Snapshot;", "", "buckets", "", "Lkotlin/Pair;", "", "p99bound", "p999bound", "([Lkotlin/Pair;JJ)V", "getBuckets", "()[Lkotlin/Pair;", "[Lkotlin/Pair;", "getP999bound", "()J", "getP99bound", "component1", "component2", "component3", "copy", "([Lkotlin/Pair;JJ)Lorg/jitsi/utils/stats/Buckets$Snapshot;", "equals", "", "other", "hashCode", "", "toString", "", "jitsi-utils"})
    public static final class Snapshot {
        @NotNull
        private final Pair<Pair<Long, Long>, Long>[] buckets;
        private final long p99bound;
        private final long p999bound;

        public Snapshot(@NotNull Pair<Pair<Long, Long>, Long>[] buckets, long p99bound, long p999bound) {
            Intrinsics.checkNotNullParameter(buckets, (String)"buckets");
            this.buckets = buckets;
            this.p99bound = p99bound;
            this.p999bound = p999bound;
        }

        @NotNull
        public final Pair<Pair<Long, Long>, Long>[] getBuckets() {
            return this.buckets;
        }

        public final long getP99bound() {
            return this.p99bound;
        }

        public final long getP999bound() {
            return this.p999bound;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Object object2 = other;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jitsi.utils.stats.Buckets.Snapshot");
            }
            Snapshot cfr_ignored_0 = (Snapshot)object2;
            return Arrays.equals(this.buckets, ((Snapshot)other).buckets);
        }

        public int hashCode() {
            return Arrays.hashCode(this.buckets);
        }

        @NotNull
        public final Pair<Pair<Long, Long>, Long>[] component1() {
            return this.buckets;
        }

        public final long component2() {
            return this.p99bound;
        }

        public final long component3() {
            return this.p999bound;
        }

        @NotNull
        public final Snapshot copy(@NotNull Pair<Pair<Long, Long>, Long>[] buckets, long p99bound, long p999bound) {
            Intrinsics.checkNotNullParameter(buckets, (String)"buckets");
            return new Snapshot(buckets, p99bound, p999bound);
        }

        public static /* synthetic */ Snapshot copy$default(Snapshot snapshot, Pair[] pairArray, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                pairArray = snapshot.buckets;
            }
            if ((n & 2) != 0) {
                l = snapshot.p99bound;
            }
            if ((n & 4) != 0) {
                l2 = snapshot.p999bound;
            }
            return snapshot.copy(pairArray, l, l2);
        }

        @NotNull
        public String toString() {
            return "Snapshot(buckets=" + Arrays.toString(this.buckets) + ", p99bound=" + this.p99bound + ", p999bound=" + this.p999bound + ")";
        }
    }
}

