/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.enforcer.RequireJavaVersion;
import org.apache.maven.plugins.enforcer.RequireOS;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Mojo(name="display-info", threadSafe=true)
public class DisplayInfoMojo
extends AbstractMojo
implements Contextualizable {
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    protected MojoExecution mojoExecution;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    protected PlexusContainer container;

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public void execute() throws MojoExecutionException {
        String mavenVersion = this.session.getSystemProperties().getProperty("maven.version");
        String javaVersion = System.getProperty("java.version");
        this.getLog().info((CharSequence)("Maven Version: " + mavenVersion));
        this.getLog().info((CharSequence)("JDK Version: " + javaVersion + " normalized as: " + RequireJavaVersion.normalizeJDKVersion((String)javaVersion)));
        RequireOS os = new RequireOS();
        os.displayOSInfo(this.getLog(), true);
    }
}

