/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.model.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.FileItem;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.model.GroupVersionAlignment;
import org.apache.maven.plugin.assembly.model.ModuleBinaries;
import org.apache.maven.plugin.assembly.model.ModuleSet;
import org.apache.maven.plugin.assembly.model.ModuleSources;
import org.apache.maven.plugin.assembly.model.Repository;
import org.apache.maven.plugin.assembly.model.SetBase;
import org.apache.maven.plugin.assembly.model.UnpackOptions;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class AssemblyXpp3Reader {
    private boolean addDefaultEntities = true;

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (parsed.contains(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        parsed.add(tagName);
        return true;
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, null);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage());
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, null);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, null);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, null);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, null);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, null);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private Assembly parseAssembly(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Assembly assembly = new Assembly();
        HashSet parsed = new HashSet();
        int eventType = parser.getEventType();
        boolean foundRoot = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (parser.getName().equals(tagName)) {
                    foundRoot = true;
                } else {
                    if (strict && !foundRoot) {
                        throw new XmlPullParserException("Expected root element '" + tagName + "' but found '" + parser.getName() + "'", parser, null);
                    }
                    if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                        assembly.setId(this.getTrimmedValue(parser.nextText()));
                    } else if (this.checkFieldWithDuplicate(parser, "formats", null, parsed)) {
                        ArrayList<String> formats = new ArrayList<String>();
                        assembly.setFormats(formats);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("format")) {
                                formats.add(this.getTrimmedValue(parser.nextText()));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (this.checkFieldWithDuplicate(parser, "includeBaseDirectory", null, parsed)) {
                        assembly.setIncludeBaseDirectory(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "includeBaseDirectory", parser, "true"));
                    } else if (this.checkFieldWithDuplicate(parser, "baseDirectory", null, parsed)) {
                        assembly.setBaseDirectory(this.getTrimmedValue(parser.nextText()));
                    } else if (this.checkFieldWithDuplicate(parser, "includeSiteDirectory", null, parsed)) {
                        assembly.setIncludeSiteDirectory(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "includeSiteDirectory", parser, "false"));
                    } else if (this.checkFieldWithDuplicate(parser, "containerDescriptorHandlers", null, parsed)) {
                        ArrayList<ContainerDescriptorHandlerConfig> containerDescriptorHandlers = new ArrayList<ContainerDescriptorHandlerConfig>();
                        assembly.setContainerDescriptorHandlers(containerDescriptorHandlers);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("containerDescriptorHandler")) {
                                containerDescriptorHandlers.add(this.parseContainerDescriptorHandlerConfig("containerDescriptorHandler", parser, strict));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (this.checkFieldWithDuplicate(parser, "moduleSets", null, parsed)) {
                        ArrayList<ModuleSet> moduleSets = new ArrayList<ModuleSet>();
                        assembly.setModuleSets(moduleSets);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("moduleSet")) {
                                moduleSets.add(this.parseModuleSet("moduleSet", parser, strict));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (this.checkFieldWithDuplicate(parser, "fileSets", null, parsed)) {
                        ArrayList<FileSet> fileSets = new ArrayList<FileSet>();
                        assembly.setFileSets(fileSets);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("fileSet")) {
                                fileSets.add(this.parseFileSet("fileSet", parser, strict));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (this.checkFieldWithDuplicate(parser, "files", null, parsed)) {
                        ArrayList<FileItem> files = new ArrayList<FileItem>();
                        assembly.setFiles(files);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("file")) {
                                files.add(this.parseFileItem("file", parser, strict));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (this.checkFieldWithDuplicate(parser, "dependencySets", null, parsed)) {
                        ArrayList<DependencySet> dependencySets = new ArrayList<DependencySet>();
                        assembly.setDependencySets(dependencySets);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("dependencySet")) {
                                dependencySets.add(this.parseDependencySet("dependencySet", parser, strict));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (this.checkFieldWithDuplicate(parser, "repositories", null, parsed)) {
                        ArrayList<Repository> repositories = new ArrayList<Repository>();
                        assembly.setRepositories(repositories);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("repository")) {
                                repositories.add(this.parseRepository("repository", parser, strict));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (this.checkFieldWithDuplicate(parser, "componentDescriptors", null, parsed)) {
                        ArrayList<String> componentDescriptors = new ArrayList<String>();
                        assembly.setComponentDescriptors(componentDescriptors);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("componentDescriptor")) {
                                componentDescriptors.add(this.getTrimmedValue(parser.nextText()));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (strict) {
                        throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
                    }
                }
            }
            eventType = parser.next();
        }
        return assembly;
    }

    private ContainerDescriptorHandlerConfig parseContainerDescriptorHandlerConfig(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig = new ContainerDescriptorHandlerConfig();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "handlerName", null, parsed)) {
                containerDescriptorHandlerConfig.setHandlerName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                containerDescriptorHandlerConfig.setConfiguration(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return containerDescriptorHandlerConfig;
    }

    private DependencySet parseDependencySet(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        DependencySet dependencySet = new DependencySet();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "outputFileNameMapping", null, parsed)) {
                dependencySet.setOutputFileNameMapping(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "unpack", null, parsed)) {
                dependencySet.setUnpack(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "unpack", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "unpackOptions", null, parsed)) {
                dependencySet.setUnpackOptions(this.parseUnpackOptions("unpackOptions", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scope", null, parsed)) {
                dependencySet.setScope(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useProjectArtifact", null, parsed)) {
                dependencySet.setUseProjectArtifact(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useProjectArtifact", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useProjectAttachments", null, parsed)) {
                dependencySet.setUseProjectAttachments(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useProjectAttachments", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useTransitiveDependencies", null, parsed)) {
                dependencySet.setUseTransitiveDependencies(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useTransitiveDependencies", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useTransitiveFiltering", null, parsed)) {
                dependencySet.setUseTransitiveFiltering(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useTransitiveFiltering", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useStrictFiltering", null, parsed)) {
                dependencySet.setUseStrictFiltering(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useStrictFiltering", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useDefaultExcludes", null, parsed)) {
                dependencySet.setUseDefaultExcludes(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useDefaultExcludes", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                dependencySet.setOutputDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                dependencySet.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                dependencySet.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileMode", null, parsed)) {
                dependencySet.setFileMode(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directoryMode", null, parsed)) {
                dependencySet.setDirectoryMode(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return dependencySet;
    }

    private FileItem parseFileItem(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        FileItem fileItem = new FileItem();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "source", null, parsed)) {
                fileItem.setSource(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                fileItem.setOutputDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "destName", null, parsed)) {
                fileItem.setDestName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileMode", null, parsed)) {
                fileItem.setFileMode(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "lineEnding", null, parsed)) {
                fileItem.setLineEnding(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "filtered", null, parsed)) {
                fileItem.setFiltered(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "filtered", parser, "false"));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return fileItem;
    }

    private FileSet parseFileSet(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        FileSet fileSet = new FileSet();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "directory", null, parsed)) {
                fileSet.setDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "lineEnding", null, parsed)) {
                fileSet.setLineEnding(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "filtered", null, parsed)) {
                fileSet.setFiltered(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "filtered", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useStrictFiltering", null, parsed)) {
                fileSet.setUseStrictFiltering(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useStrictFiltering", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useDefaultExcludes", null, parsed)) {
                fileSet.setUseDefaultExcludes(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useDefaultExcludes", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                fileSet.setOutputDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                fileSet.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                fileSet.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileMode", null, parsed)) {
                fileSet.setFileMode(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directoryMode", null, parsed)) {
                fileSet.setDirectoryMode(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return fileSet;
    }

    private GroupVersionAlignment parseGroupVersionAlignment(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        GroupVersionAlignment groupVersionAlignment = new GroupVersionAlignment();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                groupVersionAlignment.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                groupVersionAlignment.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                groupVersionAlignment.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return groupVersionAlignment;
    }

    private ModuleBinaries parseModuleBinaries(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ModuleBinaries moduleBinaries = new ModuleBinaries();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "attachmentClassifier", null, parsed)) {
                moduleBinaries.setAttachmentClassifier(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includeDependencies", null, parsed)) {
                moduleBinaries.setIncludeDependencies(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "includeDependencies", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencySets", null, parsed)) {
                ArrayList<DependencySet> dependencySets = new ArrayList<DependencySet>();
                moduleBinaries.setDependencySets(dependencySets);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("dependencySet")) {
                        dependencySets.add(this.parseDependencySet("dependencySet", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "unpack", null, parsed)) {
                moduleBinaries.setUnpack(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "unpack", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "unpackOptions", null, parsed)) {
                moduleBinaries.setUnpackOptions(this.parseUnpackOptions("unpackOptions", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputFileNameMapping", null, parsed)) {
                moduleBinaries.setOutputFileNameMapping(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useStrictFiltering", null, parsed)) {
                moduleBinaries.setUseStrictFiltering(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useStrictFiltering", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useDefaultExcludes", null, parsed)) {
                moduleBinaries.setUseDefaultExcludes(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useDefaultExcludes", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                moduleBinaries.setOutputDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                moduleBinaries.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                moduleBinaries.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileMode", null, parsed)) {
                moduleBinaries.setFileMode(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directoryMode", null, parsed)) {
                moduleBinaries.setDirectoryMode(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return moduleBinaries;
    }

    private ModuleSet parseModuleSet(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ModuleSet moduleSet = new ModuleSet();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "includeSubModules", null, parsed)) {
                moduleSet.setIncludeSubModules(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "includeSubModules", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                moduleSet.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                moduleSet.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "sources", null, parsed)) {
                moduleSet.setSources(this.parseModuleSources("sources", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "binaries", null, parsed)) {
                moduleSet.setBinaries(this.parseModuleBinaries("binaries", parser, strict));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return moduleSet;
    }

    private ModuleSources parseModuleSources(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ModuleSources moduleSources = new ModuleSources();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "fileSets", null, parsed)) {
                ArrayList<FileSet> fileSets = new ArrayList<FileSet>();
                moduleSources.setFileSets(fileSets);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("fileSet")) {
                        fileSets.add(this.parseFileSet("fileSet", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includeModuleDirectory", null, parsed)) {
                moduleSources.setIncludeModuleDirectory(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "includeModuleDirectory", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludeSubModuleDirectories", null, parsed)) {
                moduleSources.setExcludeSubModuleDirectories(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "excludeSubModuleDirectories", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectoryMapping", null, parsed)) {
                moduleSources.setOutputDirectoryMapping(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useStrictFiltering", null, parsed)) {
                moduleSources.setUseStrictFiltering(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useStrictFiltering", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useDefaultExcludes", null, parsed)) {
                moduleSources.setUseDefaultExcludes(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useDefaultExcludes", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                moduleSources.setOutputDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                moduleSources.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                moduleSources.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileMode", null, parsed)) {
                moduleSources.setFileMode(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directoryMode", null, parsed)) {
                moduleSources.setDirectoryMode(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return moduleSources;
    }

    private Repository parseRepository(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Repository repository = new Repository();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "includeMetadata", null, parsed)) {
                repository.setIncludeMetadata(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "includeMetadata", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "groupVersionAlignments", null, parsed)) {
                ArrayList<GroupVersionAlignment> groupVersionAlignments = new ArrayList<GroupVersionAlignment>();
                repository.setGroupVersionAlignments(groupVersionAlignments);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("groupVersionAlignment")) {
                        groupVersionAlignments.add(this.parseGroupVersionAlignment("groupVersionAlignment", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scope", null, parsed)) {
                repository.setScope(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useStrictFiltering", null, parsed)) {
                repository.setUseStrictFiltering(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useStrictFiltering", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useDefaultExcludes", null, parsed)) {
                repository.setUseDefaultExcludes(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useDefaultExcludes", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                repository.setOutputDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                repository.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                repository.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileMode", null, parsed)) {
                repository.setFileMode(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directoryMode", null, parsed)) {
                repository.setDirectoryMode(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return repository;
    }

    private SetBase parseSetBase(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        SetBase setBase = new SetBase();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "useStrictFiltering", null, parsed)) {
                setBase.setUseStrictFiltering(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useStrictFiltering", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useDefaultExcludes", null, parsed)) {
                setBase.setUseDefaultExcludes(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useDefaultExcludes", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                setBase.setOutputDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                setBase.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                setBase.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileMode", null, parsed)) {
                setBase.setFileMode(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directoryMode", null, parsed)) {
                setBase.setDirectoryMode(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return setBase;
    }

    private UnpackOptions parseUnpackOptions(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        UnpackOptions unpackOptions = new UnpackOptions();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                unpackOptions.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                unpackOptions.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "filtered", null, parsed)) {
                unpackOptions.setFiltered(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "filtered", parser, "false"));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return unpackOptions;
    }

    public Assembly read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = new MXParser();
        parser.setInput(reader);
        if (this.addDefaultEntities) {
            parser.defineEntityReplacementText("nbsp", "\u00a0");
            parser.defineEntityReplacementText("iexcl", "\u00a1");
            parser.defineEntityReplacementText("cent", "\u00a2");
            parser.defineEntityReplacementText("pound", "\u00a3");
            parser.defineEntityReplacementText("curren", "\u00a4");
            parser.defineEntityReplacementText("yen", "\u00a5");
            parser.defineEntityReplacementText("brvbar", "\u00a6");
            parser.defineEntityReplacementText("sect", "\u00a7");
            parser.defineEntityReplacementText("uml", "\u00a8");
            parser.defineEntityReplacementText("copy", "\u00a9");
            parser.defineEntityReplacementText("ordf", "\u00aa");
            parser.defineEntityReplacementText("laquo", "\u00ab");
            parser.defineEntityReplacementText("not", "\u00ac");
            parser.defineEntityReplacementText("shy", "\u00ad");
            parser.defineEntityReplacementText("reg", "\u00ae");
            parser.defineEntityReplacementText("macr", "\u00af");
            parser.defineEntityReplacementText("deg", "\u00b0");
            parser.defineEntityReplacementText("plusmn", "\u00b1");
            parser.defineEntityReplacementText("sup2", "\u00b2");
            parser.defineEntityReplacementText("sup3", "\u00b3");
            parser.defineEntityReplacementText("acute", "\u00b4");
            parser.defineEntityReplacementText("micro", "\u00b5");
            parser.defineEntityReplacementText("para", "\u00b6");
            parser.defineEntityReplacementText("middot", "\u00b7");
            parser.defineEntityReplacementText("cedil", "\u00b8");
            parser.defineEntityReplacementText("sup1", "\u00b9");
            parser.defineEntityReplacementText("ordm", "\u00ba");
            parser.defineEntityReplacementText("raquo", "\u00bb");
            parser.defineEntityReplacementText("frac14", "\u00bc");
            parser.defineEntityReplacementText("frac12", "\u00bd");
            parser.defineEntityReplacementText("frac34", "\u00be");
            parser.defineEntityReplacementText("iquest", "\u00bf");
            parser.defineEntityReplacementText("Agrave", "\u00c0");
            parser.defineEntityReplacementText("Aacute", "\u00c1");
            parser.defineEntityReplacementText("Acirc", "\u00c2");
            parser.defineEntityReplacementText("Atilde", "\u00c3");
            parser.defineEntityReplacementText("Auml", "\u00c4");
            parser.defineEntityReplacementText("Aring", "\u00c5");
            parser.defineEntityReplacementText("AElig", "\u00c6");
            parser.defineEntityReplacementText("Ccedil", "\u00c7");
            parser.defineEntityReplacementText("Egrave", "\u00c8");
            parser.defineEntityReplacementText("Eacute", "\u00c9");
            parser.defineEntityReplacementText("Ecirc", "\u00ca");
            parser.defineEntityReplacementText("Euml", "\u00cb");
            parser.defineEntityReplacementText("Igrave", "\u00cc");
            parser.defineEntityReplacementText("Iacute", "\u00cd");
            parser.defineEntityReplacementText("Icirc", "\u00ce");
            parser.defineEntityReplacementText("Iuml", "\u00cf");
            parser.defineEntityReplacementText("ETH", "\u00d0");
            parser.defineEntityReplacementText("Ntilde", "\u00d1");
            parser.defineEntityReplacementText("Ograve", "\u00d2");
            parser.defineEntityReplacementText("Oacute", "\u00d3");
            parser.defineEntityReplacementText("Ocirc", "\u00d4");
            parser.defineEntityReplacementText("Otilde", "\u00d5");
            parser.defineEntityReplacementText("Ouml", "\u00d6");
            parser.defineEntityReplacementText("times", "\u00d7");
            parser.defineEntityReplacementText("Oslash", "\u00d8");
            parser.defineEntityReplacementText("Ugrave", "\u00d9");
            parser.defineEntityReplacementText("Uacute", "\u00da");
            parser.defineEntityReplacementText("Ucirc", "\u00db");
            parser.defineEntityReplacementText("Uuml", "\u00dc");
            parser.defineEntityReplacementText("Yacute", "\u00dd");
            parser.defineEntityReplacementText("THORN", "\u00de");
            parser.defineEntityReplacementText("szlig", "\u00df");
            parser.defineEntityReplacementText("agrave", "\u00e0");
            parser.defineEntityReplacementText("aacute", "\u00e1");
            parser.defineEntityReplacementText("acirc", "\u00e2");
            parser.defineEntityReplacementText("atilde", "\u00e3");
            parser.defineEntityReplacementText("auml", "\u00e4");
            parser.defineEntityReplacementText("aring", "\u00e5");
            parser.defineEntityReplacementText("aelig", "\u00e6");
            parser.defineEntityReplacementText("ccedil", "\u00e7");
            parser.defineEntityReplacementText("egrave", "\u00e8");
            parser.defineEntityReplacementText("eacute", "\u00e9");
            parser.defineEntityReplacementText("ecirc", "\u00ea");
            parser.defineEntityReplacementText("euml", "\u00eb");
            parser.defineEntityReplacementText("igrave", "\u00ec");
            parser.defineEntityReplacementText("iacute", "\u00ed");
            parser.defineEntityReplacementText("icirc", "\u00ee");
            parser.defineEntityReplacementText("iuml", "\u00ef");
            parser.defineEntityReplacementText("eth", "\u00f0");
            parser.defineEntityReplacementText("ntilde", "\u00f1");
            parser.defineEntityReplacementText("ograve", "\u00f2");
            parser.defineEntityReplacementText("oacute", "\u00f3");
            parser.defineEntityReplacementText("ocirc", "\u00f4");
            parser.defineEntityReplacementText("otilde", "\u00f5");
            parser.defineEntityReplacementText("ouml", "\u00f6");
            parser.defineEntityReplacementText("divide", "\u00f7");
            parser.defineEntityReplacementText("oslash", "\u00f8");
            parser.defineEntityReplacementText("ugrave", "\u00f9");
            parser.defineEntityReplacementText("uacute", "\u00fa");
            parser.defineEntityReplacementText("ucirc", "\u00fb");
            parser.defineEntityReplacementText("uuml", "\u00fc");
            parser.defineEntityReplacementText("yacute", "\u00fd");
            parser.defineEntityReplacementText("thorn", "\u00fe");
            parser.defineEntityReplacementText("yuml", "\u00ff");
            parser.defineEntityReplacementText("OElig", "\u0152");
            parser.defineEntityReplacementText("oelig", "\u0153");
            parser.defineEntityReplacementText("Scaron", "\u0160");
            parser.defineEntityReplacementText("scaron", "\u0161");
            parser.defineEntityReplacementText("Yuml", "\u0178");
            parser.defineEntityReplacementText("circ", "\u02c6");
            parser.defineEntityReplacementText("tilde", "\u02dc");
            parser.defineEntityReplacementText("ensp", "\u2002");
            parser.defineEntityReplacementText("emsp", "\u2003");
            parser.defineEntityReplacementText("thinsp", "\u2009");
            parser.defineEntityReplacementText("zwnj", "\u200c");
            parser.defineEntityReplacementText("zwj", "\u200d");
            parser.defineEntityReplacementText("lrm", "\u200e");
            parser.defineEntityReplacementText("rlm", "\u200f");
            parser.defineEntityReplacementText("ndash", "\u2013");
            parser.defineEntityReplacementText("mdash", "\u2014");
            parser.defineEntityReplacementText("lsquo", "\u2018");
            parser.defineEntityReplacementText("rsquo", "\u2019");
            parser.defineEntityReplacementText("sbquo", "\u201a");
            parser.defineEntityReplacementText("ldquo", "\u201c");
            parser.defineEntityReplacementText("rdquo", "\u201d");
            parser.defineEntityReplacementText("bdquo", "\u201e");
            parser.defineEntityReplacementText("dagger", "\u2020");
            parser.defineEntityReplacementText("Dagger", "\u2021");
            parser.defineEntityReplacementText("permil", "\u2030");
            parser.defineEntityReplacementText("lsaquo", "\u2039");
            parser.defineEntityReplacementText("rsaquo", "\u203a");
            parser.defineEntityReplacementText("euro", "\u20ac");
            parser.defineEntityReplacementText("fnof", "\u0192");
            parser.defineEntityReplacementText("Alpha", "\u0391");
            parser.defineEntityReplacementText("Beta", "\u0392");
            parser.defineEntityReplacementText("Gamma", "\u0393");
            parser.defineEntityReplacementText("Delta", "\u0394");
            parser.defineEntityReplacementText("Epsilon", "\u0395");
            parser.defineEntityReplacementText("Zeta", "\u0396");
            parser.defineEntityReplacementText("Eta", "\u0397");
            parser.defineEntityReplacementText("Theta", "\u0398");
            parser.defineEntityReplacementText("Iota", "\u0399");
            parser.defineEntityReplacementText("Kappa", "\u039a");
            parser.defineEntityReplacementText("Lambda", "\u039b");
            parser.defineEntityReplacementText("Mu", "\u039c");
            parser.defineEntityReplacementText("Nu", "\u039d");
            parser.defineEntityReplacementText("Xi", "\u039e");
            parser.defineEntityReplacementText("Omicron", "\u039f");
            parser.defineEntityReplacementText("Pi", "\u03a0");
            parser.defineEntityReplacementText("Rho", "\u03a1");
            parser.defineEntityReplacementText("Sigma", "\u03a3");
            parser.defineEntityReplacementText("Tau", "\u03a4");
            parser.defineEntityReplacementText("Upsilon", "\u03a5");
            parser.defineEntityReplacementText("Phi", "\u03a6");
            parser.defineEntityReplacementText("Chi", "\u03a7");
            parser.defineEntityReplacementText("Psi", "\u03a8");
            parser.defineEntityReplacementText("Omega", "\u03a9");
            parser.defineEntityReplacementText("alpha", "\u03b1");
            parser.defineEntityReplacementText("beta", "\u03b2");
            parser.defineEntityReplacementText("gamma", "\u03b3");
            parser.defineEntityReplacementText("delta", "\u03b4");
            parser.defineEntityReplacementText("epsilon", "\u03b5");
            parser.defineEntityReplacementText("zeta", "\u03b6");
            parser.defineEntityReplacementText("eta", "\u03b7");
            parser.defineEntityReplacementText("theta", "\u03b8");
            parser.defineEntityReplacementText("iota", "\u03b9");
            parser.defineEntityReplacementText("kappa", "\u03ba");
            parser.defineEntityReplacementText("lambda", "\u03bb");
            parser.defineEntityReplacementText("mu", "\u03bc");
            parser.defineEntityReplacementText("nu", "\u03bd");
            parser.defineEntityReplacementText("xi", "\u03be");
            parser.defineEntityReplacementText("omicron", "\u03bf");
            parser.defineEntityReplacementText("pi", "\u03c0");
            parser.defineEntityReplacementText("rho", "\u03c1");
            parser.defineEntityReplacementText("sigmaf", "\u03c2");
            parser.defineEntityReplacementText("sigma", "\u03c3");
            parser.defineEntityReplacementText("tau", "\u03c4");
            parser.defineEntityReplacementText("upsilon", "\u03c5");
            parser.defineEntityReplacementText("phi", "\u03c6");
            parser.defineEntityReplacementText("chi", "\u03c7");
            parser.defineEntityReplacementText("psi", "\u03c8");
            parser.defineEntityReplacementText("omega", "\u03c9");
            parser.defineEntityReplacementText("thetasym", "\u03d1");
            parser.defineEntityReplacementText("upsih", "\u03d2");
            parser.defineEntityReplacementText("piv", "\u03d6");
            parser.defineEntityReplacementText("bull", "\u2022");
            parser.defineEntityReplacementText("hellip", "\u2026");
            parser.defineEntityReplacementText("prime", "\u2032");
            parser.defineEntityReplacementText("Prime", "\u2033");
            parser.defineEntityReplacementText("oline", "\u203e");
            parser.defineEntityReplacementText("frasl", "\u2044");
            parser.defineEntityReplacementText("weierp", "\u2118");
            parser.defineEntityReplacementText("image", "\u2111");
            parser.defineEntityReplacementText("real", "\u211c");
            parser.defineEntityReplacementText("trade", "\u2122");
            parser.defineEntityReplacementText("alefsym", "\u2135");
            parser.defineEntityReplacementText("larr", "\u2190");
            parser.defineEntityReplacementText("uarr", "\u2191");
            parser.defineEntityReplacementText("rarr", "\u2192");
            parser.defineEntityReplacementText("darr", "\u2193");
            parser.defineEntityReplacementText("harr", "\u2194");
            parser.defineEntityReplacementText("crarr", "\u21b5");
            parser.defineEntityReplacementText("lArr", "\u21d0");
            parser.defineEntityReplacementText("uArr", "\u21d1");
            parser.defineEntityReplacementText("rArr", "\u21d2");
            parser.defineEntityReplacementText("dArr", "\u21d3");
            parser.defineEntityReplacementText("hArr", "\u21d4");
            parser.defineEntityReplacementText("forall", "\u2200");
            parser.defineEntityReplacementText("part", "\u2202");
            parser.defineEntityReplacementText("exist", "\u2203");
            parser.defineEntityReplacementText("empty", "\u2205");
            parser.defineEntityReplacementText("nabla", "\u2207");
            parser.defineEntityReplacementText("isin", "\u2208");
            parser.defineEntityReplacementText("notin", "\u2209");
            parser.defineEntityReplacementText("ni", "\u220b");
            parser.defineEntityReplacementText("prod", "\u220f");
            parser.defineEntityReplacementText("sum", "\u2211");
            parser.defineEntityReplacementText("minus", "\u2212");
            parser.defineEntityReplacementText("lowast", "\u2217");
            parser.defineEntityReplacementText("radic", "\u221a");
            parser.defineEntityReplacementText("prop", "\u221d");
            parser.defineEntityReplacementText("infin", "\u221e");
            parser.defineEntityReplacementText("ang", "\u2220");
            parser.defineEntityReplacementText("and", "\u2227");
            parser.defineEntityReplacementText("or", "\u2228");
            parser.defineEntityReplacementText("cap", "\u2229");
            parser.defineEntityReplacementText("cup", "\u222a");
            parser.defineEntityReplacementText("int", "\u222b");
            parser.defineEntityReplacementText("there4", "\u2234");
            parser.defineEntityReplacementText("sim", "\u223c");
            parser.defineEntityReplacementText("cong", "\u2245");
            parser.defineEntityReplacementText("asymp", "\u2248");
            parser.defineEntityReplacementText("ne", "\u2260");
            parser.defineEntityReplacementText("equiv", "\u2261");
            parser.defineEntityReplacementText("le", "\u2264");
            parser.defineEntityReplacementText("ge", "\u2265");
            parser.defineEntityReplacementText("sub", "\u2282");
            parser.defineEntityReplacementText("sup", "\u2283");
            parser.defineEntityReplacementText("nsub", "\u2284");
            parser.defineEntityReplacementText("sube", "\u2286");
            parser.defineEntityReplacementText("supe", "\u2287");
            parser.defineEntityReplacementText("oplus", "\u2295");
            parser.defineEntityReplacementText("otimes", "\u2297");
            parser.defineEntityReplacementText("perp", "\u22a5");
            parser.defineEntityReplacementText("sdot", "\u22c5");
            parser.defineEntityReplacementText("lceil", "\u2308");
            parser.defineEntityReplacementText("rceil", "\u2309");
            parser.defineEntityReplacementText("lfloor", "\u230a");
            parser.defineEntityReplacementText("rfloor", "\u230b");
            parser.defineEntityReplacementText("lang", "\u2329");
            parser.defineEntityReplacementText("rang", "\u232a");
            parser.defineEntityReplacementText("loz", "\u25ca");
            parser.defineEntityReplacementText("spades", "\u2660");
            parser.defineEntityReplacementText("clubs", "\u2663");
            parser.defineEntityReplacementText("hearts", "\u2665");
            parser.defineEntityReplacementText("diams", "\u2666");
        }
        parser.next();
        return this.parseAssembly("assembly", (XmlPullParser)parser, strict);
    }

    public Assembly read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public Assembly read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)in);
        return this.read((Reader)reader, strict);
    }

    public Assembly read(InputStream in) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)in);
        return this.read((Reader)reader);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }
}

