/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.staging.client.StagingWorkflowV3Service;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class ProgressMonitorImpl
implements StagingWorkflowV3Service.ProgressMonitor {
    protected final Logger logger;
    protected boolean needsNewline;

    public ProgressMonitorImpl(Logger logger) {
        this.logger = (Logger)Preconditions.checkNotNull((Object)logger);
    }

    public ProgressMonitorImpl(Log log) {
        int level = 1;
        if (log.isDebugEnabled()) {
            level = 0;
        }
        this.logger = new ConsoleLogger(level, this.getClass().getName());
    }

    public ProgressMonitorImpl(boolean debug) {
        int level = 1;
        if (debug) {
            level = 0;
        }
        this.logger = new ConsoleLogger(level, this.getClass().getName());
    }

    protected void maybePrintln() {
        if (this.needsNewline) {
            System.out.println();
            this.needsNewline = false;
        }
    }

    @Override
    public void start() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("START");
        } else {
            System.out.println();
            System.out.print("Waiting for operation to complete...");
        }
    }

    @Override
    public void tick() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("TICK");
        } else {
            this.needsNewline = true;
            System.out.print(".");
        }
    }

    @Override
    public void pause() {
        this.logger.debug("PAUSE");
    }

    @Override
    public void info(String message) {
        this.logger.debug(message);
    }

    @Override
    public void error(String message) {
        this.logger.debug(message);
    }

    @Override
    public void stop() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("STOP");
        } else {
            this.maybePrintln();
            System.out.println();
        }
    }

    @Override
    public void timeout() {
        this.maybePrintln();
        this.logger.warn("TIMEOUT");
    }

    @Override
    public void interrupted() {
        this.maybePrintln();
        this.logger.warn("INTERRUPTED");
    }
}

