/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;
import org.sonatype.nexus.maven.staging.StagingAction;

public class StagingActionMessages {
    private final String stagingDescription;
    private final Map<StagingAction, String> stagingDescriptions;
    private final String defaultDescription;

    public StagingActionMessages(String stagingDescription, Map<StagingAction, String> stagingDescriptions, String defaultDescription) {
        this.stagingDescription = stagingDescription;
        this.stagingDescriptions = (Map)Preconditions.checkNotNull(stagingDescriptions);
        this.defaultDescription = (String)Preconditions.checkNotNull((Object)defaultDescription);
    }

    public String getMessageForAction(StagingAction action) {
        Preconditions.checkNotNull((Object)((Object)action));
        if (!Strings.isNullOrEmpty((String)this.stagingDescription)) {
            return this.stagingDescription;
        }
        if (this.stagingDescriptions.containsKey((Object)action)) {
            return this.stagingDescriptions.get((Object)action);
        }
        return this.defaultDescription;
    }
}

