/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UnsignedValueConstant;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class ULongValue
extends UnsignedValueConstant<Long> {
    public ULongValue(long longValue) {
        super(longValue);
    }

    @Override
    @NotNull
    public KotlinType getType(@NotNull ModuleDescriptor module) {
        KotlinType kotlinType;
        SimpleType simpleType2;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(module, StandardNames.FqNames.uLong);
        SimpleType simpleType3 = simpleType2 = classDescriptor != null ? classDescriptor.getDefaultType() : null;
        if (simpleType2 == null) {
            SimpleType simpleType4 = ErrorUtils.createErrorType("Unsigned type ULong not found");
            Intrinsics.checkNotNullExpressionValue((Object)simpleType4, (String)"createErrorType(\"Unsigned type ULong not found\")");
            kotlinType = simpleType4;
        } else {
            kotlinType = simpleType2;
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public String toString() {
        return ((Number)this.getValue()).longValue() + ".toULong()";
    }
}

