/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest;

import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.client.core.Condition;
import org.sonatype.nexus.client.core.NexusClient;
import org.sonatype.nexus.client.core.NexusStatus;
import org.sonatype.nexus.client.internal.util.Check;
import org.sonatype.nexus.client.rest.ConnectionInfo;

public abstract class AbstractNexusClient
implements NexusClient {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConnectionInfo connectionInfo;
    private final LinkedHashMap<Class<?>, Object> subsystemInstanceCache;
    private NexusStatus nexusStatus;

    protected AbstractNexusClient(ConnectionInfo connectionInfo) {
        this.connectionInfo = Check.notNull(connectionInfo, ConnectionInfo.class);
        this.subsystemInstanceCache = new LinkedHashMap();
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public NexusStatus getNexusStatus() {
        return this.nexusStatus;
    }

    @Override
    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    @Override
    public synchronized <S> S getSubsystem(Class<S> subsystemType) {
        if (this.subsystemInstanceCache.containsKey(subsystemType)) {
            return subsystemType.cast(this.subsystemInstanceCache.get(subsystemType));
        }
        S subsystem = this.createSubsystem(subsystemType);
        this.subsystemInstanceCache.put(subsystemType, subsystem);
        return subsystem;
    }

    @Override
    public synchronized void close() {
        this.subsystemInstanceCache.clear();
    }

    protected void initializeConnection(Condition connectionCondition) {
        this.nexusStatus = Check.notNull(this.getStatus(), "Nexus status is null!");
        this.getLogger().debug("Connected, received {} ", (Object)this.nexusStatus);
        if (!connectionCondition.isSatisfiedBy(this.nexusStatus)) {
            throw new IllegalStateException("Not connecting to remote Nexus, condition(s) are not satisfied: " + connectionCondition.explainNotSatisfied(this.nexusStatus));
        }
    }

    protected abstract <S> S createSubsystem(Class<S> var1) throws IllegalArgumentException;
}

