/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.rest.jersey;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Path;
import org.sonatype.nexus.client.core.spi.SubsystemProvider;
import org.sonatype.sisu.siesta.client.ClientBuilder;

@Named
@Singleton
public class SiestaClientSubsystemProvider
implements SubsystemProvider {
    @Override
    public Object get(Class type, Map<Object, Object> context) {
        Preconditions.checkNotNull((Object)type, (Object)"type cannot be null");
        Preconditions.checkNotNull(context, (Object)"context cannot be null");
        if (!type.isInterface()) {
            return null;
        }
        ClientBuilder.Target.Factory factory = (ClientBuilder.Target.Factory)context.get(ClientBuilder.Target.Factory.class);
        if (factory == null) {
            return null;
        }
        if (this.hasPathAnnotation(type)) {
            return factory.build(type);
        }
        for (Method method : type.getMethods()) {
            if (method.getAnnotation(Path.class) == null) continue;
            return factory.build(type);
        }
        return null;
    }

    private boolean hasPathAnnotation(Class type) {
        if (type.getAnnotation(Path.class) != null) {
            return true;
        }
        for (Class<?> extended : type.getInterfaces()) {
            if (!this.hasPathAnnotation(extended)) continue;
            return true;
        }
        return false;
    }
}

