/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractStandardEnforcerRule;

public abstract class AbstractRequireFiles
extends AbstractStandardEnforcerRule {
    private File[] files;
    private boolean allowNulls = false;

    abstract boolean checkFile(File var1);

    abstract String getErrorMsg();

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        if (!this.allowNulls && this.files.length == 0) {
            throw new EnforcerRuleException("The file list is empty and Null files are disabled.");
        }
        ArrayList<File> failures = new ArrayList<File>();
        for (File file : this.files) {
            if (!this.allowNulls && file == null) {
                failures.add(file);
                continue;
            }
            if (this.checkFile(file)) continue;
            failures.add(file);
        }
        if (!failures.isEmpty()) {
            String message = this.getMessage();
            StringBuilder buf = new StringBuilder();
            if (message != null) {
                buf.append(message + System.lineSeparator());
            }
            buf.append(this.getErrorMsg());
            for (File file : failures) {
                if (file != null) {
                    buf.append(file.getAbsolutePath() + System.lineSeparator());
                    continue;
                }
                buf.append("(an empty filename was given and allowNulls is false)" + System.lineSeparator());
            }
            throw new EnforcerRuleException(buf.toString());
        }
    }

    public String getCacheId() {
        return Integer.toString(AbstractRequireFiles.hashCode(this.files));
    }

    private static int hashCode(Object[] items) {
        int hash = 0;
        if (items != null) {
            hash = 1;
            for (int i = 0; i < items.length; ++i) {
                Object item = items[i];
                hash = 31 * hash + (item == null ? 0 : item.hashCode());
            }
        }
        return hash;
    }

    public boolean isCacheable() {
        return true;
    }

    public boolean isResultValid(EnforcerRule cachedRule) {
        return true;
    }

    public File[] getFiles() {
        return this.files;
    }

    public void setFiles(File[] files) {
        this.files = files;
    }

    public boolean isAllowNulls() {
        return this.allowNulls;
    }

    public void setAllowNulls(boolean allowNulls) {
        this.allowNulls = allowNulls;
    }
}

