/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class RequireSnapshotVersion
extends AbstractNonCacheableEnforcerRule {
    private boolean failWhenParentIsRelease = true;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Artifact parentArtifact;
        MavenProject project = this.getProject(helper);
        Artifact artifact = project.getArtifact();
        if (!artifact.isSnapshot()) {
            String message = this.getMessage();
            StringBuilder sb = new StringBuilder();
            if (message != null) {
                sb.append(message).append(System.lineSeparator());
            }
            sb.append("This project cannot be a release:").append(artifact.getId());
            throw new EnforcerRuleException(sb.toString());
        }
        if (this.failWhenParentIsRelease && (parentArtifact = project.getParentArtifact()) != null && !parentArtifact.isSnapshot()) {
            throw new EnforcerRuleException("Parent cannot be a release: " + parentArtifact.getId());
        }
    }

    private MavenProject getProject(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            return (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to retrieve the MavenProject: ", (Exception)((Object)eee));
        }
    }

    public boolean isFailWhenParentIsRelease() {
        return this.failWhenParentIsRelease;
    }

    public void setFailWhenParentIsRelease(boolean failWhenParentIsRelease) {
        this.failWhenParentIsRelease = failWhenParentIsRelease;
    }
}

