/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.checkstyle;

import java.util.Objects;
import java.util.StringJoiner;

class Violation {
    protected static final String NO_COLUMN = "-1";
    private final String source;
    private final String file;
    private final String line;
    private String column = "-1";
    private final String severity;
    private final String message;
    private final String ruleName;
    private final String category;

    Violation(String source, String file, String line, String severity, String message, String ruleName, String category) {
        this.source = Objects.requireNonNull(source);
        this.file = file;
        this.line = line;
        this.severity = Objects.requireNonNull(severity);
        this.message = Objects.requireNonNull(message);
        this.ruleName = Objects.requireNonNull(ruleName);
        this.category = Objects.requireNonNull(category);
    }

    protected String getSource() {
        return this.source;
    }

    protected String getFile() {
        return this.file;
    }

    protected String getLine() {
        return this.line;
    }

    protected String getColumn() {
        return this.column;
    }

    protected void setColumn(String column) {
        this.column = column == null || column.length() < 1 ? NO_COLUMN : column;
    }

    protected String getSeverity() {
        return this.severity;
    }

    protected String getMessage() {
        return this.message;
    }

    protected String getRuleName() {
        return this.ruleName;
    }

    protected String getCategory() {
        return this.category;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Violation)) {
            return false;
        }
        Violation violation = (Violation)other;
        return this.line.equals(violation.line) && Objects.equals(this.column, violation.column) && this.source.equals(violation.source) && this.file.equals(violation.file) && this.severity.equals(violation.severity) && this.message.equals(violation.message) && this.ruleName.equals(violation.ruleName) && this.category.equals(violation.category);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.file, this.line, this.column, this.severity, this.message, this.ruleName, this.category);
    }

    public String toString() {
        return new StringJoiner(", ", Violation.class.getSimpleName() + "[", "]").add("source='" + this.source + "'").add("file='" + this.file + "'").add("line=" + this.line).add("column=" + this.column).add("severity='" + this.severity + "'").add("message='" + this.message + "'").add("ruleName='" + this.ruleName + "'").add("category='" + this.category + "'").toString();
    }
}

