/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.hawtbuf;

import java.util.ArrayList;
import java.util.List;
import org.fusesource.hawtbuf.proto.BaseMessage;
import org.sonatype.spice.zapper.internal.hawtbuf.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FileBase<T>
extends BaseMessage<T> {
    private String f_fileId = null;
    private boolean b_fileId;
    private String f_path = null;
    private boolean b_path;
    private long f_fileLastModified = 0L;
    private boolean b_fileLastModified;
    private List<Hash> f_hashes;
    private List<String> f_filters;

    FileBase() {
    }

    public boolean hasFileId() {
        return this.b_fileId;
    }

    public String getFileId() {
        return this.f_fileId;
    }

    public T setFileId(String fileId) {
        this.loadAndClear();
        this.b_fileId = true;
        this.f_fileId = fileId;
        return (T)((Object)this);
    }

    public void clearFileId() {
        this.loadAndClear();
        this.b_fileId = false;
        this.f_fileId = null;
    }

    public boolean hasPath() {
        return this.b_path;
    }

    public String getPath() {
        return this.f_path;
    }

    public T setPath(String path) {
        this.loadAndClear();
        this.b_path = true;
        this.f_path = path;
        return (T)((Object)this);
    }

    public void clearPath() {
        this.loadAndClear();
        this.b_path = false;
        this.f_path = null;
    }

    public boolean hasFileLastModified() {
        return this.b_fileLastModified;
    }

    public long getFileLastModified() {
        return this.f_fileLastModified;
    }

    public T setFileLastModified(long fileLastModified) {
        this.loadAndClear();
        this.b_fileLastModified = true;
        this.f_fileLastModified = fileLastModified;
        return (T)((Object)this);
    }

    public void clearFileLastModified() {
        this.loadAndClear();
        this.b_fileLastModified = false;
        this.f_fileLastModified = 0L;
    }

    public boolean hasHashes() {
        return this.f_hashes != null && !this.f_hashes.isEmpty();
    }

    public List<Hash> getHashesList() {
        if (this.f_hashes == null) {
            this.f_hashes = new ArrayList<Hash>();
        }
        return this.f_hashes;
    }

    public T setHashesList(List<Hash> hashes) {
        this.loadAndClear();
        this.f_hashes = hashes;
        return (T)((Object)this);
    }

    public int getHashesCount() {
        if (this.f_hashes == null) {
            return 0;
        }
        return this.f_hashes.size();
    }

    public Hash getHashes(int index) {
        if (this.f_hashes == null) {
            return null;
        }
        return this.f_hashes.get(index);
    }

    public T setHashes(int index, Hash value) {
        this.loadAndClear();
        this.getHashesList().set(index, value);
        return (T)((Object)this);
    }

    public T addHashes(Hash value) {
        this.loadAndClear();
        this.getHashesList().add(value);
        return (T)((Object)this);
    }

    public T addAllHashes(Iterable<? extends Hash> collection) {
        this.loadAndClear();
        BaseMessage.addAll(collection, this.getHashesList());
        return (T)((Object)this);
    }

    public void clearHashes() {
        this.loadAndClear();
        this.f_hashes = null;
    }

    public boolean hasFilters() {
        return this.f_filters != null && !this.f_filters.isEmpty();
    }

    public List<String> getFiltersList() {
        if (this.f_filters == null) {
            this.f_filters = new ArrayList<String>();
        }
        return this.f_filters;
    }

    public T setFiltersList(List<String> filters) {
        this.loadAndClear();
        this.f_filters = filters;
        return (T)((Object)this);
    }

    public int getFiltersCount() {
        if (this.f_filters == null) {
            return 0;
        }
        return this.f_filters.size();
    }

    public String getFilters(int index) {
        if (this.f_filters == null) {
            return null;
        }
        return this.f_filters.get(index);
    }

    public T setFilters(int index, String value) {
        this.loadAndClear();
        this.getFiltersList().set(index, value);
        return (T)((Object)this);
    }

    public T addFilters(String value) {
        this.loadAndClear();
        this.getFiltersList().add(value);
        return (T)((Object)this);
    }

    public T addAllFilters(Iterable<? extends String> collection) {
        this.loadAndClear();
        BaseMessage.addAll(collection, this.getFiltersList());
        return (T)((Object)this);
    }

    public void clearFilters() {
        this.loadAndClear();
        this.f_filters = null;
    }
}

