# coding=utf-8
# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# --------------------------------------------------------------------------------------------

from knack.help_files import helps  # pylint: disable=unused-import
# pylint: disable=line-too-long, too-many-lines

helps['kusto'] = """
type: group
short-summary: Manage Azure Kusto resources
long-summary: This module will not be supported starting January 1, 2021. Please execute "az extension add -n kusto" to install the supported Kusto extension
"""

helps['kusto cluster'] = """
type: group
short-summary: Manage Azure Kusto clusters.
long-summary: This module will not be supported starting January 1, 2021. Please execute "az extension add -n kusto" to install the supported Kusto extension
"""

helps['kusto cluster create'] = """
type: command
short-summary: Create a Kusto cluster.
examples:
  - name: Create a Kusto Cluster.
    text: |-
        az kusto cluster create -l "Central US" -n myclustername -g myrgname --sku D13_v2 --capacity 10
"""

helps['kusto cluster delete'] = """
type: command
short-summary: Delete a Kusto cluster.
"""

helps['kusto cluster list'] = """
type: command
short-summary: List a Kusto cluster.
examples:
  - name: List a Kusto cluster. (autogenerated)
    text: az kusto cluster list --resource-group MyResourceGroup
    crafted: true
"""

helps['kusto cluster show'] = """
type: command
short-summary: Get a Kusto cluster.
examples:
  - name: Get a Kusto cluster. (autogenerated)
    text: az kusto cluster show --name MyCluster --resource-group MyResourceGroup
    crafted: true
"""

helps['kusto cluster start'] = """
type: command
short-summary: Start a Kusto cluster.
long-summary: When the cluster is restarted, it takes about ten minutes for it to become available (like when it was originally provisioned). It takes additional time for data to load into the hot cache.
"""

helps['kusto cluster stop'] = """
type: command
short-summary: Stop a Kusto cluster.
long-summary: When the cluster is stopped, data is not available for queries, and you can't ingest new data. Start cluster to enable queries
"""

helps['kusto cluster update'] = """
type: command
short-summary: Update a Kusto cluster.
examples:
  - name: update a Kusto Cluster.
    text: |-
        az kusto cluster update -n myclustername -g myrgname --sku D14_v2 --capacity 4
"""

helps['kusto cluster wait'] = """
type: command
short-summary: Wait for a managed Kusto cluster to reach a desired state.
long-summary: If an operation on a cluster was interrupted or was started with `--no-wait`, use this command to wait for it to complete.
"""

helps['kusto database'] = """
type: group
short-summary: Manage Azure Kusto databases.
long-summary: Azure CLI commands for Kusto are now an extension.  Execute "az extension add -n kusto" to install the extension.  The original core module for Kusto is no longer supported.
"""

helps['kusto database create'] = """
type: command
short-summary: Create a Kusto database.
examples:
  - name: create a Kusto Database.
    text: |-
        az kusto database create --cluster-name myclustername -g myrgname -n mydbname  --soft-delete-period P365D --hot-cache-period P31D
"""

helps['kusto database delete'] = """
type: command
short-summary: Delete a Kusto database.
"""

helps['kusto database list'] = """
type: command
short-summary: List a Kusto database.
examples:
  - name: List a Kusto database. (autogenerated)
    text: az kusto database list --cluster-name MyCluster --resource-group MyResourceGroup
    crafted: true
"""

helps['kusto database show'] = """
type: command
short-summary: Get a Kusto database.
examples:
  - name: Get a Kusto database. (autogenerated)
    text: az kusto database show --cluster-name MyCluster --name MyDatabase --resource-group MyResourceGroup
    crafted: true
"""

helps['kusto database update'] = """
type: command
short-summary: Update a Kusto database.
examples:
  - name: create a Kusto Database.
    text: |-
        az kusto database update --cluster-name myclustername -g myrgname -n mydbname  --soft-delete-period P365D --hot-cache-period P30D
"""

helps['kusto database wait'] = """
type: command
short-summary: Wait for a managed Kusto database to reach a desired state.
long-summary: If an operation on a database was interrupted or was started with `--no-wait`, use this command to wait for it to complete.
"""
