/*
 *  crnl.c: Convert ASCII files in CR-NL (DOS) format to NL-only (UNIX) format.
 *  usage:  crnl filename(s)
 *  Compile:
 *      cc crnl.c -o crnl
 *
 *      Written by Leor Zolman, 4/92/92, for inclusion with R&D Publications'
 *      CUJ and Windows/DOS code disk archives on UUNET. Since these archives
 *      are stored in MS-DOS file format, use this program to convert
 *      individual text files into Unix text format.
 *
 *      DOS-format files are replaced with their UNIX-format equivalents.
 *      I don't bother saving the original; if you want to preserve the
 *      original files, make copies before running crnl on them.
 */

#include <stdio.h>

main(argc, argv)
int argc;
char **argv;
{
    FILE *fp, *fpo;
    int i, ch;
    char *tmpname;
    char command[100];
    
    if (argc < 2)
        exit(fprintf(stderr, "usage:  %s filename(s)\n", argv[0]));
    tmpname = tmpnam(NULL);
    
    for (i = 1; i < argc; i++)
    {   
        if ((fp = fopen(argv[i], "r")) == NULL)
        {
            fprintf(stderr, "%s: Can't open %s for input.\n", 
                    argv[0],  argv[i]);
            continue;
        }

        printf("Converting %s...", argv[i]);
        
        if ((fpo = fopen(tmpname, "w")) == NULL)
        {
            fprintf(stderr, "%s: Can't open temp file %s for writing.\n", 
                    argv[0],  tmpname);
            fclose(fp);
            exit(1);
        }
    
        while ((ch = getc(fp)) != EOF)
            if (ch != '\r')
                putc(ch, fpo);
        
        fclose(fp);
        if (fclose(fpo))
            exit(fprintf(stderr, "%s: error closing temp file %s.\n",
                    argv[0], tmpname));

        unlink(argv[i]);

        sprintf(command, "cp %s %s", tmpname, argv[i]);
        if (system(command))
            exit(fprintf(stderr, "%s: error copying %s to %s.",
                    argv[0], tmpname, argv[i]));

        unlink(tmpname);
        printf("successful.\n");
    }       
}

