### polymake program generator for region.exe

# note: the compiler is set by the environment variable C
#	which is either ZORTECH or MSC
# note: This project requires Zortech Flash Graphics and will not run on MSC
# note: to create debugging info (make d=1 -f ...)

# project
NAME = region
PART1 = region zone display loadsave gui menu dialog
CFILES = $(PART1)
COBJS = $[f,,$(CFILES),obj]

%if "$(C)" == "ZORTECH"			# Zortech compiler
# model
MODEL = li
INTOBJ = int
LIB =
# tools
CC = ztc
ASM = masm
LINK = blinkx
# debug versus normal
%if "$(d)"	# debug
CFLAGS = -g -s -C -c -r -m$(MODEL) -DDEBUG=1
AFLAGS = /Zi /W2 /T
LFLAGS = /CO /M /NOD
LIB = zll fgdebug
%else		# normal
CFLAGS = -o -c -r -m$(MODEL) -DNDEBUG=1
AFLAGS = /W2 /T
LFLAGS = /F /PAC /NOD
LIB = zll fg
%endif

%elseif "$(C)" = "MSC"			# Microsoft C compiler
doa:
	@echo *** This program does not work with MSC. It requires Zortech Flash Graphics ***
	%abort 666

%else				# No compiler specified
doa:
	@echo *** No compiler specified ***
	%abort 666
%endif


#rules
.asm.obj :
	$(ASM) $(AFLAGS) $<,$@;
.c.obj :
	$(CC) $(CFLAGS) $<


# ding an sich
$(NAME).exe: $(COBJS)
   $(LINK)  $(LFLAGS) <@<
$[s,"+",$(PART1)] $(INTOBJ)
$(NAME).exe
$(NAME).map
$(LIB)
;
<

#dependencies
gui.h: keys.h
region.obj: region.c display.h loadsave.h gui.h zone.h
zone.obj: zone.c zone.h display.h
display.obj: display.c display.h gui.h zone.h
loadsave.obj: loadsave.c loadsave.h gui.h
gui.obj: gui.c gui.h
menu.obj: menu.c gui.h
dialog.obj: dialog.c gui.h
