/*
** Exception Library -- General exception handling for ANSI C programs
** 
** Copyright (C) 1993 Computational Vision and Active Perception Lab. (CVAP),
**                    Royal Institute of Technology, Stockholm.
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
** 
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with this library (see COPYING-LIB); if not, write to 
** the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
** USA.
** 
**                            Written by
**                                 
**                  Harald Winroth, Matti Rendahl
**      Computational Vision and Active Perception Laboratory
**                  Royal Institute of Technology
**                        S-100 44 Stockholm
**                              Sweden
**                                 
** Report bugs to candela-bug@bion.kth.se, and direct all inquiries to 
** candela@bion.kth.se.
**
*/

/*
 * exc-sig-list.h: List of all signals
 */

#ifndef _exception_exc_sig_list_h
#define _exception_exc_sig_list_h

#if defined(SVR4) || defined(SYSV) || defined(_SYSV_)
_EXC_SIG (_EXC_SIG_ENTRY (SIGHUP,       sighup)
          _EXC_SIG_ENTRY (SIGINT,       sigint)
          _EXC_SIG_ENTRY (SIGQUIT,      sigquit)
          _EXC_SIG_ENTRY (SIGILL,       sigill)
          _EXC_SIG_ENTRY (SIGTRAP,      sigtrap)
          _EXC_SIG_ENTRY (SIGABRT,      sigabrt)
          _EXC_SIG_ENTRY (SIGEMT,       sigemt)
          _EXC_SIG_ENTRY (SIGFPE,       sigfpe)
          _EXC_SIG_ENTRY (SIGKILL,      sigkill)
          _EXC_SIG_ENTRY (SIGBUS,       sigbus)
          _EXC_SIG_ENTRY (SIGSEGV,      sigsegv)
          _EXC_SIG_ENTRY (SIGSYS,       sigsys)
          _EXC_SIG_ENTRY (SIGPIPE,      sigpipe)
          _EXC_SIG_ENTRY (SIGALRM,      sigalrm)
          _EXC_SIG_ENTRY (SIGTERM,      sigterm)
          _EXC_SIG_ENTRY (SIGUSR1,      sigusr1)
          _EXC_SIG_ENTRY (SIGUSR2,      sigusr2)
          _EXC_SIG_ENTRY (SIGCHLD,      sigchld)
          _EXC_SIG_ENTRY (SIGPWR,       sigpwr)
          _EXC_SIG_ENTRY (SIGWINCH,     sigwinch)
          _EXC_SIG_ENTRY (SIGURG,       sigurg)
          _EXC_SIG_ENTRY (SIGPOLL,      sigpoll)
          _EXC_SIG_ENTRY (SIGSTOP,      sigstop)
          _EXC_SIG_ENTRY (SIGTSTP,      sigtstp)
          _EXC_SIG_ENTRY (SIGCONT,      sigcont)
          _EXC_SIG_ENTRY (SIGTTIN,      sigttin)
          _EXC_SIG_ENTRY (SIGTTOU,      sigttou)
          _EXC_SIG_ENTRY (SIGVTALRM,    sigvtalrm)
          _EXC_SIG_ENTRY (SIGPROF,      sigprof)
          _EXC_SIG_ENTRY (SIGXCPU,      sigxcpu)
          _EXC_SIG_ENTRY (SIGXFSZ,      sigxfsz)
          _EXC_SIG_ENTRY (SIGWAITING,   sigwaiting)
          _EXC_SIG_ENTRY (SIGLWP,       siglwp));
#else
_EXC_SIG (_EXC_SIG_ENTRY (SIGHUP,       sighup)
          _EXC_SIG_ENTRY (SIGINT,       sigint)
          _EXC_SIG_ENTRY (SIGQUIT,      sigquit)
          _EXC_SIG_ENTRY (SIGILL,       sigill)
          _EXC_SIG_ENTRY (SIGTRAP,      sigtrap)
          _EXC_SIG_ENTRY (SIGIOT,       sigiot)
          _EXC_SIG_ENTRY (SIGEMT,       sigemt)
          _EXC_SIG_ENTRY (SIGFPE,       sigfpe)
          _EXC_SIG_ENTRY (SIGKILL,      sigkill)
          _EXC_SIG_ENTRY (SIGBUS,       sigbus)
          _EXC_SIG_ENTRY (SIGSEGV,      sigsegv)
          _EXC_SIG_ENTRY (SIGSYS,       sigsys)
          _EXC_SIG_ENTRY (SIGPIPE,      sigpipe)
          _EXC_SIG_ENTRY (SIGALRM,      sigalrm)
          _EXC_SIG_ENTRY (SIGTERM,      sigterm)
          _EXC_SIG_ENTRY (SIGURG,       sigurg)
          _EXC_SIG_ENTRY (SIGSTOP,      sigstop)
          _EXC_SIG_ENTRY (SIGTSTP,      sigtstp)
          _EXC_SIG_ENTRY (SIGCONT,      sigcont)
          _EXC_SIG_ENTRY (SIGCHLD,      sigchld)
          _EXC_SIG_ENTRY (SIGTTIN,      sigttin)
          _EXC_SIG_ENTRY (SIGTTOU,      sigttou)
          _EXC_SIG_ENTRY (SIGIO,        sigio)
          _EXC_SIG_ENTRY (SIGXCPU,      sigxcpu)
          _EXC_SIG_ENTRY (SIGXFSZ,      sigxfsz)
          _EXC_SIG_ENTRY (SIGVTALRM,    sigvtalrm)
          _EXC_SIG_ENTRY (SIGPROF,      sigprof)
          _EXC_SIG_ENTRY (SIGWINCH,     sigwinch)
          _EXC_SIG_ENTRY (SIGLOST,      siglost)
          _EXC_SIG_ENTRY (SIGUSR1,      sigusr1)
          _EXC_SIG_ENTRY (SIGUSR2,      sigusr2));
#endif

#endif /* !_exception_exc_sig_list_h */
