/*
 AnaGram Parsing Engine
 Copyright (c) 1992, Jerome T. Holland.
 All Rights Reserved.
*/


/*  Line 39, D:\C_USR_J\DISTRIB\DGEN.SYN */
#include "tutils.h"

#include "dgen.h"
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define RULE_CONTEXT (&((PCB).cs[(PCB).ssx]))
#define ERROR_CONTEXT ((PCB).cs[(PCB).error_frame_ssx])
#define CONTEXT ((PCB).cs[(PCB).ssx])


#ifndef NEAR
#define NEAR near
#endif
#ifndef LOCUS
#define LOCUS near
#endif
#ifndef VOID
#define VOID void
#endif
#ifndef CONST
#define CONST const
#endif
#ifndef CONVERT_CASE(c)
#define CONVERT_CASE(c) (c)
#endif
#ifndef TAB_SPACING
#define TAB_SPACING 8
#endif
#define AG_INIT_PARSE() VOID init_dgen(VOID)
#define AG_PARSE() VOID dgen(VOID)
#define AG_INITIALIZE() init_dgen()
#define AG_PARSER_STACK_SIZE     32

dgen_pcb_type dgen_pcb;
#define PCB dgen_pcb


#ifndef DGEN_H
#include "dgen.h"
#endif


static char * NEAR ag_rp_1(VOID) {
/* Line 63 */
  return release();
}

static VOID NEAR ag_rp_2(int c) {
/* Line 65 */
  collectFirst(c);
}

static VOID NEAR ag_rp_3(int c) {
/* Line 67 */
  collect(c);
}

static VOID NEAR ag_rp_4(int c) {
/* Line 68 */
  collect(c);
}

static char * NEAR ag_rp_5(VOID) {
/* Line 71 */
  return release();
}

static VOID NEAR ag_rp_6(int c) {
/* Line 73 */
  collectFirst(c);
}

static VOID NEAR ag_rp_7(int c) {
/* Line 75 */
  collect(c);
}

static char * NEAR ag_rp_8(VOID) {
/* Line 83 */
collect('}');return(release());
}

static VOID NEAR ag_rp_9(VOID) {
/* Line 85 */
  collectFirst('{');
}

static VOID NEAR ag_rp_10(int c) {
/* Line 87 */
  collect(c);
}

static VOID NEAR ag_rp_11(VOID) {
/* Line 91 */
  collect('}');
}

static VOID NEAR ag_rp_12(VOID) {
/* Line 93 */
  collect('{');
}

static struct STRLIST * NEAR ag_rp_13(char * s) {
/* Line 95 */
  return listNew(s,"");
}

static struct STRLIST * NEAR ag_rp_14(struct STRLIST * lst, char * s) {
/* Line 96 */
  return listAdd(lst,s,"");
}

static char * NEAR ag_rp_15(VOID) {
/* Line 99 */
  return release();
}

static VOID NEAR ag_rp_16(int c) {
/* Line 101 */
  collectFirst(c);
}

static VOID NEAR ag_rp_17(int c) {
/* Line 103 */
  collect(c);
}

static VOID NEAR ag_rp_18(VOID) {
/* Line 107 */
  writeDriver();
}

static VOID NEAR ag_rp_19(char * eb) {
/* Line 116 */
  addBlock(eb);
}

static VOID NEAR ag_rp_20(char * n) {
/* Line 130 */
  setRunName(n);
}

static VOID NEAR ag_rp_21(struct STRLIST * vl, char * b) {
/* Line 133 */
  makeVary(vl,b);
}

static VOID NEAR ag_rp_22(struct STRLIST * vl, char * b) {
/* Line 135 */
  makeComb(vl,b);
}

static struct STRLIST * NEAR ag_rp_23(char * v) {
/* Line 137 */
  return listNew(v,"");
}

static struct STRLIST * NEAR ag_rp_24(struct STRLIST * lst, char * v) {
/* Line 139 */
  return listAdd(lst,v,"");
}

static VOID NEAR ag_rp_25(struct STRLIST * vl, struct STRLIST * il) {
/* Line 160 */
  addTVars(vl,"char","char",il);
}

static VOID NEAR ag_rp_26(struct STRLIST * vl, struct STRLIST * il) {
/* Line 169 */
  addTVars(vl,"char *","char *",il);
}

static VOID NEAR ag_rp_27(struct STRLIST * vl, struct STRLIST * il) {
/* Line 178 */
  addTVars(vl,"int","int",il);
}

static VOID NEAR ag_rp_28(struct STRLIST * vl, struct STRLIST * il) {
/* Line 187 */
  addTVars(vl,"double","double&",il);
}

static VOID NEAR ag_rp_29(struct STRLIST * vl, struct STRLIST * il) {
/* Line 196 */
  addTVars(vl,"FILE *","FILE *",il);
}

static VOID NEAR ag_rp_30(struct STRLIST * vl, struct STRLIST * il) {
/* Line 207 */
  addTVars(vl,"INTARR2","INTARR2",il);
}

static VOID NEAR ag_rp_31(struct STRLIST * vl, struct STRLIST * il) {
/* Line 216 */
  addTVars(vl,"Item","Item&",il);
}

static VOID NEAR ag_rp_32(struct STRLIST * vl, struct STRLIST * il) {
/* Line 224 */
  addTVars(vl,"Client","Client&",il);
}

static VOID NEAR ag_rp_33(struct STRLIST * vl, struct STRLIST * il) {
/* Line 232 */
  addTVars(vl,"Invoice","Invoice&",il);
}
#define AG_TRACE_ERROR
#define AG_VT dgen_pcb_type
#define AG_COUNT_RULE(k)
static dgen_vs_type ag_null_value;
#define AG_INPUT_TYPE int
#define AG_TOKEN_TYPE dgen_token_type
#define AG_VALUE_STACK_TYPE dgen_vs_type
#define AG_INPUT_VALUE CONVERT_CASE(*PCB.lab)
#define AG_INPUT_CODE (*PCB.lab)
#define V(i,t) (*(t *) (&(PCB).vs[(PCB).ssx + i]))
#define VS(i) (PCB).vs[(PCB).ssx + i]

#ifndef AG_GET_VALUE
#define AG_GET_VALUE AG_INPUT = AG_INPUT_VALUE
#endif

#ifndef GET_CONTEXT
#define GET_CONTEXT CONTEXT = (PCB).input_context
#endif

#ifndef AG_NULL
#define AG_NULL (PCB).vs[(PCB).ssx] = ag_null_value
#endif

#ifdef AG_CONTEXT_TYPE
#define AG_SAVE_CONTEXT {GET_CONTEXT;}
#define AG_SWAP_CONTEXT(k1,k2) (PCB).cs[k1] = (PCB).cs[k2]
#endif

#ifndef AG_SAVE_CONTEXT
#define AG_SAVE_CONTEXT
#define AG_SWAP_CONTEXT(k1,k2)
#endif

typedef enum {
  ag_shift_accept,
  ag_go_to,
  ag_shift_reduce,
  ag_shift_simple_reduce,
  ag_reduce_form,
  ag_simple_reduce,
  ag_accept,
  ag_syn_error,
  ag_null_go_to,
  ag_skip,
  ag_skip_reduce,
  ag_recover
} ag_parser_action;

static int ag_ap;


#define AG_VALUE
#define AG_INPUT (*(int *) &PCB.vs[PCB.ssx])

static CONST unsigned char ag_rpx[] = {
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  3,  4,  5,  6,  7,
    0,  0,  0,  0,  8,  9, 10,  0, 11, 12, 13, 14,  0,  0,  0,  0, 15, 16,
   17,  0,  0, 18,  0,  0,  0, 19,  0, 20, 21, 22, 23, 24,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 25, 26, 27, 28, 29, 30, 31, 32, 33
};

static unsigned char ag_key_itt[] = {
  0
};

static unsigned short ag_key_pt[] = {
0
};

#define AG_KEY
static unsigned char ag_key_ch[] = {
    0,110,116,255, 97,255,116,255,110,255, 47, 67, 70, 73, 99,100,105,114,
  115,255,110,116,255, 97,255,116,255,110,255, 47, 67, 70, 73, 99,100,105,
  114,115,125,255,110,116,255, 97,255,116,255,110,255, 67, 70, 73, 99,100,
  105,114,115,255, 47,255, 47, 99,118,255,123,255, 47,123,255,125,255, 47,
  125,255
};

static unsigned char ag_key_act[] = {
  0,3,3,4,3,4,1,4,2,4,3,3,3,2,3,3,2,3,3,4,3,3,4,3,4,1,4,2,4,3,3,3,2,3,3,
  2,3,3,0,4,3,3,4,3,4,1,4,2,4,3,3,2,3,3,2,3,3,4,3,4,3,3,3,4,0,4,3,0,4,0,
  4,3,0,4
};

static unsigned char ag_key_parm[] = {
    0, 69, 67,  0, 66,  0, 63,  0,  0,  0,  5, 68, 65,  0, 59, 64,  0, 46,
   62,  0, 69, 67,  0, 66,  0, 63,  0,  0,  0,  5, 68, 65,  0, 59, 64,  0,
   46, 62, 61,  0, 69, 67,  0, 66,  0, 63,  0,  0,  0, 68, 65,  0, 59, 64,
    0, 46, 62,  0,  5,  0,  5, 49, 47,  0, 60,  0,  5, 60,  0, 61,  0,  5,
   61,  0
};

static unsigned char ag_key_jmp[] = {
    0, 12, 18,  0, 31,  0,  4,  0,  6,  0,  0,  2,  8,  1, 21, 25,  8, 35,
   42,  0, 60, 66,  0, 79,  0, 23,  0, 25,  0, 48, 50, 56, 20, 69, 73, 27,
   83, 90,  0,  0,106,112,  0,125,  0, 43,  0, 45,  0, 96,102, 40,115,119,
   47,129,136,  0,142,  0,144,146,155,  0,  0,  0,162,  0,  0,  0,  0,164,
    0,  0
};

static unsigned char ag_key_index[] = {
   10,  0, 29, 49,  0,  0, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,  0, 58,
   10, 10, 10, 49, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,  0,  0,  0, 60,
   58, 58, 64, 64, 64, 64, 64, 64, 64, 64, 64,  0,  0, 58, 58, 58, 66, 58,
   58, 58, 58, 58, 58, 58, 58, 58, 58,  0, 58, 58,  0, 66,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0, 69, 69, 69, 69, 69, 69, 69, 69, 69,  0, 71
};

static unsigned char ag_key_ends[] = {
47,0, 108,105,101,110,116,0, 73,76,69,0, 118,111,105,99,101,0, 
101,109,0, 104,97,114,0, 111,117,98,108,101,0, 114,114,50,0, 
117,110,116,101,115,116,0, 116,114,105,110,103,0, 47,0, 
108,105,101,110,116,0, 73,76,69,0, 118,111,105,99,101,0, 101,109,0, 
104,97,114,0, 111,117,98,108,101,0, 114,114,50,0, 
117,110,116,101,115,116,0, 116,114,105,110,103,0, 108,105,101,110,116,0, 
73,76,69,0, 118,111,105,99,101,0, 101,109,0, 104,97,114,0, 
111,117,98,108,101,0, 114,114,50,0, 117,110,116,101,115,116,0, 
116,114,105,110,103,0, 47,0, 47,0, 111,109,98,105,110,105,110,103,0, 
97,114,121,105,110,103,0, 47,0, 47,0, 
};
#define AG_TCV(x) (((int)(x) >= -1 && (int)(x) <= 255) ? ag_tcv[(x) + 1] : 0)

static CONST unsigned char ag_tcv[] = {
   40, 40, 70, 70, 70, 40, 70, 70, 70, 70,  2,  3, 70, 70, 70, 70, 70, 70,
   70, 70, 70, 70, 70, 70, 70, 70, 70, 40, 70, 70, 70, 70, 70,  2, 70, 16,
   70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 71, 71, 71, 71, 71,
   71, 71, 71, 71, 71, 70, 70, 70, 70, 70, 70, 70, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 31, 70, 33, 70, 13, 70, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
   13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 25, 70,
   24, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
   70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
   70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
   70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
   70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
   70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
   70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
   70, 70, 70, 70, 70
};

#define AG_GET_KEY_WORD() ag_get_key_word(int ag_k)
#define AG_RNS()          ag_rns(int ag_t, int *ag_sx, int ag_snd)
#define AG_JNS()          ag_jns(int ag_t)
#define AG_ATX()          ag_atx(int ag_t, int *ag_sx, int ag_snd)
#define AG_CHECK_DEPTH()  ag_check_depth(int ag_fl)
#define AG_VALID()        ag_valid(int ag_k)
#define AG_DEFAULT()      ag_default(CONST int *ag_tp)


#ifndef SYNTAX_ERROR
#define SYNTAX_ERROR fprintf(stderr,"%s, line %d, column %d\n",\
  (PCB).error_message, (PCB).line, (PCB).column)
#endif

#ifndef PARSER_STACK_OVERFLOW
#define PARSER_STACK_OVERFLOW {fprintf(stderr,\
   "\nParser stack overflow, line %d, column %d\n",\
   (PCB).line, (PCB).column);}
#endif

#define AG_OVERFLOW {AG_TRACE_ERROR; (PCB).exit_flag = AG_STACK_ERROR_CODE;\
        PARSER_STACK_OVERFLOW;}

#ifndef REDUCTION_TOKEN_ERROR
#define REDUCTION_TOKEN_ERROR {fprintf(stderr,\
    "\nReduction token error, line %d, column %d\n",\
    (PCB).line, (PCB).column);}
#endif


typedef enum
  {ag_accept_key, ag_set_key, ag_jmp_key, ag_end_key, ag_no_match_key,
   ag_cf_accept_key, ag_cf_set_key, ag_cf_end_key} key_words;

#define AG_CHAR ((PCB).rx < (PCB).fx ? (PCB).lab[(PCB).rx-1] : (PCB).input_code)
#define AG_INIT_PTR ((PCB).rx = (PCB).fx = 0)
#define AG_RST_PTR ((PCB).rx = 0)
#ifndef GET_INPUT
#define GET_INPUT ((PCB).input_code = getchar())
#endif

static NEAR ag_look_ahead(VOID) {
  if ((PCB).rx < (PCB).fx) return (PCB).lab[(PCB).rx++];
  GET_INPUT;
  (PCB).fx++;
  return CONVERT_CASE((PCB).lab[(PCB).rx++] = (PCB).input_code);
}

static VOID NEAR AG_GET_KEY_WORD() {
  int save_index = (PCB).rx;
  unsigned char ag_ch, NEAR *sp;
  while (1) {
    switch (ag_key_act[ag_k]) {
    case ag_cf_end_key:
      sp = ag_key_ends + ag_key_jmp[ag_k];
      do {
        if ((ag_ch = *sp++) == 0) {
          int ag_k1 = ag_key_parm[ag_k];
          int ag_k2 = ag_key_pt[ag_k1];
          if (ag_key_itt[ag_k2 + ag_look_ahead()]) goto ag_fail;
          (PCB).rx--;
          (PCB).token_number = (AG_TOKEN_TYPE) ag_key_pt[ag_k1 + 1];
          return;
        }
      } while (ag_look_ahead() == ag_ch);
      goto ag_fail;
    case ag_end_key:
      sp = ag_key_ends + ag_key_jmp[ag_k];
      do {
        if ((ag_ch = *sp++) == 0) {
          (PCB).token_number = (AG_TOKEN_TYPE) ag_key_parm[ag_k];
          return;
        }
      } while (ag_look_ahead() == ag_ch);
    case ag_no_match_key:
ag_fail:
      (PCB).rx = save_index;
      return;
    case ag_cf_set_key: {
      int ag_k1 = ag_key_parm[ag_k];
      int ag_k2 = ag_key_pt[ag_k1];
      ag_k = ag_key_jmp[ag_k];
      if (ag_key_itt[ag_k2 + (ag_ch = ag_look_ahead())]) break;
      save_index = --(PCB).rx;
      (PCB).token_number = (AG_TOKEN_TYPE) ag_key_pt[ag_k1+1];
      break;
    }
    case ag_set_key:
      save_index = (PCB).rx;
      (PCB).token_number = (AG_TOKEN_TYPE) ag_key_parm[ag_k];
    case ag_jmp_key:
      ag_k = ag_key_jmp[ag_k];
      ag_ch = ag_look_ahead();
      break;
    case ag_accept_key:
      (PCB).token_number =  (AG_TOKEN_TYPE) ag_key_parm[ag_k];
      return;
    case ag_cf_accept_key: {
      int ag_k1 = ag_key_parm[ag_k];
      int ag_k2 = ag_key_pt[ag_k1];
      if (ag_key_itt[ag_k2 + ag_look_ahead()]) (PCB).rx = save_index;
      else {
        (PCB).rx--;
        (PCB).token_number =  (AG_TOKEN_TYPE) ag_key_pt[ag_k1+1];
      }
      return;
    }
    }
    while(ag_key_ch[ag_k] < ag_ch) ag_k++;
    if (ag_key_ch[ag_k] != ag_ch) {
      (PCB).rx = save_index;
      return;
    }
  }
}


#define AG_TRK_PTR ag_track()
#define AG_INC_PTR {(PCB).rx = 1; ag_track();}
#define AG_INIT_TRK (PCB).line = (PCB).column = 1;

static VOID NEAR ag_track(VOID) {
  int ag_k = 0;
  while (ag_k < (PCB).rx) {
    int ag_ch = (PCB).lab[ag_k++];
    switch (ag_ch) {
    case '\n':
      (PCB).column = 1, (PCB).line++;
    case '\r':
    case '\f':
      break;
    case '\t':
      (PCB).column += (TAB_SPACING) + 1 - (PCB).column % (TAB_SPACING);
    default:
      (PCB).column++;
    }
  }
  ag_k = 0;
  while ((PCB).rx < (PCB).fx) (PCB).lab[ag_k++] = (PCB).lab[(PCB).rx++];
  (PCB).fx = ag_k;
  (PCB).rx = 0;
}


#define AG_GET_TKN {\
  if ((PCB).rx < (PCB).fx) {\
    (PCB).input_code = (PCB).lab[(PCB).rx++];\
    (PCB).token_number = (AG_TOKEN_TYPE) AG_TCV((PCB).input_code);}\
  else {\
    GET_INPUT;\
    (PCB).lab[(PCB).fx++] = (PCB).input_code;\
    (PCB).token_number = (AG_TOKEN_TYPE) AG_TCV((PCB).input_code);\
    (PCB).rx++;\
  }\
  {\
    unsigned ag_k = ag_key_index[(PCB).sn];\
    if (ag_k) {\
      unsigned char ag_ch = CONVERT_CASE((PCB).input_code);\
      while (ag_key_ch[ag_k] < ag_ch) ag_k++;\
      if (ag_key_ch[ag_k] == ag_ch) ag_get_key_word(ag_k);\
} } }


#define AG_CLEAR_BACK ((PCB).btsx = 0, (PCB).drt = -1);

#define AG_STACK {\
  (PCB).ss[(PCB).ssx] = (PCB).sn;\
  AG_SAVE_CONTEXT;}

#define AG_CHKOVFLO {if ((PCB).ssx >= AG_PARSER_STACK_SIZE) AG_OVERFLOW;}
#define AG_PROT {if ((PCB).drt >= 0) ag_prot(); else AG_CHKOVFLO;}
#define AG_SET_BACK {if((PCB).drt == -1)\
  (PCB).drt=(PCB).token_number,(PCB).dssx=(PCB).ssx,(PCB).dsn=(PCB).sn;}

static VOID NEAR ag_prot(VOID) {
  int ag_k = (AG_PARSER_STACK_SIZE) - ++(PCB).btsx;
  if (ag_k <= (PCB).ssx) {AG_OVERFLOW; return;}
  (PCB).bts[(PCB).btsx] = (PCB).sn;
  (PCB).bts[ag_k] = (PCB).ssx;
  (PCB).vs[ag_k] = (PCB).vs[(PCB).ssx];
  (PCB).ss[ag_k] = (PCB).ss[(PCB).ssx];
  AG_SWAP_CONTEXT(ag_k, (PCB).ssx);
}

#define AG_UNDO ag_undo()
static VOID NEAR ag_undo(VOID) {
  if ((PCB).drt == -1) return;
  while ((PCB).btsx) {
    int ag_k = (AG_PARSER_STACK_SIZE) - (PCB).btsx;
    (PCB).sn = (PCB).bts[(PCB).btsx--];
    (PCB).ssx = (PCB).bts[ag_k];
    (PCB).vs[(PCB).ssx] = (PCB).vs[ag_k];
    (PCB).ss[(PCB).ssx] = (PCB).ss[ag_k];
    AG_SWAP_CONTEXT((PCB).ssx, ag_k);
  }
  (PCB).token_number = (AG_TOKEN_TYPE) (PCB).drt;
  (PCB).ssx = (PCB).dssx;
  (PCB).sn = (PCB).dsn;
  (PCB).drt = -1;
}



#define AG_TSTT_TYPE CONST unsigned char
static AG_TSTT_TYPE LOCUS ag_tstt[] = {
/*000*/5,3,2,0,1,4,34,35,37,
/*001*/71,70,33,31,25,24,16,13,2,0,7,8,
/*002*/5,3,2,0,1,4,
/*003*/69,68,67,66,65,64,63,62,59,46,25,0,19,20,38,39,41,42,43,44,50,51,52,
  53,54,55,56,57,58,
/*004*/71,70,33,31,25,24,16,13,2,0,
/*005*/3,0,
/*006*/5,3,2,0,1,4,34,
/*007*/5,3,2,0,1,4,34,
/*008*/5,3,2,0,1,4,34,
/*009*/5,3,2,0,1,4,34,
/*010*/5,3,2,0,1,4,34,
/*011*/5,3,2,0,1,4,34,
/*012*/5,3,2,0,1,4,34,
/*013*/5,3,2,0,1,4,34,
/*014*/5,3,2,0,1,4,34,
/*015*/5,3,2,0,1,4,34,
/*016*/71,70,33,31,25,16,13,3,2,0,21,22,23,27,28,
/*017*/5,3,2,0,1,4,34,
/*018*/5,3,2,0,1,4,34,35,
/*019*/5,3,2,0,1,4,34,35,
/*020*/5,3,2,0,1,4,34,35,
/*021*/69,68,67,66,65,64,63,62,59,46,40,25,0,19,20,38,41,42,43,44,50,51,52,
  53,54,55,56,57,58,
/*022*/13,5,3,2,0,1,4,9,10,48,
/*023*/13,5,3,2,0,1,4,9,10,48,
/*024*/13,5,3,2,0,1,4,9,10,48,
/*025*/13,5,3,2,0,1,4,9,10,48,
/*026*/13,5,3,2,0,1,4,9,10,48,
/*027*/13,5,3,2,0,1,4,9,10,48,
/*028*/13,5,3,2,0,1,4,9,10,48,
/*029*/13,5,3,2,0,1,4,9,10,48,
/*030*/13,5,3,2,0,1,4,9,10,48,
/*031*/16,5,3,2,0,1,4,15,
/*032*/71,70,33,31,25,16,13,3,2,0,21,22,23,27,28,
/*033*/71,70,33,31,25,16,13,3,2,0,21,27,28,
/*034*/24,0,
/*035*/49,47,5,3,2,0,1,4,45,
/*036*/71,13,0,11,12,
/*037*/5,3,2,0,1,4,34,
/*038*/60,13,0,9,10,
/*039*/60,13,0,9,10,
/*040*/60,13,0,9,10,
/*041*/60,13,0,9,10,
/*042*/60,13,0,9,10,
/*043*/60,13,0,9,10,
/*044*/60,13,0,9,10,
/*045*/60,13,0,9,10,
/*046*/60,13,0,9,10,
/*047*/71,70,33,31,25,24,13,2,0,17,
/*048*/24,0,
/*049*/5,3,2,0,1,4,34,
/*050*/5,3,2,0,1,4,34,
/*051*/71,13,0,
/*052*/5,3,2,0,1,4,
/*053*/5,3,2,0,1,4,34,35,
/*054*/5,3,2,0,1,4,34,
/*055*/5,3,2,0,1,4,34,35,
/*056*/5,3,2,0,1,4,34,35,
/*057*/5,3,2,0,1,4,34,35,
/*058*/5,3,2,0,1,4,34,35,
/*059*/5,3,2,0,1,4,34,35,
/*060*/5,3,2,0,1,4,34,35,
/*061*/5,3,2,0,1,4,34,35,
/*062*/5,3,2,0,1,4,34,35,
/*063*/71,70,33,31,25,24,16,13,2,0,
/*064*/13,5,3,2,0,1,4,9,10,48,
/*065*/13,5,3,2,0,1,4,9,10,48,
/*066*/31,0,29,30,
/*067*/5,3,2,0,1,4,
/*068*/31,0,29,30,
/*069*/31,0,29,30,
/*070*/31,0,29,30,
/*071*/31,0,29,30,
/*072*/31,0,29,30,
/*073*/31,0,29,30,
/*074*/31,0,29,30,
/*075*/31,0,29,30,
/*076*/25,13,0,9,10,19,20,
/*077*/25,13,0,9,10,19,20,
/*078*/71,70,40,31,25,24,16,13,3,2,0,32,
/*079*/61,31,0,30,
/*080*/61,31,0,30,
/*081*/61,31,0,30,
/*082*/61,31,0,30,
/*083*/61,31,0,30,
/*084*/61,31,0,30,
/*085*/61,31,0,30,
/*086*/61,31,0,30,
/*087*/61,31,0,30,
/*088*/71,70,40,33,31,25,24,16,13,3,2,0,
/*089*/5,3,2,0,1,4,34,35,

};


static unsigned char LOCUS ag_astt[675] = {
  1,1,1,8,1,1,1,1,0,1,1,1,1,1,1,1,1,1,8,1,1,1,9,9,5,3,3,1,1,1,1,1,1,1,1,1,1,
  2,7,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,5,3,7,1,1,1,7,1,1,
  1,1,1,1,7,1,1,1,1,1,1,7,1,1,1,1,1,1,7,1,1,1,1,1,1,7,1,1,1,1,1,1,7,1,1,1,1,
  1,1,7,1,1,1,1,1,1,7,1,1,1,1,1,1,7,1,1,1,1,1,1,7,1,1,1,2,2,2,2,2,2,2,2,2,8,
  1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,5,1,1,1,3,1,1,1,5,1,1,1,3,1,1,1,5,1,1,1,3,1,
  1,1,1,1,1,1,1,1,1,2,2,7,2,1,3,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,9,9,7,3,3,1,1,
  1,2,1,9,9,7,3,3,1,1,1,2,1,9,9,7,3,3,1,1,1,2,1,9,9,7,3,3,1,1,1,2,1,9,9,7,3,
  3,1,1,1,2,1,9,9,7,3,3,1,1,1,2,1,9,9,7,3,3,1,1,1,2,1,9,9,7,3,3,1,1,1,2,1,9,
  9,7,3,3,1,1,1,1,1,9,9,7,3,3,2,2,2,2,2,2,2,2,2,2,8,1,1,1,1,1,2,2,2,2,2,2,2,
  2,2,5,3,3,1,2,7,1,1,1,9,9,7,3,3,3,2,2,5,1,2,1,1,1,7,1,1,1,1,2,7,1,1,1,2,7,
  1,1,1,2,7,1,1,1,2,7,1,1,1,2,7,1,1,1,2,7,1,1,1,2,7,1,1,1,2,7,1,1,1,2,7,1,1,
  2,2,2,2,2,2,2,2,7,1,2,7,1,1,1,7,1,1,1,1,1,1,7,1,1,1,10,10,5,1,9,9,4,3,3,1,
  1,1,8,1,1,1,1,1,1,1,7,1,1,1,1,1,1,8,1,1,1,1,1,1,1,8,1,1,1,1,1,1,1,8,1,1,1,
  1,1,1,1,8,1,1,1,1,1,1,1,8,1,1,1,1,1,1,1,8,1,1,1,1,1,1,1,8,1,1,1,1,1,1,1,8,
  1,1,1,1,10,10,10,10,10,10,2,10,10,7,2,1,9,9,7,3,3,1,1,1,2,1,9,9,7,3,3,1,1,
  1,1,7,1,2,1,9,9,4,3,3,1,7,1,2,1,7,1,2,1,7,1,2,1,7,1,2,1,7,1,2,1,7,1,2,1,7,
  1,2,1,7,1,2,2,2,7,1,1,2,1,2,2,7,1,1,2,1,2,2,2,2,2,2,2,2,2,2,7,1,2,1,7,2,2,
  1,7,2,2,1,7,2,2,1,7,2,2,1,7,2,2,1,7,2,2,1,7,2,2,1,7,2,2,1,7,2,10,10,10,1,
  10,10,10,10,10,10,10,7,1,1,1,5,1,1,1,2
};


static unsigned char LOCUS ag_pstt[] = {
/*000*/1,2,2,3,2,2,2,3,0,
/*001*/4,4,4,4,4,4,4,4,4,5,4,5,
/*002*/1,31,31,33,31,31,
/*003*/6,7,8,9,10,11,12,13,14,15,23,3,43,16,21,21,20,19,18,17,18,18,18,18,
  18,18,18,18,18,
/*004*/5,5,5,5,5,5,5,5,5,7,
/*005*/8,5,
/*006*/1,22,22,6,22,22,22,
/*007*/1,23,23,7,23,23,23,
/*008*/1,24,24,8,24,24,24,
/*009*/1,25,25,9,25,25,25,
/*010*/1,26,26,10,26,26,26,
/*011*/1,27,27,11,27,27,27,
/*012*/1,28,28,12,28,28,28,
/*013*/1,29,29,13,29,29,29,
/*014*/1,30,30,14,30,30,30,
/*015*/1,31,31,15,31,31,31,
/*016*/24,24,24,24,27,24,24,24,24,34,33,33,34,33,32,
/*017*/1,35,35,17,35,35,35,
/*018*/1,2,2,32,2,2,2,42,
/*019*/1,2,2,32,2,2,2,41,
/*020*/1,2,2,32,2,2,2,40,
/*021*/6,7,8,9,10,11,12,13,14,15,39,23,21,43,16,38,20,19,18,17,18,18,18,18,
  18,18,18,18,18,
/*022*/12,1,31,31,22,31,31,37,36,38,
/*023*/12,1,31,31,23,31,31,37,36,39,
/*024*/12,1,31,31,24,31,31,37,36,40,
/*025*/12,1,31,31,25,31,31,37,36,41,
/*026*/12,1,31,31,26,31,31,37,36,42,
/*027*/12,1,31,31,27,31,31,37,36,43,
/*028*/12,1,31,31,28,31,31,37,36,44,
/*029*/12,1,31,31,29,31,31,37,36,45,
/*030*/12,1,31,31,30,31,31,37,36,46,
/*031*/47,1,31,31,31,31,31,45,
/*032*/24,24,24,24,27,24,24,24,24,48,33,33,48,33,32,
/*033*/24,24,24,24,27,24,24,24,24,21,19,19,32,
/*034*/22,34,
/*035*/49,50,1,31,31,35,31,31,44,
/*036*/13,13,9,51,11,
/*037*/1,52,52,37,52,52,52,
/*038*/53,12,38,54,36,
/*039*/55,12,39,54,36,
/*040*/56,12,40,54,36,
/*041*/57,12,41,54,36,
/*042*/58,12,42,54,36,
/*043*/59,12,43,54,36,
/*044*/60,12,44,54,36,
/*045*/61,12,45,54,36,
/*046*/62,12,46,54,36,
/*047*/16,16,16,16,16,16,16,16,47,63,
/*048*/26,48,
/*049*/1,64,64,49,64,64,64,
/*050*/1,65,65,50,65,65,65,
/*051*/14,14,10,
/*052*/1,31,31,48,31,31,
/*053*/1,2,2,66,2,2,2,66,
/*054*/1,67,67,54,67,67,67,
/*055*/1,2,2,68,2,2,2,68,
/*056*/1,2,2,69,2,2,2,69,
/*057*/1,2,2,70,2,2,2,70,
/*058*/1,2,2,71,2,2,2,71,
/*059*/1,2,2,72,2,2,2,72,
/*060*/1,2,2,73,2,2,2,73,
/*061*/1,2,2,74,2,2,2,74,
/*062*/1,2,2,75,2,2,2,75,
/*063*/17,17,17,17,17,17,15,17,17,63,
/*064*/12,1,31,31,64,31,31,37,36,76,
/*065*/12,1,31,31,65,31,31,37,36,77,
/*066*/78,66,79,28,
/*067*/1,31,31,49,31,31,
/*068*/78,68,80,28,
/*069*/78,69,81,28,
/*070*/78,70,82,28,
/*071*/78,71,83,28,
/*072*/78,72,84,28,
/*073*/78,73,85,28,
/*074*/78,74,86,28,
/*075*/78,75,87,28,
/*076*/23,12,76,54,36,47,16,
/*077*/23,12,77,54,36,46,16,
/*078*/35,35,35,35,35,35,35,35,35,35,78,88,
/*079*/67,78,79,29,
/*080*/66,78,80,29,
/*081*/65,78,81,29,
/*082*/64,78,82,29,
/*083*/63,78,83,29,
/*084*/62,78,84,29,
/*085*/61,78,85,29,
/*086*/60,78,86,29,
/*087*/59,78,87,29,
/*088*/36,36,36,89,36,36,36,36,36,36,36,88,
/*089*/1,2,2,32,2,2,2,34,

};


static CONST unsigned short ag_sbt[] = {
     0,   9,  21,  27,  56,  66,  68,  75,  82,  89,  96, 103, 110, 117,
   124, 131, 138, 153, 160, 168, 176, 184, 213, 223, 233, 243, 253, 263,
   273, 283, 293, 303, 311, 326, 339, 341, 350, 355, 362, 367, 372, 377,
   382, 387, 392, 397, 402, 407, 417, 419, 426, 433, 436, 442, 450, 457,
   465, 473, 481, 489, 497, 505, 513, 521, 531, 541, 551, 555, 561, 565,
   569, 573, 577, 581, 585, 589, 593, 600, 607, 619, 623, 627, 631, 635,
   639, 643, 647, 651, 655, 667, 675
};


static CONST unsigned short ag_sbe[] = {
     3,  18,  24,  38,  65,  67,  71,  78,  85,  92,  99, 106, 113, 120,
   127, 134, 147, 156, 163, 171, 179, 196, 217, 227, 237, 247, 257, 267,
   277, 287, 297, 307, 320, 335, 340, 346, 352, 358, 364, 369, 374, 379,
   384, 389, 394, 399, 404, 415, 418, 422, 429, 435, 439, 445, 453, 460,
   468, 476, 484, 492, 500, 508, 516, 530, 535, 545, 552, 558, 562, 566,
   570, 574, 578, 582, 586, 590, 595, 602, 617, 621, 625, 629, 633, 637,
   641, 645, 649, 653, 666, 670, 675
};


static CONST unsigned char ag_fl[] = {
  1,1,1,1,1,2,0,1,3,0,1,2,1,1,2,3,1,2,1,2,0,1,3,1,1,1,3,1,1,2,1,2,0,1,4,
  1,2,1,2,3,2,2,2,1,3,3,4,4,2,3,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7
};

static CONST unsigned char ag_ptt[] = {
    0,  1,  1,  1,  7,  7,  8,  8,  4, 12, 12,  9, 10, 11, 11, 15, 17, 17,
   22, 22, 23, 23, 19, 20, 21, 21, 27, 28, 29, 29, 34, 34, 35, 35, 30, 32,
   32, 39, 39, 37, 38, 38, 38, 41, 42, 44, 45, 45, 48, 48, 43, 43, 43, 43,
   43, 43, 43, 43, 43, 50, 51, 52, 53, 54, 55, 56, 57, 58
};

#define AG_REDUCE(ag_k) AG_COUNT_RULE(ag_k);\
  (PCB).reduction_token = (AG_TOKEN_TYPE) ag_ptt[ag_k];\
  ag_ra();

#define AG_SIMPLE_REDUCE(ag_k) AG_COUNT_RULE(ag_k);\
  (PCB).reduction_token = (AG_TOKEN_TYPE) ag_ptt[ag_k];

#define AG_NSR(procs) while (1) {\
    unsigned ag_t1 = ag_sbe[(PCB).sn] + 1;\
    unsigned ag_t2 = ag_sbt[(PCB).sn+1] - 1;\
    do {\
      unsigned ag_tx = (ag_t1 + ag_t2)/2;\
      if (ag_tstt[ag_tx] < (AG_TSTT_TYPE)(PCB).reduction_token) ag_t1 = ag_tx + 1;\
      else ag_t2 = ag_tx;\
    } while (ag_t1 < ag_t2);\
    ag_ap = ag_pstt[ag_t1];\
    if ((procs[ag_astt[ag_t1]])() == 0) break;\
  }



static VOID NEAR ag_ra(VOID)
{
  switch(ag_rpx[ag_ap]) {
  case   1: V(0,char *) = ag_rp_1(); break;
  case   2: ag_rp_2(V(0,int)); break;
  case   3: ag_rp_3(V(0,int)); break;
  case   4: ag_rp_4(V(1,int)); break;
  case   5: V(0,char *) = ag_rp_5(); break;
  case   6: ag_rp_6(V(0,int)); break;
  case   7: ag_rp_7(V(1,int)); break;
  case   8: V(0,char *) = ag_rp_8(); break;
  case   9: ag_rp_9(); break;
  case  10: ag_rp_10(V(0,int)); break;
  case  11: ag_rp_11(); break;
  case  12: ag_rp_12(); break;
  case  13: V(0,struct STRLIST *) = ag_rp_13(V(0,char *)); break;
  case  14: V(0,struct STRLIST *) = ag_rp_14(V(0,struct STRLIST *), V(1,char *)); break;
  case  15: V(0,char *) = ag_rp_15(); break;
  case  16: ag_rp_16(V(0,int)); break;
  case  17: ag_rp_17(V(1,int)); break;
  case  18: ag_rp_18(); break;
  case  19: ag_rp_19(V(0,char *)); break;
  case  20: ag_rp_20(V(2,char *)); break;
  case  21: ag_rp_21(V(2,struct STRLIST *), V(3,char *)); break;
  case  22: ag_rp_22(V(2,struct STRLIST *), V(3,char *)); break;
  case  23: V(0,struct STRLIST *) = ag_rp_23(V(0,char *)); break;
  case  24: V(0,struct STRLIST *) = ag_rp_24(V(0,struct STRLIST *), V(1,char *)); break;
  case  25: ag_rp_25(V(2,struct STRLIST *), V(5,struct STRLIST *)); break;
  case  26: ag_rp_26(V(2,struct STRLIST *), V(5,struct STRLIST *)); break;
  case  27: ag_rp_27(V(2,struct STRLIST *), V(5,struct STRLIST *)); break;
  case  28: ag_rp_28(V(2,struct STRLIST *), V(5,struct STRLIST *)); break;
  case  29: ag_rp_29(V(2,struct STRLIST *), V(5,struct STRLIST *)); break;
  case  30: ag_rp_30(V(2,struct STRLIST *), V(5,struct STRLIST *)); break;
  case  31: ag_rp_31(V(2,struct STRLIST *), V(5,struct STRLIST *)); break;
  case  32: ag_rp_32(V(2,struct STRLIST *), V(5,struct STRLIST *)); break;
  case  33: ag_rp_33(V(2,struct STRLIST *), V(5,struct STRLIST *)); break;
  }
}


#define TOKEN_NAMES dgen_token_names
CONST char *TOKEN_NAMES[72] = {
  "grammar",
  "space",
  "blank",
  "eol",
  "comment",
  "//",
  "commentCharacter",
  "",
  "",
  "variable",
  "varStart",
  "varRest",
  "",
  "alpha",
  "alphanumeric",
  "string",
  "doubleQuote",
  "stringContents",
  "stringCharacter",
  "block",
  "blockStart",
  "blockComponent",
  "",
  "",
  "'}'",
  "'{'",
  "blockCharacter",
  "nestedBlock",
  "nestStart",
  "initializerList",
  "initializer",
  "'['",
  "initializer contents",
  "']'",
  "",
  "",
  "notCloseBracket",
  "grammar",
  "statement",
  "",
  "eof",
  "embeddedBlock",
  "runStatement",
  "declaration",
  "runHeader",
  "testSpec",
  "runtest",
  "varying",
  "variableList",
  "combining",
  "charDeclaration",
  "stringDeclaration",
  "intDeclaration",
  "doubleDeclaration",
  "FILEDeclaration",
  "intarr2Declaration",
  "ItemDeclaration",
  "ClientDeclaration",
  "InvoiceDeclaration",
  "char",
  "{",
  "}",
  "string",
  "int",
  "double",
  "FILE",
  "intarr2",
  "Item",
  "Client",
  "Invoice",
  "",
  "",

};

#define AG_DIAGNOSE ag_diagnose()

static char ag_msg[82];
static char ag_mst[] = "Missing %s";
static char ag_uet[] = "Unexpected %s";
static char ag_ac[4] = "' '";

static VOID NEAR ag_diagnose(VOID) {
  int ag_snd = (PCB).sn, ag_k;
  CONST char *ag_p;
  CONST char *ag_fmt = ag_uet;

  ag_k = ag_sbt[ag_snd];
  if (*TOKEN_NAMES[ag_tstt[ag_k]] && ag_astt[ag_k + 1] == ag_syn_error) {
    ag_p = TOKEN_NAMES[ag_tstt[ag_k]];
    ag_fmt = ag_mst;
  }
  else if ((PCB).token_number && *TOKEN_NAMES[(PCB).token_number]) {
    ag_p = TOKEN_NAMES[(PCB).token_number];
  }
  else if (isprint(AG_INPUT_CODE) && AG_INPUT_CODE != '\\') {
    ag_ac[1] = AG_INPUT_CODE;
    ag_p = ag_ac;
  }
  else ag_p = NULL;
  sprintf(ag_msg, ag_fmt, ag_p ? ag_p : "input");
  (PCB).error_message = ag_msg;


}
#define AG_RECOVER ag_error_proc
static int NEAR ag_r_shift_accept_proc(VOID);
static int NEAR ag_r_go_to_proc(VOID);
static int NEAR ag_r_shift_reduce_proc(VOID);
static int NEAR ag_r_simple_shift_reduce_proc(VOID);
static int NEAR ag_s_shift_accept_proc(VOID);
static int NEAR ag_s_shift_reduce_proc(VOID);
static int NEAR ag_shift_accept_proc(VOID);
static int NEAR ag_go_to_proc(VOID);
static int NEAR ag_shift_reduce_proc(VOID);
static int NEAR ag_simple_shift_reduce_proc(VOID);
static int NEAR ag_reduce_proc(VOID);
static int NEAR ag_simple_reduce_proc(VOID);
static int NEAR ag_accept_proc(VOID);
static int NEAR ag_error_proc(VOID);
static int NEAR ag_null_go_to_proc(VOID);
static int NEAR ag_skip_proc(VOID);
static int NEAR ag_skip_reduce_proc(VOID);
static int NEAR AG_RECOVER(VOID);

static int (NEAR *ag_r_procs_scan[])(VOID) = {
  ag_r_shift_accept_proc,
  ag_r_go_to_proc,
  ag_r_shift_reduce_proc,
  ag_r_simple_shift_reduce_proc
};

static int (NEAR *ag_s_procs_scan[])(VOID) = {
  ag_s_shift_accept_proc,
  ag_r_go_to_proc,
  ag_s_shift_reduce_proc,
  ag_r_simple_shift_reduce_proc
};

static int (NEAR *ag_gt_procs_scan[])(VOID) = {
  ag_shift_accept_proc,
  ag_go_to_proc,
  ag_shift_reduce_proc,
  ag_simple_shift_reduce_proc,
  ag_reduce_proc,
  ag_simple_reduce_proc,
  ag_accept_proc,
  ag_error_proc,
  ag_null_go_to_proc,
  ag_skip_proc,
  ag_skip_reduce_proc,
  AG_RECOVER
};


#define AG_GT ag_gt_procs_scan
#define AG_SR ag_s_procs_scan
#define AG_RD ag_r_procs_scan


#define AG_RESYNCH {(PCB).exit_flag = AG_SYNTAX_ERROR_CODE;\
        AG_DIAGNOSE; SYNTAX_ERROR; AG_INC_PTR;}
#define AG_INIT_RESYNCH


#define AG_REDUCE_ACTION(ag_k) AG_COUNT_RULE(ag_k);\
  (PCB).reduction_token = (AG_TOKEN_TYPE) ag_ptt[ag_k];\
  ag_ra();

static int NEAR ag_skip_proc(VOID) {
  int ag_t = (PCB).token_number;
  AG_COUNT_RULE(ag_ap);
  AG_CLEAR_BACK;
  do {
    AG_COUNT_RULE(ag_ap);
    AG_TRK_PTR;
    AG_GET_TKN;
  } while ((PCB).token_number == (AG_TOKEN_TYPE) ag_t);
  AG_RST_PTR;
  return 1;
}

static int NEAR ag_skip_reduce_proc(VOID) {
  int ag_t = (PCB).token_number;

  AG_COUNT_RULE(ag_ap);
  AG_CLEAR_BACK;
  do {
    AG_GET_VALUE;
    (PCB).ssx--;
    AG_TRK_PTR;
    ag_ra();
    (PCB).ssx++;
    AG_GET_TKN;
  }
  while ((PCB).token_number == (AG_TOKEN_TYPE) ag_t);
  AG_RST_PTR;
  return 1;
}

static int NEAR ag_r_shift_reduce_proc(VOID) {
  int ag_sd = ag_fl[ag_ap] - 1;
  if (ag_sd) (PCB).sn = (PCB).ss[(PCB).ssx -= ag_sd];
  AG_REDUCE(ag_ap);
  return 1;
}

static int NEAR ag_s_shift_reduce_proc(VOID) {
  int ag_sd = ag_fl[ag_ap] - 1;
  if (ag_sd) (PCB).sn = (PCB).ss[(PCB).ssx -= ag_sd];
  AG_REDUCE(ag_ap);
  return 1;
}

static int NEAR ag_r_simple_shift_reduce_proc(VOID) {
  int ag_sd = ag_fl[ag_ap] - 1;
  if (ag_sd) (PCB).sn = (PCB).ss[(PCB).ssx -= ag_sd];
  AG_SIMPLE_REDUCE(ag_ap);
  return 1;
}

static int NEAR ag_go_to_proc(VOID) {
  AG_CLEAR_BACK;
  AG_CHKOVFLO;
  AG_GET_VALUE;
  AG_STACK;
  (PCB).ssx++;
  (PCB).sn = ag_ap;
  AG_TRK_PTR;
  return 0;
}

static int NEAR ag_null_go_to_proc(VOID) {
  AG_PROT;
  AG_NULL;
  AG_STACK;
  (PCB).ssx++;
  (PCB).sn = ag_ap;
  AG_RST_PTR;
  return (PCB).exit_flag == AG_RUNNING_CODE;
}

static int NEAR ag_r_go_to_proc(VOID) {
  (PCB).ssx++;
  (PCB).sn = ag_ap;
  return 0;
}

static int NEAR ag_accept_proc(VOID) {
  --(PCB).ssx;
  AG_RST_PTR;
  AG_COUNT_RULE(0);
  (PCB).exit_flag = AG_SUCCESS_CODE;
  return 0;
}

static int NEAR ag_shift_accept_proc(VOID) {
  AG_TRK_PTR;
  AG_COUNT_RULE(0);
  (PCB).exit_flag = AG_SUCCESS_CODE;
  return 0;
}

static int NEAR ag_r_shift_accept_proc(VOID) {
  AG_COUNT_RULE(0);
  (PCB).exit_flag = AG_SUCCESS_CODE;
  return 0;
}

static int NEAR ag_s_shift_accept_proc(VOID) {
  AG_COUNT_RULE(0);
  (PCB).exit_flag = AG_SUCCESS_CODE;
  return 0;
}

static int NEAR ag_simple_shift_reduce_proc(VOID) {
  int ag_sd = ag_fl[ag_ap] - 1;
  AG_SIMPLE_REDUCE(ag_ap);
  AG_CLEAR_BACK;
  AG_GET_VALUE;
  if (ag_sd) (PCB).sn = (PCB).ss[(PCB).ssx -= ag_sd];
  else {AG_STACK;}
  AG_TRK_PTR;
  AG_NSR(AG_SR);
  return 0;
}

static int NEAR ag_shift_reduce_proc(VOID) {
  int ag_sd = ag_fl[ag_ap] - 1;
  AG_CLEAR_BACK;
  AG_GET_VALUE;
  if (ag_sd) (PCB).sn = (PCB).ss[(PCB).ssx -= ag_sd];
  else {AG_STACK;}
  AG_TRK_PTR;
  AG_REDUCE(ag_ap);
  AG_NSR(AG_SR);
  return 0;
}

static int NEAR ag_error_proc(VOID) {
  AG_UNDO;
  AG_TRACE_ERROR;
  AG_RST_PTR;
  AG_RESYNCH;
  AG_RST_PTR;
  return (PCB).exit_flag == AG_RUNNING_CODE;
}

static int NEAR ag_reduce_proc(VOID) {
  int ag_sd = ag_fl[ag_ap];
  if (ag_sd) (PCB).sn = (PCB).ss[(PCB).ssx -= ag_sd];
  else {AG_PROT; AG_STACK;}
  AG_RST_PTR;
  AG_REDUCE(ag_ap);
  AG_NSR(AG_RD);
  return (PCB).exit_flag == AG_RUNNING_CODE;
}

static int NEAR ag_simple_reduce_proc(VOID) {
  int ag_sd = ag_fl[ag_ap];
  AG_SIMPLE_REDUCE(ag_ap);
  if (ag_sd) {
    AG_SET_BACK;
    (PCB).sn = (PCB).ss[(PCB).ssx -= ag_sd];
  }
  else {
    AG_PROT;
    AG_NULL;
    AG_STACK;
  }
  AG_RST_PTR;
  AG_NSR(AG_RD);
  return (PCB).exit_flag == AG_RUNNING_CODE;
}


#ifdef AG_PARSE_VALUE
AG_PARSE_VALUE() {
  return AG_VALUE;
}
#endif

AG_INIT_PARSE() {
  AG_INIT_PTR;
  AG_INIT_RESYNCH;
  (PCB).ss[0] = (PCB).sn = (PCB).ssx = 0;
  (PCB).exit_flag = AG_RUNNING_CODE;
  AG_INIT_TRK;
  AG_CLEAR_BACK;
}

AG_PARSE() {
  AG_INITIALIZE();
  (PCB).exit_flag = AG_RUNNING_CODE;
  while ((PCB).exit_flag == AG_RUNNING_CODE) {
    unsigned ag_t1 = ag_sbt[(PCB).sn];
    if (ag_tstt[ag_t1]) {
      unsigned ag_t2 = ag_sbe[(PCB).sn] - 1;
      AG_GET_TKN;
      do {
        unsigned ag_tx = (ag_t1 + ag_t2)/2;
        if (ag_tstt[ag_tx] > (AG_TSTT_TYPE)(PCB).token_number)
          ag_t1 = ag_tx + 1;
        else ag_t2 = ag_tx;
      } while (ag_t1 < ag_t2);
      if (ag_tstt[ag_t1] != (AG_TSTT_TYPE)(PCB).token_number)
        ag_t1 = ag_sbe[(PCB).sn];
    }
    ag_ap = ag_pstt[ag_t1];
    (AG_GT[ag_astt[ag_t1]])();
  }
}



VOID main() {
  dgen();
}