// File: t001.tst
// Tests for Invoice::totalDiscount()
{
#include "testgen.h"
#include "invoice.h"
}
// set declarations
Client someClient {
  [Client(RETAIL)]
  [Client(WHOLESALE)]
  [Client(FOREIGN)]
}
int numItems {[1] [0] [4] }
Item someItem otherItem {
  [Item(100, 10, 1.00)]
  [Item(1100, 5, 5.00)]
}
Invoice theInvoice { [Invoice(&someClient)] }
// test run declarations
runtest "r1" combining someClient
             theInvoice numItems someItem
{
   cout << "TESTING CLIENTS & NO. OF ITEMS\n";
   cout << "client: " << someClient << "\n";
   cout << "items are:\n";
   for (int i = 0; i < numItems; i++) {
     theInvoice.addItem(&someItem);
     cout << " " << someItem << "\n";
   }
   cout << "total discount: "
        << theInvoice.totalDiscount() << "\n";
}

runtest "r2" combining someClient
             theInvoice someItem otherItem
{
   cout << "TESTING MIXING ITEMS\n";
   cout << "client: " << someClient << "\n";
   cout << "items are:\n";
   theInvoice.addItem(&someItem);
   cout << " " << someItem << "\n";
   theInvoice.addItem(&otherItem);
   cout << " " << otherItem << "\n";
   cout << "total discount: "
        << theInvoice.totalDiscount() << "\n";
}
