Listing 3 - A test program for a queue of void * used as a queue of str

//
// strtst3.cpp - test genq3 using str elements
//

#include <iostream.h>

#include "genq3.h"
#include "showheap.h"
#include "str.h"

#define DIM(a) (sizeof(a)/sizeof(a[0]))

void print_str(void *e)
    {
    cout << " " << *(str *)e;
    }

void test()
    {
    char c;
    size_t qn;
    str qe;
    str *pqe;
    void *pv;
    genq q[4];
    while (cin >> c)
        {
        showheap();
        if (c == 'q')
            break;
        if (c == 'a')
            {
            cin >> qn >> qe;
            if (qn >= DIM(q))
                cout << "no such queue\n";
            else
                q[qn].append(new str(qe));
            }
        else if (c == 'c')
            {
            cin >> qn;
            if (qn >= DIM(q))
                cout << "no such queue\n";
            else
                q[qn].clear();
            }
        else if (c == 'r')
            {
            cin >> qn;
            if (qn >= DIM(q))
                cout << "no such queue\n";
            else if (q[qn].remove(pv))
                {
                pqe = (str *)pv;
                cout << "removed " << *pqe << '\n';
                delete pqe;
                }
            else
                cout << "q[" << qn << "] is empty\n";
            }
        else
            continue;
        for (size_t i = 0; i < DIM(q); ++i)
            {
            cout << i << ':';
            q[i].apply(print_str);
            cout << "\n";
            }
        }
    }

int main()
    {
    showheap();
    test();
    showheap();
    return 0;
    }
