/******************************************************
 * BGIGRH.C - required graphics functions
 *  using Borland Graphic Interface
 *
 * The routines in this module adapt themselves to
 * whatever video hardware a driver is available for.
 *
 * for TurboC V2.0
 *
 * by Anton Treuenfels
 *
 * first created:  01/01/93
 * last revision:  04/11/94
 *****************************************************/

/*****************************
 * Header Section - BGIGRH.H *
 *****************************/

#ifndef SEEN_BGIGRH
#define SEEN_BGIGRH

/* exported variables */

extern long MaxXPos, MaxYPos;
extern int MaxColor;

/* function prototypes */

void abspoint(int *, int *);
void grhopen(void);
void grhclose(void);
void grhfpair(int, int, int, int);
void grhrect(int, int, int, int);
void grhcircle(int, int, int, int);

#endif

/***************************
 * Code Section - BGIGRH.C *
 ***************************/

#include <stdio.h>
#include <stdlib.h>
#include <graphics.h>

#include "usrdef.h"

/* change the following definition if the driver
   files are not there or in the current directory */

#define DRIVERPATH "C:\\TURBOC\\BGI"

long MaxXPos, MaxYPos;  /* physical screen size */
int MaxColor;           /* maximum color index */

/*****************************************************/

/* convert relative point to absolute */

void abspoint(int *xpos, int *ypos) {

	if (*xpos <= 0)
		*xpos = 0;
	else if (*xpos >= 100)
		*xpos = (int)MaxXPos;
	else
		*xpos = (int)(*xpos * MaxXPos / 100);

	if (*ypos <= 0)
		*ypos = 0;
	else if (*ypos >= 100)
		*ypos = (int)MaxYPos;
	else
		*ypos = (int)(*ypos * MaxYPos / 100);
}

/* convert relative rectangle to absolute */

static void absrect(int *lft, int *top,
		 int *rgt, int *bot) {

	int tmp;

	if (*lft > *rgt) {
		tmp = *lft;  *lft = *rgt;  *rgt = tmp;
	}
	if (*top > *bot) {
		tmp = *top;  *top = *bot;  *bot = tmp;
	}
	abspoint(lft, top);
	abspoint(rgt, bot);
}

/* init bitmapped graphics operations */

void grhopen(void) {

	int gdriver, gmode, gerror;

	gdriver = DETECT;
	initgraph(&gdriver, &gmode, DRIVERPATH);
	gerror = graphresult();
	if (gerror < 0) {
		printf("\ngraphics error:  %s.\n",
			 grapherrormsg(gerror));
		exit(EXIT_FAILURE);
	}

	MaxXPos = getmaxx();
	MaxYPos = getmaxy();
	MaxColor = getmaxcolor();

	setcolor(MaxColor);
	setbkcolor(0);
}

/* end bitmapped graphics operations */

void grhclose(void) {

	closegraph();
}

/* draw sideways 'F' pair */

void grhfpair(int lft, int top, int rgt, int bot) {

	int dx, dy, dx2, dx3, dy3;

	setlinestyle(SOLID_LINE, 0x0000, NORM_WIDTH);
	absrect(&lft, &top, &rgt, &bot);
	dx = (rgt - lft + 1) / 7;
	dy = (bot - top + 1) / 5;
	dx2 = 2 * dx;  dx3 = 3 * dx;  dy3 = 3 * dy;
	rectangle(lft, top, rgt, top + dy);
	rectangle(lft, bot - dy, rgt, bot);
	rectangle(rgt - dx, top + dy, rgt, top + dy3);
	rectangle(lft, bot - dy3, lft + dx, bot - dy);
	rectangle(lft + dx2, top + dy,
		 lft + dx3, top + dy3);
	rectangle(rgt - dx3, bot - dy3,
		 rgt - dx2, bot - dy);
}

/* draw rectangle */

void grhrect(int lft, int top, int rgt, int bot) {

	setlinestyle(SOLID_LINE, 0x0000, NORM_WIDTH);
	absrect(&lft, &top, &rgt, &bot);
	rectangle(lft, top, rgt, bot);
}

/* draw circle */

void grhcircle(int lft, int top, int rgt, int bot) {

	int radius;

	setlinestyle(SOLID_LINE, 0x0000, NORM_WIDTH);
	absrect(&lft, &top, &rgt, &bot);
	radius = min((rgt - lft)/2, (bot - top)/2);
	circle((lft + rgt)/2, (top + bot)/2, radius);
}

