/*****************************************************
 * BGIPIXEL.C - this is a compiler-specific function
 * to examine and fill pixels.
z *
 * for TurboC V 2.0
 *
 * by Anton Treuenfels
 * last revision:  04/11/94
 *****************************************************/

#include "usrdef.h"

/*******************************
 * Header Section - BGIPIXEL.C *
 *******************************/

#ifndef SEEN_BGIPIX
#define SEEN_BGIPIX

/* function prototype */

void checkflood(int, int, Boolean);

#endif

/*****************************
 * Code Section - BGIPIXEL.C *
 *****************************/

#include <stdio.h>
#include <stdlib.h>
#include <graphics.h>

#include "bgigrh.h"
#include "flood.h"
#include "uflood.h"

/* efficiency counts */

static long readcnt, writecnt;

/*****************************************************/

/* check and fill pixel */

static int bgipixel(int xpos, int ypos) {

	int pixval;

	readcnt++;
	if ((ypos >= 0) && (ypos <= MaxYPos)
		&& (xpos >= 0) && (xpos <= MaxXPos)) {
			pixval = getpixel(xpos, ypos);
			if (pixval == 0) {
				writecnt++;
				if (xpos & 1)
					putpixel(xpos, ypos, MaxColor);
				return(TRUE);
			}
				pixval = max(0, pixval - 1);
				putpixel(xpos, ypos, pixval);
	}
	return(FALSE);
}

/* checking fill using Borland Graphics Interface */

void checkflood(int xpos, int ypos, Boolean fastfill) {

	char txtbuf[80];

	readcnt = writecnt = 0;
	abspoint(&xpos, &ypos);
	if (fastfill)
		flood(xpos, ypos, bgipixel);
	else
		uflood(xpos, ypos, bgipixel);
	sprintf(txtbuf, "Pixels read=    %ld", readcnt);
	outtextxy(1, 1, txtbuf);
	sprintf(txtbuf, "Pixels written= %ld", writecnt);
	outtextxy(1, 10, txtbuf);
	sprintf(txtbuf, "Write/Read= %.2f",
		 (float)writecnt / (float)readcnt);
	outtextxy(1, 21, txtbuf);
}
